/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfigurationImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAResult;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import com.mysql.clusterj.openjpa.NdbOpenJPAUtility;
import com.mysql.clusterj.openjpa.NdbOpenJPAValueHandler;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryDomainType;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.RelationFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.StringId;

public class NdbOpenJPADomainFieldHandlerImpl
extends AbstractDomainFieldHandlerImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPADomainFieldHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPADomainFieldHandlerImpl.class);
    private static com.mysql.clusterj.core.store.Column[] emptyStoreColumns = new com.mysql.clusterj.core.store.Column[0];
    private FieldMapping fieldMapping;
    private Column column;
    private int javaType;
    private Field oidField;
    private String javaTypeName;
    private boolean isRelation = false;
    private boolean isMappedBy = false;
    private boolean isToOne = false;
    private boolean isEmbedded;
    private ClassMapping relatedTypeMapping = null;
    private NdbOpenJPADomainTypeHandlerImpl<?> relatedDomainTypeHandler = null;
    private FieldMapping relatedFieldMapping;
    private FieldMapping mappedByMapping;
    private Class<?> relatedType = null;
    private String relatedTypeName = null;
    private Column[] columns;
    private com.mysql.clusterj.core.store.Column[] storeColumns = emptyStoreColumns;
    private String relatedFieldName;
    private boolean supported = true;
    private String reason = "";
    private RelatedFieldLoadManager relatedFieldLoadManager;
    public AbstractDomainFieldHandlerImpl.ObjectOperationHandler[] objectOperationHandlers = new AbstractDomainFieldHandlerImpl.ObjectOperationHandler[]{objectOperationHandlerBoolean, objectOperationHandlerByte, objectOperationHandlerUnsupportedType, objectOperationHandlerDouble, objectOperationHandlerFloat, objectOperationHandlerInt, objectOperationHandlerLong, objectOperationHandlerShort, objectOperationHandlerUnsupportedType, objectOperationHandlerString, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerJavaUtilDate, objectOperationHandlerUnsupportedType, objectOperationHandlerObjectBoolean, objectOperationHandlerObjectByte, objectOperationHandlerUnsupportedType, objectOperationHandlerObjectDouble, objectOperationHandlerObjectFloat, objectOperationHandlerObjectInteger, objectOperationHandlerObjectLong, objectOperationHandlerObjectShort, objectOperationHandlerDecimal, objectOperationHandlerBigInteger, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType, objectOperationHandlerUnsupportedType};
    static AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandlerRelationIntField = new ObjectOperationHandlerRelationField(){

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            OpenJPAStateManager openJPAStateManager = this.getRelatedStateManager(valueHandler, abstractDomainFieldHandlerImpl);
            if (openJPAStateManager == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
                operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
            } else {
                Object object = openJPAStateManager.getObjectId();
                if (object == null) {
                    operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
                    if (logger.isDetailEnabled()) {
                        logger.detail("Related object class: " + openJPAStateManager.getMetaData().getTypeAlias() + " object id: " + object);
                    }
                } else {
                    int n = this.getInt(object);
                    if (logger.isDetailEnabled()) {
                        logger.detail("Related object class: " + openJPAStateManager.getMetaData().getTypeAlias() + " key: " + n);
                    }
                    operation.setInt(abstractDomainFieldHandlerImpl.getStoreColumn(), n);
                }
            }
        }

        @Override
        public String handler() {
            return "Object ToOne Int key.";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (object == null) {
                operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
            } else {
                operation.setInt(abstractDomainFieldHandlerImpl.getStoreColumn(), (Integer)object);
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            Field field = ((NdbOpenJPADomainFieldHandlerImpl)abstractDomainFieldHandlerImpl).getOidField();
            Object object2 = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, object);
            if (logger.isDetailEnabled()) {
                logger.detail("For column: " + abstractDomainFieldHandlerImpl.getColumnName() + " oid: " + object + " value: " + object2);
            }
            scanFilter.cmpInt(binaryCondition, abstractDomainFieldHandlerImpl.getStoreColumn(), (Integer)object2);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundInt(abstractDomainFieldHandlerImpl.getStoreColumn(), boundType, (Integer)object);
        }
    };
    static AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandlerRelationLongField = new ObjectOperationHandlerRelationField(){

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            OpenJPAStateManager openJPAStateManager = this.getRelatedStateManager(valueHandler, abstractDomainFieldHandlerImpl);
            if (openJPAStateManager == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
                operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
            } else {
                long l = this.getLong(openJPAStateManager.getObjectId());
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object class: " + openJPAStateManager.getMetaData().getTypeAlias() + " key: " + l);
                }
                operation.setLong(abstractDomainFieldHandlerImpl.getStoreColumn(), l);
            }
        }

        @Override
        public String handler() {
            return "Object ToOne Long key.";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (object == null) {
                operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
            } else {
                operation.setLong(abstractDomainFieldHandlerImpl.getStoreColumn(), (Long)object);
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            Field field = ((NdbOpenJPADomainFieldHandlerImpl)abstractDomainFieldHandlerImpl).getOidField();
            Object object2 = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, object);
            if (logger.isDetailEnabled()) {
                logger.detail("For column: " + abstractDomainFieldHandlerImpl.getColumnName() + " oid: " + object + " value: " + object2);
            }
            scanFilter.cmpLong(binaryCondition, abstractDomainFieldHandlerImpl.getStoreColumn(), (Long)object2);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundLong(abstractDomainFieldHandlerImpl.getStoreColumn(), boundType, (Long)object);
        }
    };
    static AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandlerRelationStringField = new ObjectOperationHandlerRelationField(){

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            OpenJPAStateManager openJPAStateManager = this.getRelatedStateManager(valueHandler, abstractDomainFieldHandlerImpl);
            if (openJPAStateManager == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
                operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
            } else {
                String string = this.getString(openJPAStateManager.getObjectId());
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object class: " + openJPAStateManager.getMetaData().getTypeAlias() + " key: " + string);
                }
                operation.setString(abstractDomainFieldHandlerImpl.getStoreColumn(), string);
            }
        }

        @Override
        public String handler() {
            return "Object ToOne String key.";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            if (object == null) {
                operation.setNull(abstractDomainFieldHandlerImpl.getStoreColumn());
            } else {
                operation.setString(abstractDomainFieldHandlerImpl.getStoreColumn(), (String)object);
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            Field field = ((NdbOpenJPADomainFieldHandlerImpl)abstractDomainFieldHandlerImpl).getOidField();
            Object object2 = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, object);
            if (logger.isDetailEnabled()) {
                logger.detail("For column: " + abstractDomainFieldHandlerImpl.getColumnName() + " oid: " + object + " filter.cmpString: " + object2);
            }
            scanFilter.cmpString(binaryCondition, abstractDomainFieldHandlerImpl.getStoreColumn(), (String)object2);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            indexScanOperation.setBoundString(abstractDomainFieldHandlerImpl.getStoreColumn(), boundType, (String)object);
        }
    };
    static ObjectOperationHandlerRelationField objectOperationHandlerRelationCompositeField = new ObjectOperationHandlerRelationField(){

        @Override
        public String handler() {
            return "Composite key.";
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl2 : abstractDomainFieldHandlerImpl.compositeDomainFieldHandlers) {
                abstractDomainFieldHandlerImpl2.operationGetValue(operation);
            }
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            if (!ScanFilter.BinaryCondition.COND_EQ.equals((Object)binaryCondition)) {
                throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Filter_Condition", (Object)binaryCondition));
            }
            scanFilter.begin();
            for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl2 : abstractDomainFieldHandlerImpl.compositeDomainFieldHandlers) {
                if (object != null) {
                    abstractDomainFieldHandlerImpl2.filterCompareValue(object, binaryCondition, scanFilter);
                    continue;
                }
                abstractDomainFieldHandlerImpl2.filterCompareValue(null, binaryCondition, scanFilter);
            }
            scanFilter.end();
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler, Operation operation) {
            OpenJPAStateManager openJPAStateManager = this.getRelatedStateManager(valueHandler, abstractDomainFieldHandlerImpl);
            OpenJPAId openJPAId = null;
            Object object = null;
            if (openJPAStateManager == null) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object is null");
                }
            } else {
                if (logger.isDetailEnabled()) {
                    logger.detail("Related object class: " + openJPAStateManager.getMetaData().getTypeAlias() + " key: " + openJPAId);
                }
                openJPAId = (OpenJPAId)openJPAStateManager.getObjectId();
                object = openJPAId.getIdObject();
            }
            for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl2 : abstractDomainFieldHandlerImpl.compositeDomainFieldHandlers) {
                Object object2 = null;
                if (openJPAStateManager != null) {
                    Field field = ((NdbOpenJPADomainFieldHandlerImpl)abstractDomainFieldHandlerImpl2).getOidField();
                    object2 = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, object);
                    abstractDomainFieldHandlerImpl2.operationSetValue(object2, operation);
                    continue;
                }
                abstractDomainFieldHandlerImpl2.operationSetValue((Object)null, operation);
            }
        }

        @Override
        public Map<String, Object> createParameterMap(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, QueryDomainType<?> queryDomainType, Object object) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Predicate predicate = null;
            for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl : ndbOpenJPADomainFieldHandlerImpl.compositeDomainFieldHandlers) {
                String string = abstractDomainFieldHandlerImpl.getColumnName();
                PredicateOperand predicateOperand = queryDomainType.param(string);
                PredicateOperand predicateOperand2 = queryDomainType.get(string);
                if (predicate == null) {
                    predicate = predicateOperand2.equal(predicateOperand);
                } else {
                    predicate.and(predicateOperand2.equal(predicateOperand));
                }
                Object object2 = ndbOpenJPADomainFieldHandlerImpl.getKeyValue(object);
                hashMap.put(string, object2);
                if (!logger.isDetailEnabled()) continue;
                logger.detail("Map.Entry key: " + string + ", value: " + object2);
            }
            queryDomainType.where(predicate);
            return hashMap;
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl2 : abstractDomainFieldHandlerImpl.compositeDomainFieldHandlers) {
                Field field = ((NdbOpenJPADomainFieldHandlerImpl)abstractDomainFieldHandlerImpl2).getOidField();
                Object object2 = NdbOpenJPADomainFieldHandlerImpl.getKeyValue(field, object);
                abstractDomainFieldHandlerImpl2.operationSetBounds(object2, boundType, indexScanOperation);
            }
        }
    };

    public FieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    /*
     * WARNING - void declaration
     */
    public NdbOpenJPADomainFieldHandlerImpl(Dictionary dictionary, NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl, NdbOpenJPAConfigurationImpl ndbOpenJPAConfigurationImpl, FieldMapping fieldMapping) {
        Column column;
        Object object;
        Object object2;
        String string = null;
        this.fieldMapping = fieldMapping;
        this.domainTypeHandler = ndbOpenJPADomainTypeHandlerImpl;
        this.name = fieldMapping.getName();
        this.fieldNumber = fieldMapping.getIndex();
        this.primaryKey = fieldMapping.isPrimaryKey();
        this.columns = fieldMapping.getColumns();
        this.objectOperationHandlerDelegate = objectOperationHandlerUnsupportedType;
        this.mappedByMapping = fieldMapping.getMappedByMapping();
        this.isMappedBy = this.mappedByMapping != null;
        this.isToOne = fieldMapping.getStrategy() instanceof RelationFieldStrategy;
        if (this.isMappedBy) {
            this.relatedType = this.mappedByMapping.getDeclaringType();
            this.relatedFieldMapping = fieldMapping.getMappedByMapping();
        }
        this.relatedTypeMapping = fieldMapping.getDeclaredTypeMapping();
        if (this.relatedTypeMapping != null) {
            this.relatedType = this.relatedTypeMapping.getDescribedType();
        }
        if (this.relatedType != null) {
            this.relatedTypeName = this.relatedType.getName();
        }
        this.isRelation = fieldMapping.getStrategy().getClass().getName().contains("Relation");
        this.isEmbedded = fieldMapping.getStrategy().getClass().getName().contains("Embed");
        if (logger.isDetailEnabled()) {
            logger.detail("field: " + this.name + " strategy: " + fieldMapping.getStrategy().getClass().getName() + " with " + this.columns.length + " columns.");
        }
        if (!(this.isRelation | this.isEmbedded)) {
            if (this.columns.length == 1) {
                this.column = this.columns[0];
                this.columnName = this.column.getName();
                object2 = ndbOpenJPADomainTypeHandlerImpl.getTable();
                if (object2 == null) {
                    string = local.message("ERR_No_Mapped_Table", (Object)ndbOpenJPADomainTypeHandlerImpl.getName());
                    this.setUnsupported(string);
                    return;
                }
                this.storeColumn = object2.getColumn(this.columnName);
                if (this.storeColumn == null) {
                    string = local.message("ERR_No_Column", this.name, object2.getName(), this.columnName);
                    this.setUnsupported(string);
                    return;
                }
                this.storeColumns = new com.mysql.clusterj.core.store.Column[]{this.storeColumn};
                this.charsetName = this.storeColumn.getCharsetName();
                this.javaType = this.column.getJavaType();
                this.objectOperationHandlerDelegate = this.getObjectOperationHandler(this.javaType);
                if (objectOperationHandlerUnsupportedType.equals(this.objectOperationHandlerDelegate)) {
                    string = local.message("ERR_Unsupported_Meta_Type", this.javaType);
                    this.setUnsupported(string);
                    return;
                }
                this.javaTypeName = NdbOpenJPAUtility.getJavaTypeName(this.javaType);
                if (this.storeColumn.isPrimaryKey()) {
                    ndbOpenJPADomainTypeHandlerImpl.registerPrimaryKeyColumn(this, this.storeColumn.getName());
                }
            } else {
                if (this.columns.length > 1) {
                    void object3;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = "";
                    Column[] columnArray = this.columns;
                    int n = columnArray.length;
                    boolean bl = false;
                    while (object3 < n) {
                        Column column2 = columnArray[object3];
                        stringBuffer.append(string2);
                        stringBuffer.append(column2.getName());
                        string2 = ", ";
                        ++object3;
                    }
                    string = local.message("ERR_More_Than_One_Column_Mapped_To_A_Field", ndbOpenJPADomainTypeHandlerImpl.getName(), this.name, stringBuffer);
                    logger.info(string);
                    this.setUnsupported(string);
                    return;
                }
                if (this.columns.length == 0) {
                    string = local.message("ERR_No_Column_Mapped_To_A_Field", ndbOpenJPADomainTypeHandlerImpl.getName(), this.name, fieldMapping.getTable(), fieldMapping.getStrategy().getClass().getName());
                    logger.info(string);
                    this.setUnsupported(string);
                    return;
                }
            }
            if (this.primaryKey) {
                this.oidField = NdbOpenJPADomainFieldHandlerImpl.getFieldForOidClass(this, ndbOpenJPADomainTypeHandlerImpl.getOidClass(), this.name);
                this.indexNames.add("PRIMARY");
                switch (this.javaType) {
                    case 5: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyInt;
                        break;
                    }
                    case 21: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyObjectInteger;
                        break;
                    }
                    case 6: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyLong;
                        break;
                    }
                    case 22: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyObjectLong;
                        break;
                    }
                    case 9: {
                        this.objectOperationHandlerDelegate = objectOperationHandlerKeyString;
                        break;
                    }
                    default: {
                        string = local.message("ERR_Illegal_Primary_Key_Type", ndbOpenJPADomainTypeHandlerImpl.getName(), this.name, this.columnName, this.javaTypeName);
                        logger.info(string);
                        this.setUnsupported(string);
                        break;
                    }
                }
            }
        } else if (this.isRelation) {
            if (this.columns.length == 1) {
                this.column = this.columns[0];
                this.columnName = this.column.getName();
                this.columnNames = new String[]{this.columnName};
                object2 = ndbOpenJPADomainTypeHandlerImpl.getTable();
                this.storeColumn = object2.getColumn(this.columnName);
                if (this.storeColumn == null) {
                    string = local.message("ERR_No_Column", this.name, object2.getName(), this.columnName);
                    this.setUnsupported(string);
                    return;
                }
                this.storeColumns = new com.mysql.clusterj.core.store.Column[]{this.storeColumn};
                this.javaType = this.column.getJavaType();
                this.javaTypeName = NdbOpenJPAUtility.getJavaTypeName(this.javaType);
                this.objectOperationHandlerDelegate = this.getObjectOperationHandlerRelationDelegate(this.javaType);
                if (this.objectOperationHandlerDelegate == null) {
                    return;
                }
            } else if (this.columns.length == 0) {
                if (this.isMappedBy) {
                    this.objectOperationHandlerDelegate = objectOperationHandlerVirtualType;
                } else {
                    string = local.message("ERR_No_Columns_And_Not_Mapped_By", (Object)this.domainTypeHandler.getName(), (Object)this.name);
                    logger.info(string);
                    this.setUnsupported(string);
                }
            } else if (this.isMappedBy) {
                this.objectOperationHandlerDelegate = objectOperationHandlerVirtualType;
            } else {
                this.relatedTypeMapping = fieldMapping.getDeclaredTypeMapping();
                this.relatedType = this.relatedTypeMapping.getDescribedType();
                object2 = this.relatedTypeMapping.getObjectIdType();
                if (logger.isDetailEnabled()) {
                    logger.detail("For class: " + ndbOpenJPADomainTypeHandlerImpl.getName() + " field: " + this.name + " related type is: " + this.relatedType.getName() + " objectid type: " + ((Class)object2).getName());
                }
                this.compositeDomainFieldHandlers = new NdbOpenJPADomainFieldHandlerImpl[this.columns.length];
                this.columnNames = new String[this.columns.length];
                this.storeColumns = new com.mysql.clusterj.core.store.Column[this.columns.length];
                for (int i = 0; i < this.columns.length; ++i) {
                    NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl;
                    object = new StringBuffer();
                    column = this.columns[i];
                    String string2 = column.getName();
                    Table table = ndbOpenJPADomainTypeHandlerImpl.getTable();
                    com.mysql.clusterj.core.store.Column column3 = table.getColumn(string2);
                    if (column3 == null) {
                        string = local.message("ERR_No_Column", this.name, table.getName(), string2);
                        logger.info(string);
                        this.setUnsupported(string);
                        return;
                    }
                    this.storeColumns[i] = column3;
                    this.columnNames[i] = string2;
                    Column column4 = fieldMapping.getForeignKey();
                    Column column5 = column4.getPrimaryKeyColumn(column);
                    if (logger.isDetailEnabled()) {
                        ((StringBuffer)object).append(" column: " + string2);
                        ((StringBuffer)object).append(" fk-> " + column4);
                        ((StringBuffer)object).append(" pkColumn-> " + column5);
                        logger.detail(((StringBuffer)object).toString());
                    }
                    if (!(ndbOpenJPADomainFieldHandlerImpl = new NdbOpenJPADomainFieldHandlerImpl(this, column, column5)).isSupported()) {
                        string = ndbOpenJPADomainFieldHandlerImpl.getReason();
                        this.setUnsupported(string);
                        return;
                    }
                    this.compositeDomainFieldHandlers[i] = ndbOpenJPADomainFieldHandlerImpl;
                }
                this.objectOperationHandlerDelegate = objectOperationHandlerRelationCompositeField;
            }
        } else {
            string = local.message("ERR_Embedded_Fields_Not_Supported", (Object)this.domainTypeHandler.getName(), (Object)this.name);
            logger.info(string);
            this.setUnsupported(string);
            return;
        }
        if ((object2 = fieldMapping.getJoinIndex()) != null) {
            String string3 = object2.getName();
            object = object2.getColumns();
            if (logger.isDetailEnabled()) {
                column = new StringBuilder("Found index name ");
                column.append(string3);
                column.append(" [");
                for (Column column4 : object) {
                    if (!logger.isDetailEnabled()) continue;
                    column.append(column4.getName());
                    column.append(" ");
                }
                column.append("]");
                logger.detail(column.toString());
            }
        }
        if ((object2 = fieldMapping.getValueIndex()) != null) {
            StringBuffer stringBuffer = null;
            if (logger.isDetailEnabled()) {
                stringBuffer = new StringBuffer("Found index ");
            }
            object = object2.getName();
            if (logger.isDetailEnabled()) {
                stringBuffer.append((String)object + " [ ");
            }
            for (Column column4 : column = object2.getColumns()) {
                if (!logger.isDetailEnabled()) continue;
                stringBuffer.append(column4.getName() + " ");
            }
            if (logger.isDetailEnabled()) {
                stringBuffer.append("]");
            }
            if (logger.isDetailEnabled()) {
                logger.detail(stringBuffer.toString());
            }
            this.indices = ndbOpenJPADomainTypeHandlerImpl.createIndexHandler(this, dictionary, (String)object);
        }
        this.type = fieldMapping.getType();
        if (logger.isTraceEnabled()) {
            logger.trace(" number: " + this.fieldNumber + " name: " + this.name + " column: " + this.columnName + " Java type: " + this.javaType + " strategy: " + this.toString(fieldMapping.getStrategy()) + " ObjectOperationHandler: " + this.objectOperationHandlerDelegate.handler());
        }
    }

    public void initializeRelations() {
        if (this.isRelation) {
            if (this.isMappedBy && this.isToOne) {
                this.relatedDomainTypeHandler = ((NdbOpenJPADomainTypeHandlerImpl)this.domainTypeHandler).registerDependency(this.relatedTypeMapping);
                this.relatedFieldName = this.relatedFieldMapping.getName();
                this.relatedFieldLoadManager = new RelatedFieldLoadManager(){

                    @Override
                    public void load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, JDBCFetchConfiguration jDBCFetchConfiguration) throws SQLException {
                        SessionSPI sessionSPI = ndbOpenJPAStoreManager.getSession();
                        sessionSPI.startAutoTransaction();
                        NdbOpenJPAResult ndbOpenJPAResult = NdbOpenJPADomainFieldHandlerImpl.this.queryRelated(openJPAStateManager, ndbOpenJPAStoreManager);
                        Object object = null;
                        try {
                            if (ndbOpenJPAResult.next()) {
                                object = ndbOpenJPAStoreManager.load(NdbOpenJPADomainFieldHandlerImpl.this.relatedTypeMapping, jDBCFetchConfiguration, null, ndbOpenJPAResult);
                            }
                            if (logger.isDetailEnabled()) {
                                logger.detail("related object is: " + object);
                            }
                            openJPAStateManager.storeObjectField(NdbOpenJPADomainFieldHandlerImpl.this.fieldNumber, object);
                            sessionSPI.endAutoTransaction();
                        }
                        catch (Exception exception) {
                            sessionSPI.failAutoTransaction();
                        }
                    }
                };
                if (logger.isDetailEnabled()) {
                    logger.detail("Single-valued relationship field " + this.name + " is mapped by " + this.relatedTypeName + " field " + this.relatedFieldName + " with relatedDomainTypeHandler " + this.relatedDomainTypeHandler.getName());
                }
            } else if (this.isMappedBy && !this.isToOne) {
                this.relatedTypeMapping = this.mappedByMapping.getDeclaringMapping();
                this.relatedDomainTypeHandler = ((NdbOpenJPADomainTypeHandlerImpl)this.domainTypeHandler).registerDependency(this.relatedTypeMapping);
                this.relatedFieldName = this.mappedByMapping.getName();
                this.relatedTypeName = this.relatedDomainTypeHandler.getName();
                if (logger.isDetailEnabled()) {
                    logger.detail("Multi-valued relationship field " + this.name + " is mapped by " + this.relatedTypeName + " field " + this.relatedFieldName);
                }
                this.relatedFieldLoadManager = new RelatedFieldLoadManager(){

                    @Override
                    public void load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, JDBCFetchConfiguration jDBCFetchConfiguration) throws SQLException {
                        SessionSPI sessionSPI = ndbOpenJPAStoreManager.getSession();
                        sessionSPI.startAutoTransaction();
                        try {
                            NdbOpenJPAResult ndbOpenJPAResult = NdbOpenJPADomainFieldHandlerImpl.this.queryRelated(openJPAStateManager, ndbOpenJPAStoreManager);
                            while (ndbOpenJPAResult.next()) {
                                if (logger.isDetailEnabled()) {
                                    logger.detail("loading related instance of type: " + NdbOpenJPADomainFieldHandlerImpl.this.relatedTypeMapping.getDescribedType().getName());
                                }
                                ndbOpenJPAStoreManager.load(NdbOpenJPADomainFieldHandlerImpl.this.relatedTypeMapping, jDBCFetchConfiguration, null, ndbOpenJPAResult);
                            }
                            NdbOpenJPADomainFieldHandlerImpl.this.fieldMapping.load(openJPAStateManager, (JDBCStore)ndbOpenJPAStoreManager, jDBCFetchConfiguration);
                            sessionSPI.endAutoTransaction();
                        }
                        catch (Exception exception) {
                            sessionSPI.failAutoTransaction();
                            throw new ClusterJException(local.message("ERR_Exception_While_Loading"), exception);
                        }
                    }
                };
            } else {
                if (logger.isDetailEnabled()) {
                    logger.detail("NdbOpenJPADomainFieldHandlerImpl.initializeRelations for " + this.fieldMapping.getName() + " column " + (this.column == null ? "null" : this.column.getName()) + " relatedFieldName " + this.relatedFieldName + " relatedFieldMapping " + this.relatedFieldMapping + " relatedTypeMapping " + this.relatedTypeMapping);
                }
                if (this.relatedTypeMapping != null) {
                    this.relatedDomainTypeHandler = ((NdbOpenJPADomainTypeHandlerImpl)this.domainTypeHandler).registerDependency(this.relatedTypeMapping);
                    this.relatedFieldLoadManager = new RelatedFieldLoadManager(){

                        @Override
                        public void load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, JDBCFetchConfiguration jDBCFetchConfiguration) throws SQLException {
                            if (logger.isDetailEnabled()) {
                                logger.detail("Loading field " + NdbOpenJPADomainFieldHandlerImpl.this.name + "from stored key");
                            }
                            NdbOpenJPADomainFieldHandlerImpl.this.fieldMapping.load(openJPAStateManager, (JDBCStore)ndbOpenJPAStoreManager, jDBCFetchConfiguration);
                        }
                    };
                }
            }
        }
    }

    private AbstractDomainFieldHandlerImpl.ObjectOperationHandler getObjectOperationHandler(int n) {
        AbstractDomainFieldHandlerImpl.ObjectOperationHandler objectOperationHandler = objectOperationHandlerUnsupportedType;
        if (n < this.objectOperationHandlers.length) {
            objectOperationHandler = this.objectOperationHandlers[n];
        }
        switch (n) {
            case 1007: {
                return objectOperationHandlerJavaSqlDate;
            }
            case 1010: {
                return objectOperationHandlerJavaSqlTime;
            }
            case 1011: {
                return objectOperationHandlerJavaSqlTimestamp;
            }
            case 1004: {
                switch (this.storeColumn.getType()) {
                    case Blob: 
                    case Longvarbinary: {
                        return objectOperationHandlerBytesLob;
                    }
                    case Binary: 
                    case Varbinary: {
                        return objectOperationHandlerBytes;
                    }
                }
            }
            case 9: {
                switch (this.storeColumn.getType()) {
                    case Text: {
                        return objectOperationHandlerStringLob;
                    }
                    case Char: 
                    case Varchar: 
                    case Longvarchar: {
                        return objectOperationHandlerString;
                    }
                }
            }
        }
        return objectOperationHandler;
    }

    public NdbOpenJPADomainFieldHandlerImpl(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, Column column, Column column2) {
        FieldMapping[] fieldMappingArray;
        String string = null;
        if (logger.isDetailEnabled()) {
            logger.detail("NdbOpenJPADomainFieldHandlerImpl<init> for localColumn: " + column + " pkColumn: " + column2);
        }
        this.column = column;
        Table table = ndbOpenJPADomainFieldHandlerImpl.domainTypeHandler.getStoreTable();
        this.storeColumn = table.getColumn(column.getName());
        if (this.storeColumn == null) {
            string = local.message("ERR_No_Column", ndbOpenJPADomainFieldHandlerImpl.getName(), table.getName(), this.columnName);
            this.setUnsupported(string);
            logger.info(string);
            return;
        }
        this.javaType = this.column.getJavaType();
        this.objectOperationHandlerDelegate = this.getObjectOperationHandlerRelationDelegate(this.javaType);
        if (this.objectOperationHandlerDelegate == null) {
            return;
        }
        this.columnName = this.column.getName();
        this.fieldNumber = ndbOpenJPADomainFieldHandlerImpl.fieldNumber;
        this.domainTypeHandler = ndbOpenJPADomainFieldHandlerImpl.domainTypeHandler;
        this.relatedTypeMapping = ndbOpenJPADomainFieldHandlerImpl.relatedTypeMapping;
        if (this.relatedTypeMapping != null) {
            this.relatedType = this.relatedTypeMapping.getDescribedType();
            if (this.relatedType != null) {
                this.relatedTypeName = this.relatedType.getName();
            }
        }
        for (FieldMapping fieldMapping : fieldMappingArray = this.relatedTypeMapping.getPrimaryKeyFieldMappings()) {
            Column[] columnArray = fieldMapping.getColumns();
            if (logger.isDetailEnabled()) {
                logger.detail("NdbOpenJPADomainFieldHandlerImpl<init> trying primary key column: " + columnArray[0]);
            }
            if (columnArray.length != 1 || !columnArray[0].equals(column2)) continue;
            String string2 = fieldMapping.getName();
            this.oidField = NdbOpenJPADomainFieldHandlerImpl.getFieldForOidClass(this, this.relatedTypeMapping.getObjectIdType(), string2);
            if (!logger.isDetailEnabled()) break;
            logger.detail("NdbOpenJPADomainFieldHandlerImpl<init> found primary key column: " + columnArray[0] + " for field: " + string2);
            break;
        }
        if (this.oidField == null) {
            string = local.message("ERR_No_Oid_Field", (Object)column2);
            this.setUnsupported(string);
            logger.info(string);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(" Relation Field Handler for column: " + this.columnName + " number: " + this.fieldNumber + " name: " + this.name + " column: " + this.columnName + " Java type: " + this.javaType + " ObjectOperationHandler: " + this.objectOperationHandlerDelegate.handler());
        }
    }

    public void load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, JDBCFetchConfiguration jDBCFetchConfiguration) throws SQLException {
        if (!this.isRelation) {
            throw new ClusterJFatalInternalException("load called for non-relationship field " + this.getName() + " mapped to column " + this.columnName);
        }
        this.relatedFieldLoadManager.load(openJPAStateManager, ndbOpenJPAStoreManager, jDBCFetchConfiguration);
    }

    private NdbOpenJPAResult queryRelated(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager) {
        OpenJPAId openJPAId = (OpenJPAId)openJPAStateManager.getObjectId();
        Object object = openJPAId.getIdObject();
        QueryDomainType<?> queryDomainType = ndbOpenJPAStoreManager.createQueryDomainType(this.relatedType);
        if (logger.isDetailEnabled()) {
            logger.detail("created query for " + queryDomainType.getType().getName());
        }
        Predicate predicate = queryDomainType.get(this.relatedFieldName).equal(queryDomainType.param(this.relatedFieldName));
        queryDomainType.where(predicate);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(this.relatedFieldName, object);
        if (logger.isDetailEnabled()) {
            logger.detail(((Object)hashMap).toString());
        }
        NdbOpenJPAResult ndbOpenJPAResult = ndbOpenJPAStoreManager.executeQuery(this.relatedDomainTypeHandler, queryDomainType, hashMap);
        if (logger.isDetailEnabled()) {
            DomainTypeHandler<?> domainTypeHandler = ndbOpenJPAResult.domainTypeHandler;
            Set<String> set = ndbOpenJPAResult.getColumnNames();
            StringBuffer stringBuffer = new StringBuffer("Executed query for ");
            stringBuffer.append(domainTypeHandler.getName());
            stringBuffer.append(" returned columns: ");
            stringBuffer.append(Arrays.toString(set.toArray()));
            logger.detail(stringBuffer.toString());
        }
        return ndbOpenJPAResult;
    }

    public void load(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager, JDBCFetchConfiguration jDBCFetchConfiguration, NdbOpenJPAResult ndbOpenJPAResult) throws SQLException {
        this.fieldMapping.load(openJPAStateManager, (JDBCStore)ndbOpenJPAStoreManager, jDBCFetchConfiguration, (Result)ndbOpenJPAResult);
    }

    public Map<String, Object> createParameterMap(QueryDomainType<?> queryDomainType, Object object) {
        return ((ObjectOperationHandlerRelationField)this.objectOperationHandlerDelegate).createParameterMap(this, queryDomainType, object);
    }

    public int compareTo(Object object) {
        return this.compareTo((NdbOpenJPADomainFieldHandlerImpl)object);
    }

    protected String toString(Object object) {
        return object.getClass().getSimpleName();
    }

    Column[] getColumns() {
        return this.fieldMapping.getColumns();
    }

    protected Object getKeyValue(Object object) {
        Object object2 = object;
        if (object instanceof ObjectId) {
            object2 = ((ObjectId)object).getId();
        }
        return NdbOpenJPADomainFieldHandlerImpl.getKeyValue(this.oidField, object2);
    }

    protected static Object getKeyValue(Field field, Object object) {
        try {
            Object object2;
            String string = "none";
            if (field != null) {
                object2 = field.get(object);
                string = field.getName();
            } else {
                object2 = object;
            }
            if (logger.isDetailEnabled()) {
                logger.detail("For field " + string + " keys: " + object + " value returned is " + object2);
            }
            return object2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "IllegalArgumentException, field " + field.getDeclaringClass().getName() + ":" + field.getName() + " keys: " + object;
            logger.error(string);
            throw new ClusterJUserException(string, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "IllegalAccessException, field " + field.getDeclaringClass().getName() + ":" + field.getName() + " keys: " + object;
            throw new ClusterJUserException(string, illegalAccessException);
        }
    }

    public Field getOidField() {
        return this.oidField;
    }

    protected static Field getFieldForOidClass(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, Class<?> clazz, String string) {
        String string2 = null;
        Field field = null;
        if (logger.isDetailEnabled()) {
            logger.detail("Oid class: " + clazz.getName());
        }
        if (OpenJPAId.class.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            field = clazz.getField(string);
            if (logger.isDetailEnabled()) {
                logger.detail("OidField: " + field);
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string2 = local.message("ERR_No_Field_In_Oid_Class", (Object)clazz.getName(), (Object)string);
            logger.info(string2);
            ndbOpenJPADomainFieldHandlerImpl.setUnsupported(string2);
            return null;
        }
        catch (SecurityException securityException) {
            string2 = local.message("ERR_Security_Violation_For_Oid_Class", (Object)clazz.getName());
            logger.info(string2);
            ndbOpenJPADomainFieldHandlerImpl.setUnsupported(string2);
            return null;
        }
    }

    protected AbstractDomainFieldHandlerImpl.ObjectOperationHandler getObjectOperationHandlerRelationDelegate(int n) {
        switch (n) {
            case 5: 
            case 21: {
                return objectOperationHandlerRelationIntField;
            }
            case 6: 
            case 22: {
                return objectOperationHandlerRelationLongField;
            }
            case 9: {
                return objectOperationHandlerRelationStringField;
            }
        }
        String string = local.message("ERR_Illegal_Foreign_Key_Type", this.domainTypeHandler.getName(), this.name, this.columnName, n);
        this.setUnsupported(string);
        return null;
    }

    public com.mysql.clusterj.core.store.Column[] getStoreColumns() {
        return this.storeColumns;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean isRelation() {
        return this.isRelation;
    }

    public String getReason() {
        return this.reason;
    }

    private void setUnsupported(String string) {
        this.supported = false;
        this.reason = string;
    }

    static abstract class ObjectOperationHandlerRelationField
    implements AbstractDomainFieldHandlerImpl.ObjectOperationHandler {
        ObjectOperationHandlerRelationField() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        public Map<String, Object> createParameterMap(NdbOpenJPADomainFieldHandlerImpl ndbOpenJPADomainFieldHandlerImpl, QueryDomainType<?> queryDomainType, Object object) {
            String string = ndbOpenJPADomainFieldHandlerImpl.name;
            PredicateOperand predicateOperand = queryDomainType.get(string);
            Predicate predicate = predicateOperand.equal(predicateOperand);
            queryDomainType.where(predicate);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Object object2 = ndbOpenJPADomainFieldHandlerImpl.getKeyValue(object);
            hashMap.put(string, object2);
            if (logger.isDetailEnabled()) {
                logger.detail("Map.Entry key: " + string + ", value: " + object2);
            }
            return hashMap;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Operation operation) {
            operation.getValue(abstractDomainFieldHandlerImpl.getStoreColumn());
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, String string) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ResultData resultData, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, IndexScanOperation.BoundType boundType, IndexScanOperation indexScanOperation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ScanFilter.BinaryCondition binaryCondition, ScanFilter scanFilter) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, Operation operation) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, boolean bl) {
            return true;
        }

        protected int getInt(Object object) {
            if (object instanceof IntId) {
                return ((IntId)object).getId();
            }
            if (object instanceof OpenJPAId) {
                OpenJPAId openJPAId = (OpenJPAId)object;
                Object object2 = openJPAId.getIdObject();
                if (object2 instanceof Integer) {
                    return (Integer)object2;
                }
                throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"int key", (Object)"OpenJPAId"));
            }
            String string = object == null ? "<null>" : object.getClass().getName();
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"int key", (Object)string));
        }

        protected long getLong(Object object) {
            if (object instanceof LongId) {
                return ((LongId)object).getId();
            }
            if (object instanceof OpenJPAId) {
                OpenJPAId openJPAId = (OpenJPAId)object;
                Object object2 = openJPAId.getIdObject();
                if (object2 instanceof Long) {
                    return (Long)object2;
                }
                throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"long key", (Object)"OpenJPAId"));
            }
            String string = object == null ? "<null>" : object.getClass().getName();
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"long key", (Object)string));
        }

        protected String getString(Object object) {
            if (object instanceof StringId) {
                return ((StringId)object).getId();
            }
            if (object instanceof OpenJPAId) {
                OpenJPAId openJPAId = (OpenJPAId)object;
                Object object2 = openJPAId.getIdObject();
                if (object2 instanceof String) {
                    return (String)object2;
                }
                throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"String key", (Object)"OpenJPAId"));
            }
            String string = object == null ? "<null>" : object.getClass().getName();
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Id_Type", (Object)"String key", (Object)string));
        }

        protected OpenJPAStateManager getRelatedStateManager(ValueHandler valueHandler, AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl) {
            OpenJPAStateManager openJPAStateManager = ((NdbOpenJPAValueHandler)valueHandler).getStateManager();
            NdbOpenJPAStoreManager ndbOpenJPAStoreManager = ((NdbOpenJPAValueHandler)valueHandler).getStoreManager();
            OpenJPAStateManager openJPAStateManager2 = RelationStrategies.getStateManager((Object)openJPAStateManager.fetchObjectField(abstractDomainFieldHandlerImpl.getFieldNumber()), (StoreContext)ndbOpenJPAStoreManager.getContext());
            return openJPAStateManager2;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, PartitionKey partitionKey, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext queryExecutionContext, String string) {
            return queryExecutionContext.getObject(string);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Unsupported_Method", (Object)"objectGetValue", (Object)"ObjectOperationHandlerRelationField"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl, Object object, ValueHandler valueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Unsupported_Method", (Object)"objectSetValue", (Object)"ObjectOperationHandlerRelationField"));
        }
    }

    static interface RelatedFieldLoadManager {
        public void load(OpenJPAStateManager var1, NdbOpenJPAStoreManager var2, JDBCFetchConfiguration var3) throws SQLException;
    }
}

