/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public abstract class Driver {
    protected static final PrintWriter out = new PrintWriter(System.out, true);
    protected static final PrintWriter err = new PrintWriter(System.err, true);
    protected static final String endl = System.getProperty("line.separator");
    private static final Runtime rt = Runtime.getRuntime();
    private static final List<String> propFileNames = new ArrayList<String>();
    private static String logFileName = "log_" + new SimpleDateFormat("yyyyMMdd_HHMMss").format(new Date()) + ".txt";
    private PrintWriter log;
    protected final Properties props = new Properties();
    protected String descr = "";
    protected boolean logRealTime = false;
    protected boolean logMemUsage = false;
    protected boolean includeFullGC = false;
    protected boolean logSumOfOps = false;
    protected boolean renewOperations = false;
    protected boolean renewConnection = false;
    protected boolean allowExtendedPC = false;
    protected int aStart = 256;
    protected int aEnd = 4096;
    protected int aIncr = 4;
    protected int bStart = 256;
    protected int bEnd = 4096;
    protected int bIncr = 4;
    protected int maxStringLength = 100;
    protected int warmupRuns = 0;
    protected int hotRuns = 0;
    protected final Set<String> exclude = new HashSet<String>();
    protected final List<Op> ops = new ArrayList<Op>();
    boolean logHeader;
    private StringBuilder header;
    private StringBuilder rtimes;
    private StringBuilder musage;
    private long t0 = 0L;
    private long t1 = 0L;
    private long ta = 0L;
    private long m0 = 0L;
    private long m1 = 0L;
    private long ma = 0L;

    protected abstract void initConnection() throws Exception;

    protected abstract void closeConnection() throws Exception;

    protected abstract void initOperations() throws Exception;

    protected abstract void closeOperations() throws Exception;

    protected abstract void clearPersistenceContext() throws Exception;

    protected abstract void clearData() throws Exception;

    protected abstract void beginTransaction() throws Exception;

    protected abstract void commitTransaction() throws Exception;

    protected abstract void rollbackTransaction() throws Exception;

    protected static final void verify(boolean bl) {
        if (!bl) {
            throw new RuntimeException("wrong data; verification failed");
        }
    }

    protected static void loadSystemLibrary(String string) {
        out.print("loading libary ...");
        out.flush();
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string2;
            try {
                string2 = System.getProperty("java.library.path");
            }
            catch (Exception exception) {
                string2 = "<exception caught: " + exception.getMessage() + ">";
            }
            err.println("NdbBase: failed loading library '" + string + "'; java.library.path='" + string2 + "'");
            throw unsatisfiedLinkError;
        }
        catch (SecurityException securityException) {
            err.println("NdbBase: failed loading library '" + string + "'; caught exception: " + securityException);
            throw securityException;
        }
        out.println("          [" + string + "]");
    }

    public void run() {
        try {
            int n;
            this.init();
            for (n = 0; n < this.warmupRuns; ++n) {
                this.runTests();
            }
            out.println();
            out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            out.println("start logging results ...");
            out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            out.println();
            this.header = new StringBuilder();
            this.rtimes = new StringBuilder();
            this.musage = new StringBuilder();
            this.closeLogFile();
            this.openLogFile();
            for (n = 0; n < this.hotRuns; ++n) {
                this.runTests();
            }
            if (this.logRealTime) {
                this.log.println(this.descr + ", rtime[ms]" + this.header.toString() + endl + this.rtimes.toString() + endl + endl + endl);
            }
            if (this.logMemUsage) {
                this.log.println(this.descr + ", net musage[KiB]" + this.header.toString() + endl + this.musage.toString() + endl + endl + endl);
            }
            this.close();
        }
        catch (Exception exception) {
            out.println("caught " + exception);
            exception.printStackTrace();
            System.exit(2);
        }
    }

    protected void init() throws Exception {
        this.loadProperties();
        this.initProperties();
        this.printProperties();
        this.openLogFile();
        this.logHeader = true;
        this.header = new StringBuilder();
        this.rtimes = new StringBuilder();
        this.musage = new StringBuilder();
    }

    protected void close() throws Exception {
        this.header = null;
        this.rtimes = null;
        this.musage = null;
        this.closeLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        if (propFileNames.size() == 0) {
            propFileNames.add("crund.properties");
        }
        out.println();
        for (String string : propFileNames) {
            out.println("reading properties file:    " + string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                this.props.load(fileInputStream);
            }
            catch (Exception exception) {
                out.println("error reading file.");
            }
            finally {
                if (fileInputStream == null) continue;
                ((InputStream)fileInputStream).close();
            }
        }
    }

    protected boolean parseBoolean(String string) {
        return Boolean.parseBoolean(this.props.getProperty(string));
    }

    protected int parseInt(String string, int n) {
        String string2 = this.props.getProperty(string);
        try {
            return string2 == null ? n : Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = new NumberFormatException("invalid value of benchmark property ('" + string + "', '" + string2 + "').");
            numberFormatException2.initCause(numberFormatException);
            throw numberFormatException2;
        }
    }

    protected void initProperties() {
        this.logRealTime = this.parseBoolean("logRealTime");
        this.logMemUsage = this.parseBoolean("logMemUsage");
        this.includeFullGC = this.parseBoolean("includeFullGC");
        this.logSumOfOps = this.parseBoolean("logSumOfOps");
        this.renewOperations = this.parseBoolean("renewOperations");
        this.renewConnection = this.parseBoolean("renewConnection");
        this.allowExtendedPC = this.parseBoolean("allowExtendedPC");
        this.aStart = this.parseInt("aStart", 256);
        this.aEnd = this.parseInt("aEnd", 4096);
        this.aIncr = this.parseInt("aIncr", 4);
        this.bStart = this.parseInt("bStart", 256);
        this.bEnd = this.parseInt("bEnd", 4096);
        this.bIncr = this.parseInt("bIncr", 4);
        this.maxStringLength = this.parseInt("maxStringLength", 100);
        this.warmupRuns = this.parseInt("warmupRuns", 0);
        this.hotRuns = this.parseInt("hotRuns", 1);
        String[] stringArray = this.props.getProperty("exclude", "").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.exclude.add(stringArray[i]);
        }
    }

    protected void printProperties() {
        out.println();
        out.println("main settings:");
        out.println("logRealTime:                " + this.logRealTime);
        out.println("logMemUsage:                " + this.logMemUsage);
        out.println("includeFullGC:              " + this.includeFullGC);
        out.println("logSumOfOps:                " + this.logSumOfOps);
        out.println("renewOperations:            " + this.renewOperations);
        out.println("renewConnection:            " + this.renewConnection);
        out.println("allowExtendedPC:            " + this.allowExtendedPC);
        out.println("aStart:                     " + this.aStart);
        out.println("aEnd:                       " + this.aEnd);
        out.println("aIncr:                      " + this.aIncr);
        out.println("bStart:                     " + this.bStart);
        out.println("bEnd:                       " + this.bEnd);
        out.println("bIncr:                      " + this.bIncr);
        out.println("maxStringLength:            " + this.maxStringLength);
        out.println("warmupRuns:                 " + this.warmupRuns);
        out.println("hotRuns:                    " + this.hotRuns);
        out.println("exclude:                    " + this.exclude);
    }

    private void openLogFile() throws IOException {
        out.println();
        out.println("writing results to file:    " + logFileName);
        this.log = new PrintWriter(new FileWriter(logFileName, false));
    }

    private void closeLogFile() throws IOException {
        out.print("closing files ...    ");
        out.flush();
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        out.println("       [ok]");
    }

    protected void runTests() throws Exception {
        this.initConnection();
        this.initOperations();
        for (int i = this.aStart; i <= this.aEnd; i *= this.aIncr) {
            int n;
            int n2 = n = i > this.bStart ? i : this.bStart;
            while (n <= this.bEnd) {
                this.runOperations(i, n);
                n *= this.bIncr;
            }
        }
        out.println();
        out.println("------------------------------------------------------------");
        out.println();
        this.clearData();
        this.closeOperations();
        this.closeConnection();
    }

    protected void runOperations(int n, int n2) throws Exception {
        out.println();
        out.println("------------------------------------------------------------");
        out.println("countA = " + n + ", countB = " + n2);
        out.println();
        if (this.logRealTime) {
            this.rtimes.append("A=" + n + ", B=" + n2);
            this.ta = 0L;
        }
        if (this.logMemUsage) {
            this.musage.append("A=" + n + ", B=" + n2);
            this.ma = 0L;
        }
        if (this.renewConnection) {
            this.closeOperations();
            this.closeConnection();
            this.initConnection();
            this.initOperations();
        } else if (this.renewOperations) {
            this.closeOperations();
            this.initOperations();
        }
        this.clearData();
        for (Op op : this.ops) {
            if (!this.allowExtendedPC) {
                this.clearPersistenceContext();
            }
            this.runOp(op, n, n2);
        }
        if (this.logHeader && this.logSumOfOps) {
            this.header.append("\ttotal");
        }
        this.logHeader = false;
        if (this.logRealTime) {
            if (this.logSumOfOps) {
                this.rtimes.append("\t" + this.ta);
                out.println();
                out.println("total");
                out.println("tx real time      = " + this.ta + "\tms [begin..commit]");
            }
            this.rtimes.append(endl);
        }
        if (this.logMemUsage) {
            if (this.logSumOfOps) {
                this.musage.append("\t" + this.ma);
                out.println();
                out.println("total");
                out.println("net mem usage     = " + (this.ma >= 0L ? "+" : "") + this.ma + "\tKiB");
            }
            this.musage.append(endl);
        }
    }

    protected void runOp(Op op, int n, int n2) throws Exception {
        String string = op.getName();
        if (!this.exclude.contains(string)) {
            this.begin(string);
            op.run(n, n2);
            this.commit(string);
        }
    }

    protected void begin(String string) throws Exception {
        out.println();
        out.println(string);
        Driver.gc();
        if (this.logMemUsage) {
            this.m0 = rt.totalMemory() - rt.freeMemory();
        }
        if (this.logRealTime) {
            this.t0 = System.nanoTime() / 1000000L;
        }
        this.beginTransaction();
    }

    protected void commit(String string) throws Exception {
        long l;
        this.commitTransaction();
        if (this.includeFullGC) {
            rt.gc();
        }
        if (this.logRealTime) {
            this.t1 = System.nanoTime() / 1000000L;
            l = this.t1 - this.t0;
            out.println("tx real time      = " + l + "\tms [begin..commit]");
            this.rtimes.append("\t" + l);
            this.ta += l;
        }
        if (this.logMemUsage) {
            Driver.gc();
            this.m1 = rt.totalMemory() - rt.freeMemory();
            l = this.m0 / 1024L;
            long l2 = this.m1 / 1024L;
            long l3 = l2 - l;
            out.println("net mem usage     = " + (l3 >= 0L ? "+" : "") + l3 + "\tKiB [" + l + "K->" + l2 + "K]");
            this.musage.append("\t" + l3);
            this.ma += l3;
        }
        if (this.logHeader) {
            this.header.append("\t" + string);
        }
    }

    private static void gc() {
        for (int i = 0; i < 10; ++i) {
            long l;
            long l2 = rt.freeMemory();
            do {
                l = l2;
                rt.runFinalization();
                rt.gc();
            } while ((l2 = rt.freeMemory()) > l);
        }
    }

    private static void exitUsage() {
        out.println("usage: [options]");
        out.println("    [-p <file name>]...    a properties file name");
        out.println("    [-l <file name>]       log file name for data output");
        out.println("    [-h|--help]            print usage message and exit");
        out.println();
        System.exit(1);
    }

    public static void parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-p")) {
                if (i >= stringArray.length) {
                    Driver.exitUsage();
                }
                propFileNames.add(stringArray[++i]);
                continue;
            }
            if (string.equals("-l")) {
                if (i >= stringArray.length) {
                    Driver.exitUsage();
                }
                logFileName = stringArray[++i];
                continue;
            }
            if (string.equals("-h") || string.equals("--help")) {
                Driver.exitUsage();
                continue;
            }
            out.println("unknown option: " + string);
            Driver.exitUsage();
        }
    }

    public static void clearPropFileNames() {
        propFileNames.clear();
    }

    protected abstract class Op {
        protected final String name;

        public Op(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public abstract void run(int var1, int var2) throws Exception;
    }
}

