/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import com.mysql.clusterj.jpatest.SingleEMTestCase;
import com.mysql.clusterj.jpatest.model.Employee;
import com.mysql.clusterj.jpatest.model.IdBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManager;

public abstract class AbstractJPABaseTest
extends SingleEMTestCase {
    protected static TimeZone localSystemTimeZone = TimeZone.getDefault();
    protected Connection connection;
    private ColumnDescriptor[] columnDescriptors = this.getColumnDescriptors();
    List<IdBase> instances = new ArrayList<IdBase>();
    private List<Object[]> expected = null;
    protected static boolean debug;

    public AbstractJPABaseTest() {
        debug = this.getDebug();
    }

    protected void getConnection() {
        this.connection = (Connection)((OpenJPAEntityManager)this.em).getConnection();
        this.setAutoCommit(this.connection, false);
    }

    protected void setAutoCommit(Connection connection, boolean bl) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("setAutoCommit failed", sQLException);
        }
    }

    public void deleteAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee employee = (Employee)this.em.find(Employee.class, (Object)i);
            if (employee == null) continue;
            this.em.remove((Object)employee);
        }
        this.commit();
        this.em.close();
    }

    public void verifyDeleteAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee employee = (Employee)this.em.find(Employee.class, (Object)i);
            if (employee == null) continue;
            this.error("Entity exists after being removed: " + i);
        }
        this.commit();
        this.failOnError();
        this.em.close();
    }

    public void createAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee employee = new Employee();
            employee.setId(i);
            employee.setAge(i);
            employee.setMagic(i);
            employee.setName("Employee " + i);
            this.em.persist((Object)employee);
        }
        this.commit();
        this.em.close();
    }

    public void findAll() {
        this.em = this.emf.createEntityManager();
        this.begin();
        for (int i = 0; i < this.getNumberOfEmployees(); ++i) {
            Employee employee = (Employee)this.em.find(Employee.class, (Object)i);
            this.verifyEmployee(employee, 0);
        }
        this.commit();
        this.em.close();
    }

    public void updateThenVerifyAll() {
        Employee employee;
        int n;
        this.em = this.emf.createEntityManager();
        this.begin();
        for (n = 0; n < this.getNumberOfEmployees(); ++n) {
            employee = (Employee)this.em.find(Employee.class, (Object)n);
            employee.setAge(n + 1);
            this.verifyEmployee(employee, 1);
        }
        this.commit();
        this.begin();
        for (n = 0; n < this.getNumberOfEmployees(); ++n) {
            employee = (Employee)this.em.find(Employee.class, (Object)n);
            this.verifyEmployee(employee, 1);
        }
        this.commit();
        this.em.close();
    }

    public void deleteThenVerifyAll() {
        Employee employee;
        int n;
        this.em = this.emf.createEntityManager();
        this.begin();
        for (n = 0; n < this.getNumberOfEmployees(); ++n) {
            employee = (Employee)this.em.find(Employee.class, (Object)n);
            this.verifyEmployee(employee, 1);
            this.em.remove((Object)employee);
        }
        this.commit();
        this.begin();
        for (n = 0; n < this.getNumberOfEmployees(); ++n) {
            employee = (Employee)this.em.find(Employee.class, (Object)n);
            if (employee == null) continue;
            this.error("Entity exists after being removed: " + n);
        }
        this.commit();
        this.em.close();
    }

    protected void verifyEmployee(Employee employee, int n) {
        int n2 = employee.getId();
        this.errorIfNotEqual("Error in age", n2 + n, (int)employee.getAge());
        this.errorIfNotEqual("Error in magic", n2, employee.getMagic());
        this.errorIfNotEqual("Error in name", "Employee " + n2, employee.getName());
    }

    protected int getNumberOfEmployees() {
        return 1;
    }

    protected static long getMillisFor(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(10, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    protected static long getMillisFor(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    protected static long getMillisFor(int n, int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, n + 1);
        calendar.set(10, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        return l;
    }

    protected static void resetLocalSystemDefaultTimeZone(Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select @@global.time_zone, @@global.system_time_zone, @@session.time_zone");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            String string2 = resultSet.getString(2);
            String string3 = resultSet.getString(3);
            if (debug) {
                System.out.println("Global time zone: " + string + " Global system time zone: " + string2 + " Session time zone: " + string3);
            }
            connection.commit();
            string = "SYSTEM".equalsIgnoreCase(string) ? string2 : "GMT" + string;
            localSystemTimeZone = TimeZone.getTimeZone(string);
            if (debug) {
                System.out.println("Local system time zone set to: " + string + "(" + localSystemTimeZone + ")");
            }
            TimeZone.setDefault(localSystemTimeZone);
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("setServerTimeZone failed", sQLException);
        }
    }

    protected boolean getDebug() {
        return false;
    }

    protected List<Object[]> getExpected() {
        return this.expected;
    }

    protected String getTableName() {
        return null;
    }

    protected int getNumberOfInstances() {
        return 0;
    }

    protected ColumnDescriptor[] getColumnDescriptors() {
        return null;
    }

    protected IdBase getNewInstance(Class<? extends IdBase> clazz) {
        return null;
    }

    protected Class<? extends IdBase> getModelClass() {
        return null;
    }

    protected Object getColumnValue(int n, int n2) {
        return null;
    }

    protected void generateInstances(ColumnDescriptor[] columnDescriptorArray) {
        Class<? extends IdBase> clazz = this.getModelClass();
        this.expected = new ArrayList<Object[]>();
        this.instances = new ArrayList<IdBase>();
        IdBase idBase = null;
        int n = this.getNumberOfInstances();
        for (int i = 0; i < n; ++i) {
            idBase = this.getNewInstance(clazz);
            idBase.setId(i);
            int n2 = 0;
            for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                Object object = this.getColumnValue(i, n2);
                columnDescriptor.setFieldValue(idBase, object);
                if (debug) {
                    System.out.println("generateInstances set field " + columnDescriptor.getColumnName() + " to value " + object);
                }
                ++n2;
            }
            this.instances.add(idBase);
            Object[] objectArray = this.createRow(columnDescriptorArray, idBase);
            this.expected.add(objectArray);
        }
        if (debug) {
            System.out.println("Created " + this.instances.size() + " instances.");
        }
    }

    protected void verify(String string, List<Object[]> list, List<Object[]> list2) {
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = list.get(i);
            Object[] objectArray2 = list2.get(i);
            this.errorIfNotEqual(string + " got failure on id for row " + i, i, objectArray2[0]);
            for (int j = 1; j < objectArray.length; ++j) {
                this.errorIfNotEqual(string + " got failure to match column data for row " + i + " column " + j, objectArray[j], objectArray2[j]);
            }
        }
    }

    protected void removeAll(Class<?> clazz) {
        Query query = this.em.createQuery("DELETE FROM " + clazz.getSimpleName());
        this.em.getTransaction().begin();
        query.executeUpdate();
        this.em.getTransaction().commit();
    }

    private void removeAll(String string) {
        this.getConnection();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE FROM " + string);
            preparedStatement.execute();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected void writeJDBCreadJPA() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getTableName());
        List<Object[]> list = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        list = this.readFromJPA(this.columnDescriptors);
        this.verify("writeJDBCreadJPA", this.getExpected(), list);
    }

    protected void writeJDBCreadJDBC() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getTableName());
        List<Object[]> list = null;
        this.writeToJDBC(this.columnDescriptors, this.instances);
        list = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeJDBCreadJDBC", this.getExpected(), list);
    }

    protected void writeJPAreadJPA() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getModelClass());
        List<Object[]> list = null;
        this.writeToJPA(this.columnDescriptors, this.instances);
        list = this.readFromJPA(this.columnDescriptors);
        this.verify("writeJPAreadJPA", this.getExpected(), list);
    }

    protected void writeJPAreadJDBC() {
        this.generateInstances(this.columnDescriptors);
        this.removeAll(this.getTableName());
        List<Object[]> list = null;
        this.writeToJPA(this.columnDescriptors, this.instances);
        list = this.readFromJDBC(this.columnDescriptors);
        this.verify("writeJPAreadJDBC", this.getExpected(), list);
    }

    protected void writeToJPA(ColumnDescriptor[] columnDescriptorArray, List<IdBase> list) {
        this.em.getTransaction().begin();
        for (IdBase idBase : list) {
            this.em.persist((Object)idBase);
        }
        this.em.getTransaction().commit();
    }

    protected void writeToJDBC(ColumnDescriptor[] columnDescriptorArray, List<IdBase> list) {
        String string = this.getTableName();
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(string);
        stringBuffer.append(" (id");
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            stringBuffer.append(", ");
            stringBuffer.append(columnDescriptor.getColumnName());
        }
        stringBuffer.append(") VALUES (?");
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            stringBuffer.append(", ?");
        }
        stringBuffer.append(")");
        String string2 = stringBuffer.toString();
        if (debug) {
            System.out.println(string2);
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = this.connection.prepareStatement(string2);
            if (debug) {
                System.out.println(preparedStatement.toString());
            }
            for (n = 0; n < list.size(); ++n) {
                IdBase idBase = list.get(n);
                preparedStatement.setInt(1, idBase.getId());
                int n2 = 2;
                for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                    Object object = columnDescriptor.getFieldValue(idBase);
                    columnDescriptor.setPreparedStatementValue(preparedStatement, n2++, object);
                    if (!debug) continue;
                    System.out.println("writeToJDBC set column: " + columnDescriptor.getColumnName() + " to value: " + object);
                }
                preparedStatement.execute();
            }
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to insert " + string + " at instance " + n, sQLException);
        }
    }

    protected List<Object[]> readFromJPA(ColumnDescriptor[] columnDescriptorArray) {
        Class<? extends IdBase> clazz = this.getModelClass();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        this.em.getTransaction().begin();
        for (int i = 0; i < this.getNumberOfInstances(); ++i) {
            IdBase idBase = (IdBase)this.em.find(clazz, (Object)i);
            if (idBase == null) continue;
            Object[] objectArray = this.createRow(columnDescriptorArray, idBase);
            arrayList.add(objectArray);
        }
        this.em.getTransaction().commit();
        if (debug) {
            System.out.println("readFromJPA: " + this.dump(arrayList));
        }
        return arrayList;
    }

    protected List<Object[]> readFromJDBC(ColumnDescriptor[] columnDescriptorArray) {
        String string = this.getTableName();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        StringBuffer stringBuffer = new StringBuffer("SELECT id");
        for (ColumnDescriptor sQLException : columnDescriptorArray) {
            stringBuffer.append(", ");
            stringBuffer.append(sQLException.getColumnName());
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" ORDER BY ID");
        String string2 = stringBuffer.toString();
        if (debug) {
            System.out.println(string2);
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = this.connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object[] objectArray = new Object[columnDescriptorArray.length + 1];
                int n2 = 1;
                objectArray[0] = resultSet.getInt(1);
                for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                    objectArray[n2] = columnDescriptor.getResultSetValue(resultSet, n2 + 1);
                    ++n2;
                }
                ++n;
                arrayList.add(objectArray);
            }
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to read " + string + " at instance " + n, sQLException);
        }
        if (debug) {
            System.out.println("readFromJDBC: " + this.dump(arrayList));
        }
        return arrayList;
    }

    private Object[] createRow(ColumnDescriptor[] columnDescriptorArray, IdBase idBase) {
        Object[] objectArray = new Object[columnDescriptorArray.length + 1];
        objectArray[0] = idBase.getId();
        int n = 1;
        for (ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            objectArray[n++] = columnDescriptor.getFieldValue(idBase);
        }
        return objectArray;
    }

    private String dump(List<Object[]> list) {
        StringBuffer stringBuffer = new StringBuffer(list.size() + " rows\n");
        for (Object[] objectArray : list) {
            stringBuffer.append("Id: ");
            for (Object object : objectArray) {
                stringBuffer.append(object);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    protected static interface InstanceHandler {
        public void setFieldValue(IdBase var1, Object var2);

        public Object getResultSetValue(ResultSet var1, int var2) throws SQLException;

        public Object getFieldValue(IdBase var1);

        public void setPreparedStatementValue(PreparedStatement var1, int var2, Object var3) throws SQLException;
    }

    protected static class ColumnDescriptor {
        private String columnName;
        protected InstanceHandler instanceHandler;

        public String getColumnName() {
            return this.columnName;
        }

        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return this.instanceHandler.getResultSetValue(resultSet, n);
        }

        public Object getFieldValue(IdBase idBase) {
            return this.instanceHandler.getFieldValue(idBase);
        }

        public void setFieldValue(IdBase idBase, Object object) {
            this.instanceHandler.setFieldValue(idBase, object);
        }

        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            this.instanceHandler.setPreparedStatementValue(preparedStatement, n, object);
        }

        protected ColumnDescriptor(String string, InstanceHandler instanceHandler) {
            this.columnName = string;
            this.instanceHandler = instanceHandler;
        }
    }
}

