/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.LongIntStringPK;

public class LongIntStringPKTest
extends AbstractClusterJTest {
    protected int PK_MODULUS = 2;
    protected int NUMBER_OF_INSTANCES = this.PK_MODULUS * this.PK_MODULUS * this.PK_MODULUS;
    protected long PRETTY_BIG_NUMBER = 1000000000000000L;
    protected List<LongIntStringPK> instances = new ArrayList<LongIntStringPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(LongIntStringPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(LongIntStringPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            Object[] objectArray = new Object[]{this.getPK1(i), this.getPK2(i), this.getPK3(i)};
            LongIntStringPK longIntStringPK = (LongIntStringPK)this.session.find(LongIntStringPK.class, (Object)objectArray);
            this.verify(longIntStringPK, i, false);
        }
    }

    protected void update() {
        Object[] objectArray;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            objectArray = this.createInstance(n);
            objectArray.setStringvalue(this.getValue(this.NUMBER_OF_INSTANCES - n));
            this.session.updatePersistent((Object)objectArray);
            this.verify((LongIntStringPK)objectArray, n, true);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            objectArray = new Object[]{this.getPK1(n), this.getPK2(n), this.getPK3(n)};
            LongIntStringPK longIntStringPK = (LongIntStringPK)this.session.find(LongIntStringPK.class, (Object)objectArray);
            this.verify(longIntStringPK, n, true);
        }
    }

    protected void delete() {
        Object[] objectArray;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            objectArray = this.createInstance(n);
            this.session.deletePersistent((Object)objectArray);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            objectArray = new Object[]{this.getPK1(n), this.getPK2(n), this.getPK3(n)};
            LongIntStringPK longIntStringPK = (LongIntStringPK)this.session.find(LongIntStringPK.class, (Object)objectArray);
            this.errorIfNotEqual("Failed to delete instance: " + n, null, longIntStringPK);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            LongIntStringPK longIntStringPK = this.createInstance(i);
            this.instances.add(longIntStringPK);
        }
    }

    protected LongIntStringPK createInstance(int n) {
        LongIntStringPK longIntStringPK = (LongIntStringPK)this.session.newInstance(LongIntStringPK.class);
        longIntStringPK.setLongpk(this.getPK1(n));
        longIntStringPK.setIntpk(this.getPK2(n));
        longIntStringPK.setStringpk(this.getPK3(n));
        longIntStringPK.setStringvalue(this.getValue(n));
        return longIntStringPK;
    }

    protected String toString(LongIntStringPK longIntStringPK) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LongIntStringPK[");
        stringBuffer.append(longIntStringPK.getLongpk());
        stringBuffer.append(",");
        stringBuffer.append(longIntStringPK.getIntpk());
        stringBuffer.append(",\"");
        stringBuffer.append(longIntStringPK.getStringpk());
        stringBuffer.append("\"]: ");
        stringBuffer.append(longIntStringPK.getStringvalue());
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    protected long getPK1(int n) {
        return this.PRETTY_BIG_NUMBER * (long)(n / this.PK_MODULUS / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected int getPK2(int n) {
        return n / this.PK_MODULUS % this.PK_MODULUS;
    }

    protected String getPK3(int n) {
        return "" + n % this.PK_MODULUS;
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected void verify(LongIntStringPK longIntStringPK, int n, boolean bl) {
        this.errorIfNotEqual("PK1 failed", this.getPK1(n), longIntStringPK.getLongpk());
        this.errorIfNotEqual("PK2 failed", this.getPK2(n), longIntStringPK.getIntpk());
        this.errorIfNotEqual("PK3 failed", this.getPK3(n), longIntStringPK.getStringpk());
        if (bl) {
            this.errorIfNotEqual("Value failed", this.getValue(this.NUMBER_OF_INSTANCES - n), longIntStringPK.getStringvalue());
        } else {
            this.errorIfNotEqual("Value failed", this.getValue(n), longIntStringPK.getStringvalue());
        }
    }
}

