/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.DynamicPK;

public class DynamicBinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<DynamicPK> instances = new ArrayList<DynamicPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
    }

    public void test() {
        this.run(DynamicBinaryPK.class);
        this.run(DynamicVarbinaryPK.class);
        this.run(DynamicLongvarbinaryPK.class);
        this.failOnError();
    }

    public void run(Class<? extends DynamicPK> clazz) {
        this.deleteAll(clazz);
        this.createInstances(clazz);
        this.insert();
        this.find(clazz);
        this.update(clazz);
        this.delete(clazz);
    }

    protected void deleteAll(Class<? extends DynamicPK> clazz) {
        try {
            this.tx.begin();
            this.session.deletePersistentAll(clazz);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find(Class<? extends DynamicPK> clazz) {
        String string = "find " + clazz.getName();
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] byArray = this.getPK(i);
            DynamicPK dynamicPK = (DynamicPK)((Object)this.session.find(clazz, (Object)byArray));
            this.verify(string, dynamicPK, i, false);
        }
    }

    protected void update(Class<? extends DynamicPK> clazz) {
        Object object;
        int n;
        String string = "update before " + clazz.getName();
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.createInstance(clazz, n);
            object.setName(this.getValue(this.NUMBER_OF_INSTANCES - n));
            this.session.updatePersistent(object);
            this.verify(string, (DynamicPK)((Object)object), n, true);
        }
        string = "update after " + clazz.getName();
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.getPK(n);
            DynamicPK dynamicPK = (DynamicPK)((Object)this.session.find(clazz, object));
            this.verify(string, dynamicPK, n, true);
        }
    }

    protected void delete(Class<? extends DynamicPK> clazz) {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.createInstance(clazz, n);
            this.session.deletePersistent(object);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.getPK(n);
            DynamicPK dynamicPK = (DynamicPK)((Object)this.session.find(clazz, object));
            this.errorIfNotEqual("Failed to delete instance: " + n, null, (Object)dynamicPK);
        }
    }

    protected void createInstances(Class<? extends DynamicPK> clazz) {
        this.instances.clear();
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            DynamicPK dynamicPK = this.createInstance(clazz, i);
            if (this.getDebug()) {
                System.out.println(this.toString(dynamicPK));
            }
            this.instances.add(dynamicPK);
        }
    }

    protected DynamicPK createInstance(Class<? extends DynamicPK> clazz, int n) {
        DynamicPK dynamicPK = (DynamicPK)((Object)this.session.newInstance(clazz));
        dynamicPK.setId(this.getPK(n));
        dynamicPK.setNumber(n);
        dynamicPK.setName(this.getValue(n));
        return dynamicPK;
    }

    protected String toString(DynamicPK dynamicPK) {
        StringBuffer stringBuffer = new StringBuffer(((Object)((Object)dynamicPK)).getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append(this.toString(dynamicPK.getId()));
        stringBuffer.append("]: ");
        stringBuffer.append(dynamicPK.getNumber());
        stringBuffer.append(", \"");
        stringBuffer.append(dynamicPK.getName());
        stringBuffer.append("\".");
        return stringBuffer.toString();
    }

    protected byte[] getPK(int n) {
        byte[] byArray = new byte[255];
        byArray[1] = (byte)(n / 256);
        byArray[2] = (byte)(n % 256);
        return byArray;
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected void verify(String string, DynamicPK dynamicPK, int n, boolean bl) {
        this.errorIfNotEqual(string + "id failed", this.toString(this.getPK(n)), this.toString(dynamicPK.getId()));
        this.errorIfNotEqual(string + "number failed", n, dynamicPK.getNumber());
        if (bl) {
            this.errorIfNotEqual(string + " Value failed", this.getValue(this.NUMBER_OF_INSTANCES - n), dynamicPK.getName());
        } else {
            this.errorIfNotEqual(string + " Value failed", this.getValue(n), dynamicPK.getName());
        }
    }

    private String toString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i]));
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    public static class DynamicLongvarbinaryPK
    extends DynamicPK {
        public String table() {
            return "longvarbinarypk";
        }
    }

    public static class DynamicVarbinaryPK
    extends DynamicPK {
        public String table() {
            return "varbinarypk";
        }
    }

    public static class DynamicBinaryPK
    extends DynamicPK {
        public String table() {
            return "binarypk";
        }
    }
}

