/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.BlobTypes;

public class BlobTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 16;
    protected List<BlobTypes> blobs = new ArrayList<BlobTypes>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createBlobInstances(16);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(BlobTypes.class);
        this.tx.commit();
        this.addTearDownClasses(BlobTypes.class);
    }

    public void test() {
        this.insert();
        this.update();
        this.failOnError();
    }

    protected void insert() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            this.session.makePersistent((Object)this.blobs.get(i));
            ++n;
        }
        this.tx.commit();
    }

    protected void update() {
        byte[] byArray;
        int n;
        BlobTypes blobTypes;
        int n2;
        this.tx.begin();
        for (n2 = 1; n2 < 16; ++n2) {
            blobTypes = (BlobTypes)this.session.find(BlobTypes.class, (Object)n2);
            n = blobTypes.getId();
            if (n != n2) {
                this.error("Expected BlobTypes.id " + n2 + " but got " + n);
            }
            if ((byArray = blobTypes.getBlobbytes()) == null) {
                this.error("Unexpected blob bytes null for id " + n2);
                continue;
            }
            this.checkBlobBytes("before update", byArray, n2, false);
            int n3 = this.getBlobSizeFor(n2) / 2;
            if (byArray.length != n3 * 2) continue;
            byArray[n3] = (byte)(n3 % 128);
            this.checkBlobBytes("after update", byArray, n2, true);
            this.session.markModified((Object)blobTypes, "blobbytes");
            this.session.updatePersistent((Object)blobTypes);
        }
        this.tx.commit();
        this.tx.begin();
        for (n2 = 1; n2 < 16; ++n2) {
            blobTypes = (BlobTypes)this.session.find(BlobTypes.class, (Object)n2);
            n = blobTypes.getId();
            if (n != n2) {
                this.error("Expected BlobTypes.id " + n2 + " but got " + n);
            }
            if ((byArray = blobTypes.getBlobbytes()) == null) {
                this.error("Unexpected blob bytes null for id " + n2);
                continue;
            }
            this.checkBlobBytes("after commit", blobTypes.getBlobbytes(), n2, true);
        }
        this.tx.commit();
    }

    protected void createBlobInstances(int n) {
        for (int i = 0; i < n; ++i) {
            BlobTypes blobTypes = (BlobTypes)this.session.newInstance(BlobTypes.class);
            blobTypes.setId(i);
            int n2 = this.getBlobSizeFor(i);
            blobTypes.setBlobbytes(this.getBlobBytes(n2));
            this.blobs.add(blobTypes);
        }
    }

    protected byte[] getBlobBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(i % 256 - 128);
        }
        return byArray;
    }

    protected void checkBlobBytes(String string, byte[] byArray, int n, boolean bl) {
        this.dumpBlob(string, byArray);
        int n2 = this.getBlobSizeFor(n);
        int n3 = byArray.length;
        if (n2 != n3) {
            this.error("In " + string + " wrong size of byte[]; " + "expected: " + n2 + " actual: " + n3);
        }
        for (int i = 0; i < n3; ++i) {
            byte by;
            int n4 = n2 / 2;
            byte by2 = bl && i == n4 ? (byte)(n4 % 128) : (byte)(i % 256 - 128);
            if (by2 == (by = byArray[i])) continue;
            this.error("In " + string + " for size: " + n3 + " mismatch in byte[] at position " + i + " expected: " + by2 + " actual: " + by);
        }
    }

    protected InputStream getBlobStream(final int n) {
        return new InputStream(){
            int counter = 0;

            @Override
            public int read() throws IOException {
                if (this.counter >= n) {
                    return -1;
                }
                return this.counter++ % 256;
            }
        };
    }

    protected void dumpBlob(String string, byte[] byArray) {
    }

    protected int getBlobSizeFor(int n) {
        int n2 = (int)Math.pow(2.0, n);
        return n2;
    }
}

