/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfiguration;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfigurationImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;

public class NdbOpenJPABrokerFactory
extends JDBCBrokerFactory {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPABrokerFactory.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPABrokerFactory.class);

    public static NdbOpenJPABrokerFactory newInstance(ConfigurationProvider configurationProvider) {
        NdbOpenJPAConfigurationImpl ndbOpenJPAConfigurationImpl = new NdbOpenJPAConfigurationImpl();
        configurationProvider.setInto((Configuration)ndbOpenJPAConfigurationImpl);
        return new NdbOpenJPABrokerFactory(ndbOpenJPAConfigurationImpl);
    }

    public static NdbOpenJPABrokerFactory getInstance(ConfigurationProvider configurationProvider) {
        Map map = configurationProvider.getProperties();
        Object object = NdbOpenJPABrokerFactory.toPoolKey((Map)map);
        NdbOpenJPABrokerFactory ndbOpenJPABrokerFactory = (NdbOpenJPABrokerFactory)NdbOpenJPABrokerFactory.getPooledFactoryForKey((Object)object);
        if (ndbOpenJPABrokerFactory != null) {
            return ndbOpenJPABrokerFactory;
        }
        ndbOpenJPABrokerFactory = NdbOpenJPABrokerFactory.newInstance(configurationProvider);
        NdbOpenJPABrokerFactory.pool((Object)object, (AbstractBrokerFactory)ndbOpenJPABrokerFactory);
        return ndbOpenJPABrokerFactory;
    }

    public NdbOpenJPABrokerFactory(NdbOpenJPAConfiguration ndbOpenJPAConfiguration) {
        super((JDBCConfiguration)ndbOpenJPAConfiguration);
        if (logger.isInfoEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("connectString: " + ndbOpenJPAConfiguration.getConnectString());
            stringBuffer.append("; connectDelay: " + ndbOpenJPAConfiguration.getConnectDelay());
            stringBuffer.append("; connectVerbose: " + ndbOpenJPAConfiguration.getConnectVerbose());
            stringBuffer.append("; connectTimeoutBefore: " + ndbOpenJPAConfiguration.getConnectTimeoutBefore());
            stringBuffer.append("; connectTimeoutAfter: " + ndbOpenJPAConfiguration.getConnectTimeoutAfter());
            stringBuffer.append("; maxTransactions: " + ndbOpenJPAConfiguration.getMaxTransactions());
            stringBuffer.append("; default database: " + ndbOpenJPAConfiguration.getDatabase());
            logger.info(stringBuffer.toString());
        }
    }

    protected StoreManager newStoreManager() {
        return new NdbOpenJPAStoreManager();
    }
}

