/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.AndPredicateImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.NotPredicateImpl;
import com.mysql.clusterj.core.query.OrPredicateImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.Predicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public abstract class PredicateImpl
implements Predicate {
    static final I18NHelper local = I18NHelper.getInstance(PredicateImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(PredicateImpl.class);
    protected QueryDomainTypeImpl<?> dobj;
    CandidateIndexImpl uniqueIndex;
    Comparator<CandidateIndexImpl> candidateIndexComparator = new Comparator<CandidateIndexImpl>(){

        @Override
        public int compare(CandidateIndexImpl candidateIndexImpl, CandidateIndexImpl candidateIndexImpl2) {
            return candidateIndexImpl2.score - candidateIndexImpl.score;
        }
    };
    private TreeSet<CandidateIndexImpl> scoredCandidateIndices = new TreeSet<CandidateIndexImpl>(this.candidateIndexComparator);
    public static int NO_BOUND_SET = 0;
    public static int LOWER_BOUND_SET = 1;
    public static int UPPER_BOUND_SET = 2;
    public static int BOTH_BOUNDS_SET = 3;

    public PredicateImpl(QueryDomainTypeImpl<?> queryDomainTypeImpl) {
        this.dobj = queryDomainTypeImpl;
    }

    @Override
    public Predicate or(Predicate predicate) {
        this.assertPredicateImpl(predicate);
        PredicateImpl predicateImpl = (PredicateImpl)predicate;
        this.assertIdenticalDomainObject(predicateImpl, "or");
        return new OrPredicateImpl(this.dobj, this, predicateImpl);
    }

    @Override
    public Predicate and(Predicate predicate) {
        this.assertPredicateImpl(predicate);
        PredicateImpl predicateImpl = (PredicateImpl)predicate;
        this.assertIdenticalDomainObject(predicateImpl, "and");
        if (predicate instanceof AndPredicateImpl) {
            AndPredicateImpl andPredicateImpl = (AndPredicateImpl)predicate;
            return andPredicateImpl.and(this);
        }
        return new AndPredicateImpl(this.dobj, this, predicateImpl);
    }

    @Override
    public Predicate not() {
        return new NotPredicateImpl(this);
    }

    void markBoundsForCandidateIndices(QueryExecutionContext queryExecutionContext, CandidateIndexImpl[] candidateIndexImplArray) {
    }

    public int operationSetBounds(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, boolean bl) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public int operationSetLowerBound(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, boolean bl) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public int operationSetUpperBound(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, boolean bl) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void operationEqual(QueryExecutionContext queryExecutionContext, Operation operation) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void operationEqualFor(QueryExecutionContext queryExecutionContext, Operation operation, String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void objectSetValuesFor(QueryExecutionContext queryExecutionContext, Object object, String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void filterCmpValue(QueryExecutionContext queryExecutionContext, ScanOperation scanOperation) {
        try {
            ScanFilter scanFilter = scanOperation.getScanFilter(queryExecutionContext);
            scanFilter.begin();
            this.filterCmpValue(queryExecutionContext, scanOperation, scanFilter);
            scanFilter.end();
        }
        catch (ClusterJException clusterJException) {
            throw clusterJException;
        }
        catch (Exception exception) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), exception);
        }
    }

    public void filterCmpValue(QueryExecutionContext queryExecutionContext, ScanOperation scanOperation, ScanFilter scanFilter) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public void assertIdenticalDomainObject(PredicateImpl predicateImpl, String string) {
        QueryDomainTypeImpl<?> queryDomainTypeImpl = predicateImpl.getDomainObject();
        if (this.dobj != queryDomainTypeImpl) {
            throw new ClusterJUserException(local.message("ERR_Wrong_Domain_Object", (Object)string));
        }
    }

    void setSatisfied() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void markParameters() {
    }

    public void unmarkParameters() {
    }

    private void assertPredicateImpl(Predicate predicate) {
        if (!(predicate instanceof PredicateImpl)) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }
    }

    private QueryDomainTypeImpl<?> getDomainObject() {
        return this.dobj;
    }

    public CandidateIndexImpl getBestCandidateIndex(QueryExecutionContext queryExecutionContext, String[] stringArray) {
        return this.getBestCandidateIndexFor(queryExecutionContext, this.getTopLevelPredicates(), stringArray);
    }

    protected CandidateIndexImpl getBestCandidateIndexFor(QueryExecutionContext queryExecutionContext, PredicateImpl[] predicateImplArray, String[] stringArray) {
        if (this.uniqueIndex != null && this.uniqueIndex.isUsable(queryExecutionContext, null) > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("usable unique index: " + this.uniqueIndex.getIndexName());
            }
            return this.uniqueIndex;
        }
        CandidateIndexImpl candidateIndexImpl = null;
        for (CandidateIndexImpl candidateIndexImpl2 : this.scoredCandidateIndices) {
            int n = candidateIndexImpl2.isUsable(queryExecutionContext, stringArray);
            if (logger.isDebugEnabled()) {
                logger.debug("index " + candidateIndexImpl2.getIndexName() + " usability: " + n);
            }
            if (n > 0) {
                return candidateIndexImpl2;
            }
            if (n != 0 || candidateIndexImpl2.isUnique()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("last resort: " + candidateIndexImpl.getIndexName());
            }
            candidateIndexImpl = candidateIndexImpl2;
        }
        return candidateIndexImpl != null && stringArray != null ? candidateIndexImpl : CandidateIndexImpl.getIndexForNullWhereClause();
    }

    protected int getNumberOfConditionsInPredicate() {
        return 1;
    }

    public void prepare() {
        CandidateIndexImpl[] candidateIndexImplArray = this.dobj.createCandidateIndexes();
        for (PredicateImpl predicateImpl : this.getTopLevelPredicates()) {
            predicateImpl.markBoundsForCandidateIndices(candidateIndexImplArray);
        }
        int n = this.getNumberOfConditionsInPredicate();
        for (CandidateIndexImpl candidateIndexImpl : candidateIndexImplArray) {
            if (!candidateIndexImpl.supportsConditionsOfLength(n)) continue;
            candidateIndexImpl.score();
            int n2 = candidateIndexImpl.getScore();
            if (n2 != 0 && candidateIndexImpl.isUnique()) {
                this.uniqueIndex = candidateIndexImpl;
            } else {
                this.scoredCandidateIndices.add(candidateIndexImpl);
            }
            if (!logger.isDetailEnabled()) continue;
            logger.detail("Score: " + n2 + " from " + candidateIndexImpl.getIndexName());
        }
    }

    protected void markBoundsForCandidateIndices(CandidateIndexImpl[] candidateIndexImplArray) {
    }

    protected PredicateImpl[] getTopLevelPredicates() {
        return new PredicateImpl[]{this};
    }

    public List<String> getTopLevelPropertyNames() {
        PredicateImpl[] predicateImplArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PredicateImpl predicateImpl : predicateImplArray = this.getTopLevelPredicates()) {
            PropertyImpl propertyImpl = predicateImpl.getProperty();
            if (propertyImpl == null) continue;
            arrayList.add(propertyImpl.fmd.getName());
        }
        return arrayList;
    }

    public ParameterImpl getParameter() {
        return null;
    }

    protected PropertyImpl getProperty() {
        return null;
    }

    public boolean isUsable(QueryExecutionContext queryExecutionContext) {
        return false;
    }

    protected static enum ScanType {
        INDEX_SCAN,
        TABLE_SCAN,
        UNIQUE_KEY,
        PRIMARY_KEY;

    }
}

