/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.ResultDataImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import java.util.List;

class ScanResultDataImpl
extends ResultDataImpl {
    static final I18NHelper local = I18NHelper.getInstance(ScanResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ScanResultDataImpl.class);
    private NdbScanOperation ndbScanOperation = null;
    private ClusterTransactionImpl clusterTransaction = null;
    protected long skip = 0L;
    protected long limit = Long.MAX_VALUE;
    protected long recordCounter = 0L;
    boolean recordsLocked = false;
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;

    public ScanResultDataImpl(ClusterTransactionImpl clusterTransaction, NdbScanOperation ndbScanOperation, List<Column> storeColumns, int maximumColumnId, int bufferSize, int[] offsets, int[] lengths, int maximumColumnLength, DbImpl.BufferManager bufferManager, long skip, long limit) {
        super(ndbScanOperation, storeColumns, maximumColumnId, bufferSize, offsets, lengths, bufferManager, false);
        this.clusterTransaction = clusterTransaction;
        this.ndbScanOperation = ndbScanOperation;
        this.skip = skip;
        this.limit = limit;
    }

    private void executeIfRecordsLocked() {
        if (this.recordsLocked) {
            this.clusterTransaction.executeNoCommit(true, true);
            this.recordsLocked = false;
        }
    }

    @Override
    public boolean next() {
        if (this.recordCounter >= this.limit) {
            this.executeIfRecordsLocked();
            this.ndbScanOperation.close(true, true);
            return false;
        }
        boolean done = false;
        boolean fetch = false;
        boolean force = true;
        block5: while (!done) {
            int result = this.ndbScanOperation.nextResult(fetch, force);
            switch (result) {
                case 0: {
                    if (++this.recordCounter <= this.skip) continue block5;
                    if (this.ndbScanOperation.getLockMode() != 2) {
                        this.ndbScanOperation.lockCurrentTuple();
                        this.recordsLocked = true;
                    }
                    return true;
                }
                case 1: {
                    this.executeIfRecordsLocked();
                    this.ndbScanOperation.close(true, true);
                    return false;
                }
                case 2: {
                    this.executeIfRecordsLocked();
                    fetch = true;
                    continue block5;
                }
            }
            Utility.throwError(result, this.ndbScanOperation.getNdbError());
        }
        return true;
    }
}

