/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import java.nio.ByteBuffer;

class BlobImpl
implements Blob {
    static final I18NHelper local = I18NHelper.getInstance(BlobImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BlobImpl.class);
    protected NdbBlob ndbBlob;

    public BlobImpl() {
    }

    public BlobImpl(NdbBlob blob) {
        this.ndbBlob = blob;
    }

    @Override
    public Long getLength() {
        long[] length = new long[1];
        int returnCode = this.ndbBlob.getLength(length);
        BlobImpl.handleError(returnCode, this.ndbBlob);
        return length[0];
    }

    @Override
    public void readData(byte[] array, int length) {
        int[] lengthRead = new int[]{length};
        ByteBuffer buffer = ByteBuffer.allocateDirect(array.length);
        int returnCode = this.ndbBlob.readData(buffer, lengthRead);
        BlobImpl.handleError(returnCode, this.ndbBlob);
        if (lengthRead[0] != length) {
            throw new ClusterJFatalInternalException(local.message("ERR_Blob_Read_Data", (Object)length, (Object)lengthRead[0]));
        }
        buffer.get(array);
    }

    @Override
    public void writeData(byte[] array) {
        if (array == null) {
            this.setNull();
            return;
        }
        if (array.length == 0) {
            return;
        }
        ByteBuffer buffer = null;
        if (array.length > 0) {
            buffer = ByteBuffer.allocateDirect(array.length);
            buffer.put(array);
            buffer.flip();
        }
        int returnCode = this.ndbBlob.writeData(buffer, array.length);
        BlobImpl.handleError(returnCode, this.ndbBlob);
    }

    @Override
    public void setValue(byte[] array) {
        if (array == null) {
            this.setNull();
            return;
        }
        if (array.length == 0) {
            return;
        }
        ByteBuffer buffer = null;
        if (array.length > 0) {
            buffer = ByteBuffer.allocateDirect(array.length);
            buffer.put(array);
            buffer.flip();
        }
        int returnCode = this.ndbBlob.setValue(buffer, array.length);
        BlobImpl.handleError(returnCode, this.ndbBlob);
    }

    @Override
    public void setNull() {
        int returnCode = this.ndbBlob.setNull();
        BlobImpl.handleError(returnCode, this.ndbBlob);
    }

    @Override
    public void close() {
        int returnCode = this.ndbBlob.close(true);
        BlobImpl.handleError(returnCode, this.ndbBlob);
    }

    protected static void handleError(int returnCode, NdbBlob ndbBlob) {
        if (returnCode == 0) {
            return;
        }
        Utility.throwError(returnCode, ndbBlob.getNdbError());
    }
}

