/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.ClusterConnectionService;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

public class ClusterConnectionServiceImpl
implements ClusterConnectionService {
    static final I18NHelper local = I18NHelper.getInstance(ClusterConnectionServiceImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterConnectionServiceImpl.class);
    static boolean ndbclientLoaded;
    static int SIZEOF_OPERATION_OPTIONS;
    static int SIZEOF_PARTITION_SPEC;
    static int SIZEOF_RECORD_SPECIFICATION;
    static int SIZEOF_SCAN_OPTIONS;

    protected static void loadSystemLibrary(String name) {
        if (ndbclientLoaded) {
            return;
        }
        try {
            System.loadLibrary(name);
            Utility.getCharsetMap();
            SIZEOF_OPERATION_OPTIONS = NdbOperation.OperationOptions.size();
            SIZEOF_PARTITION_SPEC = Ndb.PartitionSpec.size();
            SIZEOF_RECORD_SPECIFICATION = NdbDictionary.RecordSpecification.size();
            SIZEOF_SCAN_OPTIONS = NdbScanOperation.ScanOptions.size();
            ndbclientLoaded = true;
        }
        catch (Throwable e) {
            String path = ClusterConnectionServiceImpl.getLoadLibraryPath();
            String message = local.message("ERR_Failed_Loading_Library", name, path, e.getClass(), e.getLocalizedMessage());
            logger.fatal(message);
            throw new ClusterJFatalUserException(message, e);
        }
    }

    @Override
    public ClusterConnection create(String connectString, int nodeId) {
        ClusterConnectionServiceImpl.loadSystemLibrary("ndbclient");
        try {
            return new ClusterConnectionImpl(connectString, nodeId);
        }
        catch (ClusterJFatalUserException cjex) {
            throw cjex;
        }
        catch (Exception e) {
            String message = local.message("ERR_Connect", (Object)connectString, (Object)nodeId);
            logger.fatal(message);
            throw new ClusterJFatalUserException(message, e);
        }
    }

    private static String getLoadLibraryPath() {
        String path;
        try {
            path = System.getProperty("java.library.path");
        }
        catch (Exception ex) {
            path = "<Exception: " + ex.getMessage() + ">";
        }
        return path;
    }

    static {
        LoggerFactoryService.getFactory().registerLogger("com.mysql.clusterj.tie");
        ndbclientLoaded = false;
    }
}

