/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.DynamicObject;
import java.nio.ByteBuffer;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.IdBase;

@Ignore
public class StressTest
extends AbstractClusterJModelTest {
    protected static final Runtime rt = Runtime.getRuntime();
    private static final int NUMBER_TO_INSERT = 4000;
    private static final int ITERATIONS = 7;
    private static final int ITERATIONS_TO_DROP = 3;
    private static final String STRESS_TEST_TABLE_PROPERTY_NAME = "com.mysql.clusterj.StressTestTable";
    private static String tableName = ClusterJHelper.getStringProperty((String)"com.mysql.clusterj.StressTestTable", (String)"stress");
    private ColumnMetadata[] columnMetadatas;
    private ColumnMetadata keyMetadata;
    private Timer timer = new Timer();
    private static int BYTES_LENGTH = 12000;
    private static ByteBuffer BYTES = ByteBuffer.allocate(BYTES_LENGTH);
    private static final byte[] DIGITS;
    private static int STRING_LENGTH;
    private static String STRING;

    @Override
    Class<? extends IdBase> getModelClass() {
        return Stress.class;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.session.deletePersistentAll(Stress.class);
        this.columnMetadatas = ((Stress)this.session.newInstance(Stress.class)).columnMetadata();
        this.findKeyMetadata();
    }

    public void testIndy() {
        this.insAattr_indy();
        this.getA_indy();
        this.delA_indy();
    }

    public void testEach() {
        this.insAattr_each();
        this.getA_each();
        this.delA_each();
    }

    public void testBulk() {
        this.insAattr_bulk();
        this.getA_bulk();
        this.delA_bulk();
    }

    public void insAattr_indy() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            this.session.deletePersistentAll(Stress.class);
            StressTest.gc();
            this.timer.start();
            for (int key = 0; key < 4000; ++key) {
                Stress instance = this.createObject(key);
                this.session.makePersistent((Object)instance);
            }
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("insAattr_indy: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void insAattr_each() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            this.session.deletePersistentAll(Stress.class);
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int key = 0; key < 4000; ++key) {
                Stress instance = this.createObject(key);
                this.session.makePersistent((Object)instance);
                this.session.flush();
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("insAattr_each: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void insAattr_bulk() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            this.session.deletePersistentAll(Stress.class);
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int key = 0; key < 4000; ++key) {
                Stress instance = this.createObject(key);
                this.session.makePersistent((Object)instance);
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("insAattr_bulk: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void getA_indy() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            for (int key = 0; key < 4000; ++key) {
                this.session.find(Stress.class, this.createKey(key));
            }
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("getA_indy: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void getA_each() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int key = 0; key < 4000; ++key) {
                this.session.find(Stress.class, this.createKey(key));
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("getA_each: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void getA_bulk() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int key = 0; key < 4000; ++key) {
                Stress instance = (Stress)this.session.newInstance(Stress.class, this.createKey(key));
                this.session.load((Object)instance);
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("getA_bulk: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void delA_indy() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            for (int key = 0; key < 4000; ++key) {
                this.session.deletePersistent(Stress.class, this.createKey(key));
            }
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("delA_indy: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void delA_each() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int key = 0; key < 4000; ++key) {
                this.session.deletePersistent(Stress.class, this.createKey(key));
                this.session.flush();
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("delA_each: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    public void delA_bulk() {
        long total = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int key = 0; key < 4000; ++key) {
                this.session.deletePersistent(Stress.class, this.createKey(key));
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                total += this.timer.time();
            }
            System.out.println("delA_bulk: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + total / 4L + "\n");
    }

    protected Stress createObject(int key) {
        Stress instance = (Stress)this.session.newInstance(Stress.class);
        for (int columnNumber = 0; columnNumber < this.columnMetadatas.length; ++columnNumber) {
            Object value = null;
            ColumnMetadata columnMetadata = this.columnMetadatas[columnNumber];
            Class cls = columnMetadata.javaType();
            int length = columnMetadata.maximumLength();
            if (columnMetadata.isPrimaryKey()) {
                value = this.createKey(key);
            } else if (Integer.TYPE == cls) {
                value = key + columnNumber;
            } else if (Long.TYPE == cls) {
                value = (long)(key + columnNumber);
            } else if (Float.TYPE == cls) {
                value = Float.valueOf(key + columnNumber);
            } else if (Double.TYPE == cls) {
                value = (double)(key + columnNumber);
            } else if (Short.TYPE == cls) {
                value = (short)(key + columnNumber);
            } else if (Byte.TYPE == cls) {
                value = (byte)(key + columnNumber);
            } else if (Integer.class == cls) {
                value = key + columnNumber;
            } else if (Long.class == cls) {
                value = (long)(key + columnNumber);
            } else if (Float.class == cls) {
                value = Float.valueOf(key + columnNumber);
            } else if (Double.class == cls) {
                value = (double)(key + columnNumber);
            } else if (Short.class == cls) {
                value = (short)(key + columnNumber);
            } else if (Byte.class == cls) {
                value = (byte)(key + columnNumber);
            } else if (String.class == cls) {
                value = STRING.substring(key + columnNumber, key + columnNumber + length);
            } else if (byte[].class == cls) {
                value = new byte[length];
                BYTES.position(key + columnNumber);
                BYTES.get((byte[])value);
            } else {
                throw new ClusterJFatalUserException("Unsupported column type " + cls.getName() + " for column " + columnMetadata.name());
            }
            instance.set(columnNumber, value);
        }
        return instance;
    }

    private Object createKey(int key) {
        Object value = null;
        Class cls = this.keyMetadata.javaType();
        int length = this.keyMetadata.maximumLength();
        if (Integer.TYPE == cls) {
            value = key;
        } else if (Long.TYPE == cls) {
            value = (long)key;
        } else if (String.class == cls) {
            value = String.valueOf(key);
        } else if (byte[].class == cls) {
            String digits = String.valueOf(key);
            if (this.keyMetadata.columnType() == ColumnType.Binary) {
                value = new byte[length];
            } else if (this.keyMetadata.columnType() == ColumnType.Varbinary) {
                value = new byte[digits.length()];
            }
            this.convertToBytes((byte[])value, digits);
            if (this.debug) {
                System.out.println("Key: " + this.dump((byte[])value));
            }
        } else {
            throw new ClusterJFatalUserException("Unsupported column type " + cls.getName() + " for column " + this.keyMetadata.name());
        }
        return value;
    }

    private void findKeyMetadata() {
        for (ColumnMetadata columnMetadata : this.columnMetadatas) {
            if (!columnMetadata.isPrimaryKey()) continue;
            if (this.keyMetadata != null) {
                throw new RuntimeException("Compound primary keys are not supported.");
            }
            this.keyMetadata = columnMetadata;
        }
    }

    private String dump(byte[] value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            builder.append("0123456789".charAt(value[i] - 48));
        }
        return builder.toString();
    }

    private void convertToBytes(byte[] value, String digits) {
        int j = digits.length();
        for (int i = value.length - 1; i >= 0; --i) {
            if (j-- > 0) {
                int digit = digits.charAt(j) - 48;
                value[i] = DIGITS[digit];
                continue;
            }
            value[i] = 48;
        }
    }

    private static void gc() {
        int nFullGCs = 10;
        for (int i = 0; i < 10; ++i) {
            long oldfree;
            long newfree = rt.freeMemory();
            do {
                oldfree = newfree;
                rt.runFinalization();
                rt.gc();
            } while ((newfree = rt.freeMemory()) > oldfree);
        }
    }

    static {
        for (int i = 0; i < BYTES_LENGTH; ++i) {
            BYTES.put((byte)(i % 32 + 65));
        }
        DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        STRING_LENGTH = 12000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < STRING_LENGTH; ++i) {
            builder.append((byte)(i % 32 + 65));
        }
        STRING = builder.toString();
    }

    private static class Timer {
        private long time;

        private Timer() {
        }

        public void start() {
            this.time = System.nanoTime() / 1000000L;
        }

        public long stop() {
            this.time = System.nanoTime() / 1000000L - this.time;
            return this.time;
        }

        public long time() {
            return this.time;
        }
    }

    public static class Stress
    extends DynamicObject
    implements IdBase {
        public String table() {
            System.out.println("Stress table being used: " + tableName);
            return tableName;
        }

        @Override
        public int getId() {
            return (Integer)this.get(0);
        }

        @Override
        public void setId(int id) {
            this.set(0, id);
        }
    }
}

