/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import java.util.Arrays;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.LongIntStringIndex;

public class QueryOrderingTest
extends AbstractQueryTest {
    protected int PK_MODULUS = 3;
    protected long PRETTY_BIG_NUMBER = 1000000000000000L;

    @Override
    public Class<?> getInstanceType() {
        return LongIntStringIndex.class;
    }

    @Override
    protected int getNumberOfInstances() {
        return 25;
    }

    @Override
    protected boolean getCleanupAfterTest() {
        return false;
    }

    public void testNegativeOrderingFieldsTooLong() {
        try {
            this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix", "stringix", "id");
            this.greaterEqualQuery("longix", "idx_long_int_string", 0L, 9);
            QueryOrderingTest.fail("Ordering fields too long should fail.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
        this.failOnError();
    }

    public void testNegativeNoIndexMatchesOrderingFields() {
        try {
            this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix", "id");
            this.greaterEqualQuery("longix", "idx_long_int_string", 0L, 9);
            QueryOrderingTest.fail("Ordering field not in index should fail.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
        this.failOnError();
    }

    public void testNegativeOrderingFieldsNotInPosition() {
        try {
            this.setOrdering(Query.Ordering.ASCENDING, "longix", "stringix", "intix");
            this.greaterEqualQuery("longix", "idx_long_int_string", 0L, 9);
            QueryOrderingTest.fail("Ordering field in wrong position in index should fail.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
        this.failOnError();
    }

    public void testNegativeOrderingFieldsAreNotFields() {
        try {
            this.setOrdering(Query.Ordering.ASCENDING, "poop");
            this.greaterEqualQuery("longix", "idx_long_int_string", 0L, 9);
            QueryOrderingTest.fail("Ordering field not a field should fail.");
        }
        catch (ClusterJUserException ex) {
            String message = ex.getMessage();
            this.errorIfNotEqual("Error message '" + message + "' does not contain the name of the failing field 'poop'.", true, message.contains("poop"));
        }
        this.failOnError();
    }

    public void testNegativeMultipleOrderingFieldsAreNotFields() {
        try {
            this.setOrdering(Query.Ordering.ASCENDING, "dupe", "poop");
            this.greaterEqualQuery("longix", "idx_long_int_string", 0L, 9);
            QueryOrderingTest.fail("Ordering field not a field should fail.");
        }
        catch (ClusterJUserException ex) {
            String message = ex.getMessage();
            this.errorIfNotEqual("Error message '" + message + "' does not contain the name of the failing fields 'poop' and 'dupe'.", true, message.contains("poop") && message.contains("dupe"));
        }
        this.failOnError();
    }

    public void testNoWhereAscending() {
        this.setOrdering(Query.Ordering.ASCENDING, "id");
        this.noWhereQuery("id", "PRIMARY", null, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24);
        this.failOnError();
    }

    public void testNoWhereDescending() {
        this.setOrdering(Query.Ordering.DESCENDING, "id");
        this.noWhereQuery("id", "PRIMARY", null, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0);
        this.failOnError();
    }

    public void testPrimaryEqualAscending() {
        this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix", "stringix");
        this.equalQuery("id", "PRIMARY", 1, 1);
        this.failOnError();
    }

    public void testGreaterEqualAscending() {
        this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix", "stringix");
        this.greaterEqualQuery("longix", "idx_long_int_string", 2000000000000000L, 18, 19, 20, 21, 22, 23, 24);
        this.failOnError();
    }

    public void testGreaterEqualAscendingPartial() {
        this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix");
        this.greaterEqualQuery("longix", "idx_long_int_string", 2000000000000000L, 18, 19, 20, 21, 22, 23, 24);
        this.failOnError();
    }

    public void testInAndBetweenAscending() {
        this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix");
        this.inAndBetweenQuery("longix", new Object[]{1000000000000000L, 0L}, "intix", 1, 2, "idx_long_int_string", 12, 13, 14, 15, 16, 17, 3, 4, 5, 6, 7, 8);
        this.inAndBetweenQuery("longix", Arrays.asList(1000000000000000L, 0L), "stringix", "1", "4", "idx_long_int_string", 10, 11, 13, 14, 16, 17, 1, 2, 4, 5, 7, 8);
        this.failOnError();
    }

    public void testInAndBetweenDescending() {
        this.setOrdering(Query.Ordering.DESCENDING, "longix", "intix", "stringix");
        this.inAndBetweenQuery("longix", new Object[]{1000000000000000L, 0L}, "intix", 1, 2, "idx_long_int_string", 17, 16, 15, 14, 13, 12, 8, 7, 6, 5, 4, 3);
        this.inAndBetweenQuery("longix", Arrays.asList(1000000000000000L, 0L), "stringix", "1", "4", "idx_long_int_string", 17, 16, 14, 13, 11, 10, 8, 7, 5, 4, 2, 1);
        this.failOnError();
    }

    public void testBetweenAndInAscending() {
        this.setOrdering(Query.Ordering.ASCENDING, "longix", "intix");
        this.betweenAndInQuery("longix", 0L, 1000000000000000L, "intix", new Object[]{2, 0}, "idx_long_int_string", 0, 1, 2, 6, 7, 8, 9, 10, 11, 15, 16, 17);
        this.betweenAndInQuery("longix", 1000000000000000L, 2000000000000000L, "intix", Arrays.asList(2, 1), "idx_long_int_string", 12, 13, 14, 15, 16, 17, 21, 22, 23, 24);
        this.failOnError();
    }

    public void testBetweenAndInDescending() {
        this.setOrdering(Query.Ordering.DESCENDING, "longix", "intix", "stringix");
        this.betweenAndInQuery("longix", 0L, 1000000000000000L, "intix", new Object[]{2, 0}, "idx_long_int_string", 17, 16, 15, 11, 10, 9, 8, 7, 6, 2, 1, 0);
        this.betweenAndInQuery("longix", 1000000000000000L, 2000000000000000L, "intix", Arrays.asList(2, 1), "idx_long_int_string", 24, 23, 22, 21, 17, 16, 15, 14, 13, 12);
        this.failOnError();
    }

    @Override
    protected void createInstances(int number) {
        for (int i = 0; i < number; ++i) {
            LongIntStringIndex instance = this.createInstance(i);
            this.instances.add(instance);
        }
    }

    protected LongIntStringIndex createInstance(int index) {
        LongIntStringIndex instance = (LongIntStringIndex)this.session.newInstance(LongIntStringIndex.class);
        instance.setId(index);
        instance.setLongix(this.getPK1(index));
        instance.setIntix(this.getPK2(index));
        instance.setStringix(this.getPK3(index));
        instance.setStringvalue(this.getValue(index));
        return instance;
    }

    protected long getPK1(int index) {
        return this.PRETTY_BIG_NUMBER * (long)(index / this.PK_MODULUS / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected int getPK2(int index) {
        return index / this.PK_MODULUS % this.PK_MODULUS;
    }

    protected String getPK3(int index) {
        return "" + index % this.PK_MODULUS;
    }

    protected String getValue(int index) {
        return "Value " + index;
    }

    protected String toString(LongIntStringIndex instance) {
        StringBuffer result = new StringBuffer();
        result.append("LongIntStringIndex[");
        result.append(instance.getId());
        result.append("]: ");
        result.append(instance.getLongix());
        result.append(", ");
        result.append(instance.getIntix());
        result.append(", \"");
        result.append(instance.getStringix());
        result.append("\", \"");
        result.append(instance.getStringvalue());
        result.append("\".");
        return result.toString();
    }
}

