/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.NotPersistentTypes;

public class NotPersistentTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 5;
    protected List<NotPersistentTypes> notPersistentTypes = new ArrayList<NotPersistentTypes>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createNotPersistentTypesInstances(5);
        int count = this.session.deletePersistentAll(NotPersistentTypes.class);
        this.addTearDownClasses(NotPersistentTypes.class);
    }

    public void test() {
        this.defaultValues();
        this.setValues();
        this.insert();
        this.find();
        this.query();
        this.badQuery();
        this.delete();
        this.failOnError();
    }

    protected void defaultValues() {
        NotPersistentTypes npt = (NotPersistentTypes)this.session.newInstance(NotPersistentTypes.class);
        this.errorIfNotEqual("NotPersistentInteger default value.", null, npt.getNotPersistentInteger());
        this.errorIfNotEqual("NotPersistentChildren default value.", null, npt.getNotPersistentChildren());
        this.errorIfNotEqual("NotPersistentInt default value.", 0, npt.getNotPersistentInt());
        this.errorIfNotEqual("Id default value.", 0, npt.getId());
        this.errorIfNotEqual("Name default value.", null, npt.getName());
        this.errorIfNotEqual("Magic default value.", 0, npt.getMagic());
        this.errorIfNotEqual("Age default value.", null, npt.getAge());
    }

    protected void setValues() {
        NotPersistentTypes npt = this.notPersistentTypes.get(0);
        ArrayList<NotPersistentTypes> children = new ArrayList<NotPersistentTypes>();
        children.add(this.notPersistentTypes.get(1));
        children.add(this.notPersistentTypes.get(2));
        npt.setNotPersistentChildren(children);
        this.errorIfNotEqual("NotPersistentInteger default value.", children, npt.getNotPersistentChildren());
        int intValue = 666;
        npt.setNotPersistentInt(intValue);
        this.errorIfNotEqual("NotPersistentChildren default value.", intValue, npt.getNotPersistentInt());
        Integer integerValue = intValue;
        npt.setNotPersistentInteger(integerValue);
        this.errorIfNotEqual("NotPersistentInt default value.", integerValue, npt.getNotPersistentInteger());
    }

    protected void insert() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        for (int i = 0; i < 5; ++i) {
            this.session.makePersistent((Object)this.notPersistentTypes.get(i));
        }
        this.tx.commit();
    }

    protected void find() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        for (int i = 0; i < 5; ++i) {
            NotPersistentTypes instance = (NotPersistentTypes)this.session.find(NotPersistentTypes.class, (Object)i);
            this.errorIfNotEqual("Wrong instance", i, instance.getId());
        }
        this.tx.commit();
    }

    protected void query() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType dobj = builder.createQueryDefinition(NotPersistentTypes.class);
        dobj.where(dobj.get("id").equal(dobj.param("id")));
        Query query = this.session.createQuery((QueryDefinition)dobj);
        query.setParameter("id", (Object)0);
        List result = query.getResultList();
        int resultSize = result.size();
        this.errorIfNotEqual("Wrong query result size", 1, resultSize);
        NotPersistentTypes npt = (NotPersistentTypes)result.get(0);
        int resultId = npt.getId();
        this.tx.commit();
        this.errorIfNotEqual("Wrong query result instance id 0", 0, resultId);
    }

    protected void badQuery() {
        try {
            QueryBuilder builder = this.session.getQueryBuilder();
            QueryDomainType dobj = builder.createQueryDefinition(NotPersistentTypes.class);
            dobj.where(dobj.get("notPersistentChildren").equal(dobj.param("id")));
            this.error("Failed to catch user exception for not-persistent query field");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }

    protected void delete() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        for (int i = 0; i < 5; ++i) {
            this.session.deletePersistent((Object)this.notPersistentTypes.get(i));
        }
        this.tx.commit();
    }

    protected void createNotPersistentTypesInstances(int count) {
        this.notPersistentTypes = new ArrayList<NotPersistentTypes>(count);
        for (int i = 0; i < count; ++i) {
            NotPersistentTypes npt = (NotPersistentTypes)this.session.newInstance(NotPersistentTypes.class);
            npt.setId(i);
            npt.setName("Employee number " + i);
            npt.setAge(i);
            npt.setMagic(i);
            this.notPersistentTypes.add(npt);
        }
    }
}

