/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Session;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import java.util.ArrayList;
import java.util.Random;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.AbstractClusterJTest;

public class MultithreadedFindTest
extends AbstractClusterJModelTest {
    private int numberOfThreads = 6;
    private int numberOfIterations = 5000;
    private ThreadGroup threadGroup;

    @Override
    protected boolean getDebug() {
        return false;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
    }

    public void test() {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<Finder> finders = new ArrayList<Finder>();
        this.threadGroup = new ThreadGroup("Finder");
        AbstractClusterJTest.MyUncaughtExceptionHandler uncaughtExceptionHandler = new AbstractClusterJTest.MyUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        for (int i = 0; i < this.numberOfThreads; ++i) {
            Finder finder = new Finder();
            Thread thread = new Thread(this.threadGroup, finder);
            threads.add(thread);
            finders.add(finder);
            thread.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while joining threads.");
            }
        }
        for (Throwable thrown : uncaughtExceptionHandler.getUncaughtExceptions()) {
            StackTraceElement[] elements;
            this.error("Caught exception: " + thrown.getClass().getName() + ": " + thrown.getMessage());
            for (StackTraceElement element : elements = thrown.getStackTrace()) {
                this.error("        at " + element.toString());
            }
        }
        this.failOnError();
    }

    @PersistenceCapable(table="subscriber")
    public static interface Subscriber {
        @PrimaryKey
        public String getImsi();

        public void setImsi(String var1);

        @Index(name="guti_UNIQUE")
        public String getGuti();

        public void setGuti(String var1);

        @Index(name="mme_s1ap_id_UNIQUE")
        public int getMme_s1ap_id();

        public void setMme_s1ap_id(int var1);

        public int getEnb_s1ap_id();

        public void setEnb_s1ap_id(int var1);

        public int getMme_teid();

        public void setMme_teid(int var1);

        public String getSgw_teid();

        public void setSgw_teid(String var1);

        public String getPgw_teid();

        public void setPgw_teid(String var1);

        @Index(name="imei_UNIQUE")
        public String getImei();

        public void setImei(String var1);

        @Index(name="msisdn_UNIQUE")
        public String getMsisdn();

        public void setMsisdn(String var1);

        public String getEcm_state();

        public void setEcm_state(String var1);

        public String getEmm_state();

        public void setEmm_state(String var1);

        public String getEps_cgi();

        public void setEps_cgi(String var1);

        public String getGlobal_enb_id();

        public void setGlobal_enb_id(String var1);

        public String getBearer_id();

        public void setBearer_id(String var1);

        public String getSgw_ip_addr();

        public void setSgw_ip_addr(String var1);
    }

    class Finder
    implements Runnable {
        private Random myRandom = new Random();
        private Session session;
        private long time;

        Finder() {
        }

        public long getTime() {
            return this.time;
        }

        @Override
        public void run() {
            if (MultithreadedFindTest.this.getDebug()) {
                System.out.println("Getting session.");
            }
            this.session = MultithreadedFindTest.this.sessionFactory.getSession();
            long start = System.nanoTime();
            if (MultithreadedFindTest.this.getDebug()) {
                System.out.println("Finding " + MultithreadedFindTest.this.numberOfIterations + " subscribers.");
            }
            for (int i = 0; i < MultithreadedFindTest.this.numberOfIterations; ++i) {
                int r = this.myRandom.nextInt(4000);
                this.find(r);
            }
            long stop = System.nanoTime();
            this.time = stop - start;
            if (MultithreadedFindTest.this.getDebug()) {
                System.out.println("Elapsed time for " + MultithreadedFindTest.this.numberOfIterations + " find operations: " + this.time / 1000000L + "(ms.)");
            }
        }

        public void find(int id) {
            Subscriber subscriber = (Subscriber)this.session.find(Subscriber.class, (Object)String.valueOf(id));
            if (subscriber != null) {
                String string = subscriber.getImsi();
            }
        }
    }
}

