/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

public class ResultPrinter
implements TestListener {
    int testNumber = 0;
    PrintStream printer = System.out;
    StringBuilder messages = new StringBuilder();

    public ResultPrinter(PrintStream printer) {
        this.printer = printer;
    }

    @Override
    public void addError(Test test, Throwable t) {
        this.printer.print("ERROR...");
        this.messages.append(this.testNumber);
        this.messages.append(": ");
        this.messages.append(test.toString());
        this.messages.append(" FAILED:\n");
        StringWriter stringWriter = new StringWriter();
        PrintWriter stackPrinter = new PrintWriter(stringWriter);
        t.printStackTrace(stackPrinter);
        this.messages.append(stringWriter.toString());
        this.messages.append("\n");
    }

    @Override
    public void addFailure(Test test, AssertionFailedError t) {
        this.printer.print("FAILURE...");
        this.messages.append(this.testNumber);
        this.messages.append(": ");
        this.messages.append(test.toString());
        this.messages.append(" FAILED:\n");
        this.messages.append(t.getMessage());
        this.messages.append("\n");
    }

    @Override
    public void endTest(Test test) {
        this.printer.println();
    }

    @Override
    public void startTest(Test test) {
        ++this.testNumber;
        this.printer.print(this.testNumber + ": " + test.toString() + " running...");
    }

    public String toString() {
        return this.messages.toString();
    }
}

