/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NdbRecordDeleteOperationImpl
extends NdbRecordOperationImpl {
    public NdbRecordDeleteOperationImpl(ClusterTransactionImpl clusterTransaction, Table storeTable) {
        super(clusterTransaction, storeTable);
        this.ndbRecordKeys = clusterTransaction.getCachedNdbRecordImpl(storeTable);
        this.keyBufferSize = this.ndbRecordKeys.getBufferSize();
        this.numberOfColumns = this.ndbRecordKeys.getNumberOfColumns();
        this.resetMask();
    }

    @Override
    public void beginDefinition() {
        this.keyBuffer = ByteBuffer.allocateDirect(this.keyBufferSize);
        this.keyBuffer.order(ByteOrder.nativeOrder());
    }

    @Override
    public void endDefinition() {
        this.ndbOperation = this.delete(this.clusterTransaction);
        this.clusterTransaction.postExecuteCallback(new Runnable(){

            @Override
            public void run() {
                NdbRecordDeleteOperationImpl.this.freeResourcesAfterExecute();
            }
        });
    }

    @Override
    public String toString() {
        return " delete " + this.tableName;
    }
}

