/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractDomainFieldHandlerImpl
implements DomainFieldHandler,
ColumnMetadata {
    public static final byte[] emptyByteArray = new byte[0];
    static final I18NHelper local = I18NHelper.getInstance(AbstractDomainFieldHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(AbstractDomainFieldHandlerImpl.class);
    protected DomainTypeHandler<?> domainTypeHandler;
    protected boolean nullable;
    protected String columnDefaultValue = null;
    protected String columnName = "";
    protected Column storeColumn;
    protected String charsetName = null;
    protected int precision;
    protected int scale;
    protected int maximumLength;
    protected boolean partitionKey;
    protected ColumnType storeColumnType = null;
    protected String[] columnNames;
    protected Object defaultValue;
    protected StringBuffer errorMessages;
    protected int fieldNumber;
    protected Set<String> indexNames = new HashSet<String>();
    protected int[][] indices = new int[0][0];
    protected String name;
    protected Class<?> type;
    protected boolean orderedIndex = false;
    protected boolean uniqueIndex = false;
    protected boolean primaryKey = false;
    public AbstractDomainFieldHandlerImpl[] compositeDomainFieldHandlers = null;
    protected ObjectOperationHandler objectOperationHandlerDelegate;
    protected static ObjectOperationHandler objectOperationHandlerByte = new ObjectOperationHandlerByte(){

        @Override
        public String handler() {
            return "primitive byte";
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyByte = new ObjectOperationHandlerByte(){

        @Override
        public String handler() {
            return "primitive key byte";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.equalByte(fmd.storeColumn, handler.getByte(fmd.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addByteKey(fmd.storeColumn, keyValueHandler.getByte(fmd.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectByte = new ObjectOperationHandlerObjectByte(){

        @Override
        public String handler() {
            return "object Byte";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setByte(fmd.storeColumn, handler.getObjectByte(fmd.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBoolean = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setBoolean(fmd.fieldNumber, false);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Boolean.FALSE : Boolean.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setBoolean(fmd.storeColumn, (Boolean)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.setBoolean(fmd.storeColumn, handler.getBoolean(fmd.fieldNumber));
        }

        @Override
        public String handler() {
            return "setBoolean";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setBoolean(fmd.fieldNumber, rs.getBoolean(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpBoolean(condition, fmd.storeColumn, (Boolean)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalBoolean(fmd.storeColumn, (Boolean)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBoolean(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getBoolean(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setBoolean(fmd.fieldNumber, (Boolean)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectBoolean = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setBoolean(fmd.fieldNumber, false);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Boolean.FALSE : Boolean.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setBoolean(fmd.storeColumn, (Boolean)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setBoolean(fmd.storeColumn, handler.getBoolean(fmd.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "setObjectBoolean";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setObjectBoolean(fmd.fieldNumber, rs.getObjectBoolean(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpBoolean(condition, fmd.storeColumn, (Boolean)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalBoolean(fmd.storeColumn, (Boolean)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBoolean(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectBoolean(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectBoolean(fmd.fieldNumber, (Boolean)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBytes = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return new byte[0];
            }
            throw new UnsupportedOperationException(local.message("ERR_Convert_String_To_Value", (Object)columnDefaultValue, (Object)"byte[]"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (value == null) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setBytes(fmd.storeColumn, (byte[])value);
            }
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            byte[] value = handler.getBytes(fmd.fieldNumber);
            if (value == null) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setBytes(fmd.storeColumn, value);
            }
        }

        @Override
        public String handler() {
            return "setBytes";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setBytes(fmd.fieldNumber, rs.getBytes(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundBytes(fmd.storeColumn, type, (byte[])value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpBytes(condition, fmd.storeColumn, (byte[])value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setBytes.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalBytes(fmd.storeColumn, (byte[])value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBytes(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getBytes(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setBytes(fmd.fieldNumber, (byte[])value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyBytes = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return emptyByteArray;
            }
            throw new UnsupportedOperationException(local.message("ERR_Convert_String_To_Value", (Object)columnDefaultValue, (Object)"byte[]"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalBytes(fmd.storeColumn, (byte[])value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            byte[] value = handler.getBytes(fmd.fieldNumber);
            op.equalBytes(fmd.storeColumn, value);
        }

        @Override
        public String handler() {
            return "setKeyBytes";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setBytes(fmd.fieldNumber, rs.getBytes(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundBytes(fmd.storeColumn, type, (byte[])value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpBytes(condition, fmd.storeColumn, (byte[])value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setBytes.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalBytes(fmd.storeColumn, (byte[])value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addBytesKey(fmd.storeColumn, keyValueHandler.getBytes(fmd.fieldNumber));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBytes(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getBytes(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setBytes(fmd.fieldNumber, (byte[])value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBytesLob = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getBlob(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return new byte[0];
            }
            throw new UnsupportedOperationException(local.message("ERR_Convert_String_To_Value", (Object)columnDefaultValue, (Object)"byte[]"));
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl fmd, final Object value, final Operation op) {
            Blob blob = op.getBlobHandle(fmd.storeColumn);
            if (value == null) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable callback = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = op.getBlobHandle(fmd.storeColumn);
                        byte[] data = (byte[])value;
                        int length = data.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set blob value for field " + fmd.name + " for column " + fmd.columnName + " wrote length " + length + AbstractDomainFieldHandlerImpl.formatBytes(16, data));
                        }
                        blob.writeData(data);
                    }
                };
                op.postExecuteCallback(callback);
            }
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl fmd, final ValueHandler handler, final Operation op) {
            Blob blob = op.getBlobHandle(fmd.storeColumn);
            if (handler.isNull(fmd.fieldNumber)) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable callback = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = op.getBlobHandle(fmd.storeColumn);
                        byte[] data = handler.getLobBytes(fmd.fieldNumber);
                        int length = data.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set blob value for field " + fmd.name + " for column " + fmd.columnName + " wrote length " + length + AbstractDomainFieldHandlerImpl.formatBytes(16, data));
                        }
                        blob.writeData(data);
                    }
                };
                op.postExecuteCallback(callback);
            }
        }

        @Override
        public String handler() {
            return "setBytesLob";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            Blob blob = rs.getBlob(fmd.storeColumn);
            int length = blob.getLength().intValue();
            byte[] data = new byte[length];
            blob.readData(data, length);
            if (logger.isDetailEnabled()) {
                logger.detail("ResultSet get blob value for field " + fmd.name + " for column " + fmd.columnName + " returned length " + length + AbstractDomainFieldHandlerImpl.formatBytes(16, data));
            }
            blob.close();
            handler.setLobBytes(fmd.fieldNumber, data);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBoolean(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getLobBytes(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setLobBytes(fmd.fieldNumber, (byte[])value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerStringLob = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getBlob(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return "";
            }
            return columnDefaultValue;
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl fmd, final Object value, final Operation op) {
            Blob blob = op.getBlobHandle(fmd.storeColumn);
            if (value == null) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable callback = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = op.getBlobHandle(fmd.storeColumn);
                        byte[] data = fmd.storeColumn.encode((String)value);
                        int length = data.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set text value for field " + fmd.name + " for column " + fmd.columnName + " wrote length " + length + AbstractDomainFieldHandlerImpl.formatBytes(16, data));
                        }
                        blob.writeData(data);
                    }
                };
                op.postExecuteCallback(callback);
            }
        }

        @Override
        public void operationSetValue(final AbstractDomainFieldHandlerImpl fmd, final ValueHandler handler, final Operation op) {
            Blob blob = op.getBlobHandle(fmd.storeColumn);
            if (handler.isNull(fmd.fieldNumber)) {
                blob.setNull();
            } else {
                blob.setValue(emptyByteArray);
                Runnable callback = new Runnable(){

                    @Override
                    public void run() {
                        Blob blob = op.getBlobHandle(fmd.storeColumn);
                        byte[] data = fmd.storeColumn.encode(handler.getLobString(fmd.fieldNumber));
                        int length = data.length;
                        if (logger.isDetailEnabled()) {
                            logger.detail("Value to operation set text value for field " + fmd.name + " for column " + fmd.columnName + " wrote length " + length + AbstractDomainFieldHandlerImpl.formatBytes(16, data));
                        }
                        blob.writeData(data);
                    }
                };
                op.postExecuteCallback(callback);
            }
        }

        @Override
        public String handler() {
            return "setStringLob";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            Blob blob = rs.getBlob(fmd.storeColumn);
            int length = blob.getLength().intValue();
            byte[] data = new byte[length];
            blob.readData(data, length);
            if (logger.isDetailEnabled()) {
                logger.detail("ResultSet get text value for field " + fmd.name + " for column " + fmd.columnName + " returned length " + length + AbstractDomainFieldHandlerImpl.formatBytes(16, data));
            }
            blob.close();
            try {
                handler.setLobString(fmd.fieldNumber, fmd.storeColumn.decode(data));
            }
            catch (ClusterJException ex) {
                System.out.println(ex.getMessage() + " length: " + data.length + " " + AbstractDomainFieldHandlerImpl.formatBytes(data.length, data));
                throw ex;
            }
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getString(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getLobString(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setLobString(fmd.fieldNumber, (String)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerDecimal = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? BigDecimal.ZERO : new BigDecimal(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setDecimal(fmd.storeColumn, (BigDecimal)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setDecimal(fmd.storeColumn, handler.getBigDecimal(fmd.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object BigDecimal";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setBigDecimal(fmd.fieldNumber, rs.getDecimal(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundDecimal(fmd.storeColumn, type, (BigDecimal)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpDecimal(condition, fmd.storeColumn, (BigDecimal)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setDecimal.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalDecimal(fmd.storeColumn, (BigDecimal)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBigDecimal(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getBigDecimal(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setBigDecimal(fmd.fieldNumber, (BigDecimal)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerBigInteger = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? BigInteger.ZERO : new BigInteger(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setBigInteger(fmd.storeColumn, (BigInteger)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setBigInteger(fmd.storeColumn, handler.getBigInteger(fmd.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object BigInteger";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setBigInteger(fmd.fieldNumber, rs.getBigInteger(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundBigInteger(fmd.storeColumn, type, (BigInteger)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpBigInteger(condition, fmd.storeColumn, (BigInteger)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setDecimal.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalBigInteger(fmd.storeColumn, (BigInteger)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getBigInteger(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getBigInteger(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setBigInteger(fmd.fieldNumber, (BigInteger)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerDouble = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setDouble(fmd.fieldNumber, 0.0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Double.valueOf("0") : Double.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setDouble(fmd.storeColumn, (Double)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.setDouble(fmd.storeColumn, handler.getDouble(fmd.fieldNumber));
        }

        @Override
        public String handler() {
            return "primitive double";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setDouble(fmd.fieldNumber, rs.getDouble(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundDouble(fmd.storeColumn, type, (Double)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpDouble(condition, fmd.storeColumn, (Double)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalDouble(fmd.storeColumn, (Double)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getDouble(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getDouble(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setDouble(fmd.fieldNumber, (Double)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerFloat = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setFloat(fmd.fieldNumber, 0.0f);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Float.valueOf("0") : Float.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setFloat(fmd.storeColumn, (Float)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.setFloat(fmd.storeColumn, Float.valueOf(handler.getFloat(fmd.fieldNumber)));
        }

        @Override
        public String handler() {
            return "primitive float";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setFloat(fmd.fieldNumber, rs.getFloat(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundFloat(fmd.storeColumn, type, (Float)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpFloat(condition, fmd.storeColumn, ((Float)value).floatValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalFloat(fmd.storeColumn, ((Float)value).floatValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getFloat(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return Float.valueOf(handler.getFloat(fmd.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setFloat(fmd.fieldNumber, ((Float)value).floatValue());
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerInt = new ObjectOperationHandlerInt(){

        @Override
        public String handler() {
            return "primitive int";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + fmd.columnName + " set to value " + handler.getInt(fmd.fieldNumber));
            }
            op.setInt(fmd.storeColumn, handler.getInt(fmd.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyInt = new ObjectOperationHandlerInt(){

        @Override
        public String handler() {
            return "primitive key int";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("Key field " + fmd.name + " set equal to value " + handler.getInt(fmd.getFieldNumber()));
            }
            op.equalInt(fmd.storeColumn, handler.getInt(fmd.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addIntKey(fmd.storeColumn, keyValueHandler.getInt(fmd.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaSqlDate = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return new Date(new java.util.Date().getTime());
            }
            return Date.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setLong(fmd.storeColumn, ((Date)value).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setLong(fmd.storeColumn, handler.getJavaSqlDate(fmd.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.sql.Date";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            try {
                handler.setJavaSqlDate(fmd.fieldNumber, new Date(rs.getLong(fmd.storeColumn)));
            }
            catch (Exception ex) {
                throw new ClusterJDatastoreException(local.message("ERR_Set_Value", (Object)fmd.objectOperationHandlerDelegate.handler()), ex);
            }
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.storeColumn, type, ((Date)value).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpLong(condition, fmd.storeColumn, ((Date)value).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalLong(fmd.storeColumn, ((Date)value).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getJavaSqlDate(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getJavaSqlDate(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setJavaSqlDate(fmd.fieldNumber, (Date)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaSqlTime = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return new Time(new java.util.Date().getTime());
            }
            return Time.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setLong(fmd.storeColumn, ((Time)value).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setLong(fmd.storeColumn, handler.getJavaSqlTime(fmd.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.sql.Time";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setJavaSqlTime(fmd.fieldNumber, new Time(rs.getLong(fmd.storeColumn)));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.storeColumn, type, ((Time)value).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpLong(condition, fmd.storeColumn, ((Time)value).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalLong(fmd.storeColumn, ((Time)value).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getJavaSqlTime(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getJavaSqlTime(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setJavaSqlTime(fmd.fieldNumber, (Time)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaSqlTimestamp = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return new Timestamp(new java.util.Date().getTime());
            }
            return Timestamp.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setLong(fmd.storeColumn, ((Timestamp)value).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setLong(fmd.storeColumn, handler.getJavaSqlTimestamp(fmd.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.sql.Timestamp";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setJavaSqlTimestamp(fmd.fieldNumber, new Timestamp(rs.getLong(fmd.storeColumn)));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.storeColumn, type, ((Timestamp)value).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpLong(condition, fmd.storeColumn, ((Timestamp)value).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalLong(fmd.storeColumn, ((Timestamp)value).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getJavaSqlTimestamp(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getJavaSqlTimestamp(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setJavaSqlTimestamp(fmd.fieldNumber, (Timestamp)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerJavaUtilDate = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            if (columnDefaultValue == null) {
                return new java.util.Date();
            }
            return AbstractDomainFieldHandlerImpl.parse(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setLong(fmd.storeColumn, ((java.util.Date)value).getTime());
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setLong(fmd.storeColumn, handler.getJavaUtilDate(fmd.fieldNumber).getTime());
            }
        }

        @Override
        public String handler() {
            return "object java.util.Date";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setJavaUtilDate(fmd.fieldNumber, new java.util.Date(rs.getLong(fmd.storeColumn)));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.storeColumn, type, ((java.util.Date)value).getTime());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpLong(condition, fmd.storeColumn, ((java.util.Date)value).getTime());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalLong(fmd.storeColumn, ((java.util.Date)value).getTime());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getJavaUtilDate(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getJavaUtilDate(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setJavaUtilDate(fmd.fieldNumber, (java.util.Date)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyString = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? "" : columnDefaultValue;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setString(fmd.storeColumn, (String)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.equalString(fmd.storeColumn, handler.getString(fmd.fieldNumber));
        }

        @Override
        public String handler() {
            return "key String";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setString(fmd.fieldNumber, rs.getString(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundString(fmd.storeColumn, type, (String)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpString(condition, fmd.storeColumn, (String)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setString.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalString(fmd.storeColumn, (String)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addStringKey(fmd.storeColumn, keyValueHandler.getString(fmd.fieldNumber));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getString(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getString(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setString(fmd.fieldNumber, (String)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerLong = new ObjectOperationHandlerLong(){

        @Override
        public String handler() {
            return "primitive long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + fmd.columnName + " set to value " + handler.getLong(fmd.fieldNumber));
            }
            op.setLong(fmd.storeColumn, handler.getLong(fmd.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyLong = new ObjectOperationHandlerLong(){

        @Override
        public String handler() {
            return "key primitive long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + fmd.columnName + " set to value " + handler.getLong(fmd.fieldNumber));
            }
            op.equalLong(fmd.storeColumn, handler.getLong(fmd.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addLongKey(fmd.storeColumn, keyValueHandler.getLong(fmd.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectDouble = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Double.valueOf("0") : Double.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setDouble(fmd.storeColumn, (Double)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setDouble(fmd.storeColumn, handler.getObjectDouble(fmd.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object Double";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setObjectDouble(fmd.fieldNumber, rs.getObjectDouble(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundDouble(fmd.storeColumn, type, (Double)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpDouble(condition, fmd.storeColumn, (Double)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalDouble(fmd.storeColumn, (Double)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getDouble(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectDouble(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectDouble(fmd.fieldNumber, (Double)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectFloat = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Float.valueOf("0") : Float.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setFloat(fmd.storeColumn, (Float)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setFloat(fmd.storeColumn, handler.getObjectFloat(fmd.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object Float";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setObjectFloat(fmd.fieldNumber, rs.getObjectFloat(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundFloat(fmd.storeColumn, type, (Float)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpFloat(condition, fmd.storeColumn, ((Float)value).floatValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalFloat(fmd.storeColumn, ((Float)value).floatValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getFloat(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectFloat(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectFloat(fmd.fieldNumber, (Float)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectInteger = new ObjectOperationHandlerInteger(){

        @Override
        public String handler() {
            return "object Integer";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setInt(fmd.storeColumn, handler.getObjectInt(fmd.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyObjectInteger = new ObjectOperationHandlerInteger(){

        @Override
        public String handler() {
            return "key object Integer";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.equalInt(fmd.storeColumn, handler.getObjectInt(fmd.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addIntKey(fmd.storeColumn, keyValueHandler.getObjectInt(fmd.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectLong = new ObjectOperationHandlerObjectLong(){

        @Override
        public String handler() {
            return "object Long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setLong(fmd.storeColumn, handler.getObjectLong(fmd.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyObjectLong = new ObjectOperationHandlerObjectLong(){

        @Override
        public String handler() {
            return "key object Long";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.equalLong(fmd.storeColumn, handler.getObjectLong(fmd.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addLongKey(fmd.storeColumn, keyValueHandler.getObjectLong(fmd.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerShort = new ObjectOperationHandlerShort(){

        @Override
        public String handler() {
            return "primitive short";
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerKeyShort = new ObjectOperationHandlerShort(){

        @Override
        public String handler() {
            return "primitive key short";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.equalShort(fmd.storeColumn, handler.getShort(fmd.fieldNumber));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            partitionKey.addShortKey(fmd.storeColumn, keyValueHandler.getShort(fmd.fieldNumber));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectShort = new ObjectOperationHandlerObjectShort(){

        @Override
        public String handler() {
            return "object Short";
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setShort(fmd.storeColumn, handler.getObjectShort(fmd.fieldNumber));
            }
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerShortYear = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (short)1900);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Short.valueOf((short)1900) : Short.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setByte(fmd.storeColumn, (byte)((Short)value - 1900));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            op.setByte(fmd.storeColumn, (byte)(handler.getShort(fmd.fieldNumber) - 1900));
        }

        @Override
        public String handler() {
            return "primitive short year";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (short)(rs.getByte(fmd.storeColumn) + 1900));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            try {
                op.setBoundByte(fmd.storeColumn, type, (byte)(((Number)value).shortValue() - 1900));
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            try {
                filter.cmpByte(condition, fmd.storeColumn, (byte)(((Number)value).shortValue() - 1900));
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalByte(fmd.storeColumn, (byte)(((Number)value).shortValue() - 1900));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getShort(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return (short)(handler.getByte(fmd.fieldNumber) + 1900);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setByte(fmd.fieldNumber, (byte)((Short)value - 1900));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerObjectShortYear = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (short)1900);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Short.valueOf((short)1900) : Short.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setByte(fmd.storeColumn, (byte)((Short)value - 1900));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setByte(fmd.storeColumn, (byte)(handler.getShort(fmd.fieldNumber) - 1900));
            }
        }

        @Override
        public String handler() {
            return "object short year";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (short)(rs.getByte(fmd.storeColumn) + 1900));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            try {
                op.setBoundByte(fmd.storeColumn, type, (byte)(((Number)value).shortValue() - 1900));
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            try {
                filter.cmpByte(condition, fmd.storeColumn, (byte)(((Number)value).shortValue() - 1900));
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalByte(fmd.storeColumn, (byte)(((Number)value).shortValue() - 1900));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getShort(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            Byte value = handler.getObjectByte(fmd.fieldNumber);
            return value == null ? null : Short.valueOf((short)(value + 1900));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            if (value == null) {
                handler.setObjectByte(fmd.fieldNumber, null);
            } else {
                handler.setByte(fmd.fieldNumber, (byte)((Short)value - 1900));
            }
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerString = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? "" : columnDefaultValue;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (value == null) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setString(fmd.storeColumn, (String)value);
            }
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (handler.isNull(fmd.fieldNumber)) {
                op.setNull(fmd.storeColumn);
            } else {
                op.setString(fmd.storeColumn, handler.getString(fmd.fieldNumber));
            }
        }

        @Override
        public String handler() {
            return "object String";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            if (logger.isDetailEnabled()) {
                logger.detail("field " + fmd.name + " set to value " + rs.getString(fmd.storeColumn));
            }
            handler.setString(fmd.fieldNumber, rs.getString(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundString(fmd.storeColumn, type, (String)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpString(condition, fmd.storeColumn, (String)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalString(fmd.storeColumn, (String)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getString(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getString(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setString(fmd.fieldNumber, (String)value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerUnsupportedType = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return null;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public String handler() {
            return "unsupported Type";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return false;
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            throw new ClusterJUserException(local.message("ERR_Unsupported_Field_Type", (Object)fmd.getTypeName(), (Object)fmd.getName()));
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerVirtualType = new ObjectOperationHandler(){

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
        }

        @Override
        public String handler() {
            return "Virtual Type (field with no columns)";
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentByte = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive byte";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setByte(fmd.fieldNumber, (byte)0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getByte(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setByte(fmd.fieldNumber, (Byte)value);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return (byte)0;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentDouble = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive double";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setDouble(fmd.fieldNumber, 0.0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getDouble(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setDouble(fmd.fieldNumber, (Double)value);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return 0.0;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentFloat = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive float";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setFloat(fmd.fieldNumber, 0.0f);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return Float.valueOf(handler.getFloat(fmd.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setFloat(fmd.fieldNumber, ((Float)value).floatValue());
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return Float.valueOf(0.0f);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentInt = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive int";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setInt(fmd.fieldNumber, 0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getInt(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setInt(fmd.fieldNumber, (Integer)value);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return 0;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentLong = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive long";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setLong(fmd.fieldNumber, 0L);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getLong(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setLong(fmd.fieldNumber, (Long)value);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return 0L;
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentObject = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent Object";
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.get(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObject(fmd.fieldNumber, value);
        }
    };
    protected static ObjectOperationHandler objectOperationHandlerNotPersistentShort = new ObjectOperationHandlerNotPersistent(){

        @Override
        public String handler() {
            return "not persistent primitive short";
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (short)0);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getShort(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (Short)value);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return (short)0;
        }
    };

    protected void error(String message) {
        if (this.errorMessages == null) {
            this.errorMessages = new StringBuffer(local.message("ERR_Field_Not_Valid", (Object)this.domainTypeHandler.getName(), (Object)this.name));
        }
        this.errorMessages.append(message);
        this.errorMessages.append('\n');
    }

    @Override
    public void filterCompareValue(Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
        if (value == null) {
            if (ScanFilter.BinaryCondition.COND_EQ.equals((Object)condition)) {
                filter.isNull(this.storeColumn);
                return;
            }
            throw new ClusterJUserException(local.message("ERR_Null_Values_Can_Only_Be_Filtered_Equal", new Object[]{this.domainTypeHandler.getName(), this.name, condition}));
        }
        try {
            this.objectOperationHandlerDelegate.filterCompareValue(this, value, condition, filter);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Filter_Value", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), value), ex);
        }
    }

    @Override
    public void filterIsNull(ScanFilter filter) {
        filter.isNull(this.storeColumn);
    }

    @Override
    public void filterIsNotNull(ScanFilter filter) {
        filter.isNotNull(this.storeColumn);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getFieldNumber() {
        return this.fieldNumber;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type == null ? "unknown" : this.printableName(this.type);
    }

    protected String printableName(Class<?> cls) {
        if (cls.isArray()) {
            return this.printableName(cls.getComponentType()) + "[] ";
        }
        return cls.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean includedInIndex(String index) {
        return this.indexNames.contains(index);
    }

    public boolean isPrimitive() {
        return this.objectOperationHandlerDelegate.isPrimitive();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Column getStoreColumn() {
        return this.storeColumn;
    }

    @Override
    public void markEqualBounds(CandidateIndexImpl[] candidateIndexImpls, PredicateImpl predicate) {
        for (int[] indexBounds : this.indices) {
            candidateIndexImpls[indexBounds[0]].markEqualBound(indexBounds[1], predicate);
        }
    }

    @Override
    public void markInBounds(CandidateIndexImpl[] candidateIndexImpls, InPredicateImpl predicate) {
        for (int[] indexBounds : this.indices) {
            candidateIndexImpls[indexBounds[0]].markInBound(indexBounds[1], predicate);
        }
    }

    @Override
    public void markLowerBounds(CandidateIndexImpl[] candidateIndexImpls, PredicateImpl predicate, boolean strict) {
        for (int[] indexBounds : this.indices) {
            candidateIndexImpls[indexBounds[0]].markLowerBound(indexBounds[1], predicate, strict);
        }
    }

    @Override
    public void markUpperBounds(CandidateIndexImpl[] candidateIndexImpls, PredicateImpl predicate, boolean strict) {
        for (int[] indexBounds : this.indices) {
            candidateIndexImpls[indexBounds[0]].markUpperBound(indexBounds[1], predicate, strict);
        }
    }

    @Override
    public Object getValue(QueryExecutionContext context, String index) {
        return this.objectOperationHandlerDelegate.getValue(context, index);
    }

    void objectSetDefaultValue(ValueHandler handler) {
        this.objectOperationHandlerDelegate.objectInitializeJavaDefaultValue(this, handler);
    }

    Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void objectSetKeyValue(Object key, ValueHandler handler) {
        if (logger.isDetailEnabled()) {
            logger.detail("Setting value " + key + ".");
        }
        this.objectOperationHandlerDelegate.objectSetValue(this, key, handler);
    }

    @Override
    public void objectSetValue(ResultData rs, ValueHandler handler) {
        try {
            this.objectOperationHandlerDelegate.objectSetValue(this, rs, handler);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectSetValue"), ex);
        }
    }

    @Override
    public void objectSetValue(Object value, ValueHandler handler) {
        try {
            this.objectOperationHandlerDelegate.objectSetValue(this, value, handler);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectSetValue"), ex);
        }
    }

    @Override
    public Object objectGetValue(ValueHandler handler) {
        try {
            return this.objectOperationHandlerDelegate.objectGetValue(this, handler);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectGetValue"), ex);
        }
    }

    @Override
    public void objectSetValueExceptIndex(ResultData rs, ValueHandler handler, String indexName) {
        try {
            if (!this.includedInIndex(indexName)) {
                this.objectOperationHandlerDelegate.objectSetValue(this, rs, handler);
            }
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "objectSetValueExcept"), ex);
        }
    }

    @Override
    public void objectSetValueFor(Object value, Object row, String indexName) {
        if (this.includedInIndex(indexName)) {
            ValueHandler handler = (ValueHandler)Proxy.getInvocationHandler(row);
            handler.setObject(this.fieldNumber, value);
        }
    }

    @Override
    public void operationEqual(Object value, Operation op) {
        try {
            this.objectOperationHandlerDelegate.operationEqual(this, value, op);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationEqual"), ex);
        }
    }

    @Override
    public void operationEqualForIndex(Object parameterValue, Operation op, String indexName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void operationGetValue(Operation op) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column " + this.columnName + ".");
        }
        try {
            this.objectOperationHandlerDelegate.operationGetValue(this, op);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationGetValue"), ex);
        }
    }

    @Override
    public void operationSetBounds(Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " type: " + (Object)((Object)type) + " value: " + value);
        }
        try {
            this.objectOperationHandlerDelegate.operationSetBounds(this, value, type, op);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetBounds"), ex);
        }
    }

    @Override
    public void operationSetModifiedValue(ValueHandler handler, Operation op) {
        if (handler.isModified(this.fieldNumber)) {
            this.operationSetValue(handler, op);
        }
    }

    @Override
    public void operationSetValue(ValueHandler handler, Operation op) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " field: " + this.name + " type: " + this.type + " delegate " + this.objectOperationHandlerDelegate.handler());
        }
        try {
            this.objectOperationHandlerDelegate.operationSetValue(this, handler, op);
        }
        catch (ClusterJDatastoreException ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetValue"), ex);
        }
    }

    public void operationSetValue(Object value, Operation op) {
        if (logger.isDetailEnabled()) {
            logger.detail("Column: " + this.columnName + " field: " + this.name + " type: " + this.type + " delegate " + this.objectOperationHandlerDelegate.handler());
        }
        try {
            this.objectOperationHandlerDelegate.operationSetValue(this, value, op);
        }
        catch (ClusterJDatastoreException ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetValue"), ex);
        }
    }

    protected void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
        try {
            this.objectOperationHandlerDelegate.operationSetValue(fmd, value, op);
        }
        catch (Exception ex) {
            throw new ClusterJDatastoreException(local.message("ERR_Value_Delegate", this.name, this.columnName, this.objectOperationHandlerDelegate.handler(), "operationSetValue"), ex);
        }
    }

    @Override
    public void partitionKeySetPart(PartitionKey result, ValueHandler handler) {
        try {
            this.objectOperationHandlerDelegate.partitionKeySetPart(this, result, handler);
        }
        catch (NullPointerException npe) {
            throw new ClusterJUserException(local.message("ERR_Key_Must_Not_Be_Null", (Object)this.domainTypeHandler.getName(), (Object)this.getName()), npe);
        }
    }

    protected static String formatBytes(int length, byte[] data) {
        int bytesToFormat = Math.min(length, data.length);
        StringBuffer buffer = new StringBuffer(":");
        for (int i = 0; i < bytesToFormat; ++i) {
            buffer.append("[");
            buffer.append(data[i]);
            buffer.append("]");
        }
        if (bytesToFormat < data.length) {
            buffer.append("...");
        }
        return buffer.toString();
    }

    protected static java.util.Date parse(String dateString) {
        try {
            return new SimpleDateFormat().parse(dateString);
        }
        catch (ParseException ex) {
            throw new ClusterJUserException(local.message("ERR_Parse_Exception", (Object)dateString));
        }
    }

    protected String printIndices() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("indices[");
        buffer.append(this.indices.length);
        buffer.append("][]\n");
        for (int[] row : this.indices) {
            buffer.append(" row size ");
            buffer.append(row == null ? "null" : Integer.valueOf(row.length));
            buffer.append(": ");
            buffer.append(row == null ? "" : Integer.valueOf(row[0]));
            buffer.append(" ");
            buffer.append(row == null ? "" : Integer.valueOf(row[1]));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected void reportErrors() {
        if (this.errorMessages != null) {
            this.domainTypeHandler.setUnsupported(this.errorMessages.toString());
        }
    }

    public String toString() {
        return this.name;
    }

    public void validateIndexType(String indexName, boolean hash) {
        if (this.objectOperationHandlerDelegate == null || !this.objectOperationHandlerDelegate.isValidIndexType(this, hash)) {
            this.error(local.message("ERR_Invalid_Index_For_Type", this.domainTypeHandler.getName(), this.name, this.columnName, indexName, hash ? "hash" : "btree"));
        }
    }

    protected void initializeColumnMetadata(Column storeColumn) {
        this.columnName = storeColumn.getName();
        this.storeColumnType = storeColumn.getType();
        this.charsetName = storeColumn.getCharsetName();
        this.primaryKey = storeColumn.isPrimaryKey();
        this.partitionKey = storeColumn.isPartitionKey();
        this.precision = storeColumn.getPrecision();
        this.scale = storeColumn.getScale();
        this.maximumLength = storeColumn.getLength();
        this.nullable = storeColumn.getNullable();
    }

    @Override
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public int maximumLength() {
        return this.maximumLength;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int number() {
        return this.fieldNumber;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public ColumnType columnType() {
        return this.storeColumnType;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public Class<?> javaType() {
        return this.type;
    }

    @Override
    public String charsetName() {
        return this.charsetName;
    }

    @Override
    public boolean isLob() {
        throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"isLob()", (Object)"AbstractDomainFieldHandlerImpl"));
    }

    @Override
    public boolean isPersistent() {
        throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"isPersistent()", (Object)"AbstractDomainFieldHandlerImpl"));
    }

    protected static abstract class ObjectOperationHandlerNotPersistent
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerNotPersistent() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return null;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }

        @Override
        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl fmd, PartitionKey partitionKey, ValueHandler keyValueHandler) {
            throw new ClusterJFatalInternalException(local.message("ERR_Operation_Not_Supported", (Object)"partitionKeySetPart", (Object)"non-key fields"));
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
        }
    }

    protected static abstract class ObjectOperationHandlerObjectShort
    extends ObjectOperationHandlerShort {
        protected ObjectOperationHandlerObjectShort() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Short.valueOf((short)0) : Short.valueOf(columnDefaultValue);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectShort(fmd.fieldNumber, value != null ? Short.valueOf(((Number)value).shortValue()) : null);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectShort(fmd.fieldNumber);
        }
    }

    protected static abstract class ObjectOperationHandlerShort
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerShort() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, (short)0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Short.valueOf((short)0) : Short.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setShort(fmd.storeColumn, (Short)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + fmd.columnName + " set to value " + handler.getShort(fmd.fieldNumber));
            }
            op.setShort(fmd.storeColumn, handler.getShort(fmd.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, rs.getShort(fmd.storeColumn));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setShort(fmd.fieldNumber, ((Number)value).shortValue());
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            try {
                op.setBoundShort(fmd.storeColumn, type, ((Number)value).shortValue());
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            try {
                filter.cmpShort(condition, fmd.storeColumn, ((Number)value).shortValue());
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalShort(fmd.storeColumn, ((Number)value).shortValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getShort(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getShort(fmd.fieldNumber);
        }
    }

    public static abstract class ObjectOperationHandlerObjectLong
    implements ObjectOperationHandler {
        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Long.valueOf(0L) : Long.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setLong(fmd.storeColumn, ((Number)value).longValue());
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setObjectLong(fmd.fieldNumber, rs.getObjectLong(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.storeColumn, type, ((Number)value).longValue());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpLong(condition, fmd.storeColumn, ((Number)value).longValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setObjectLong.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalLong(fmd.storeColumn, ((Number)value).longValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getLong(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectLong(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectLong(fmd.fieldNumber, (Long)value);
        }
    }

    protected static abstract class ObjectOperationHandlerInteger
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerInteger() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Integer.valueOf(0) : Integer.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setInt(fmd.storeColumn, (Integer)value);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setObjectInt(fmd.fieldNumber, rs.getObjectInteger(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundInt(fmd.storeColumn, type, (Integer)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpInt(condition, fmd.storeColumn, (Integer)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setObjectInteger.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalInt(fmd.storeColumn, (Integer)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getInt(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectInt(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectInt(fmd.fieldNumber, (Integer)value);
        }
    }

    public static abstract class ObjectOperationHandlerLong
    implements ObjectOperationHandler {
        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setLong(fmd.fieldNumber, 0L);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Long.valueOf(0L) : Long.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setLong(fmd.storeColumn, ((Number)value).longValue());
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setLong(fmd.fieldNumber, rs.getLong(fmd.storeColumn));
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundLong(fmd.storeColumn, type, ((Number)value).longValue());
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpLong(condition, fmd.storeColumn, ((Number)value).longValue());
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setLong.setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalLong(fmd.storeColumn, ((Number)value).longValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getLong(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getLong(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setLong(fmd.fieldNumber, (Long)value);
        }
    }

    protected static abstract class ObjectOperationHandlerInt
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerInt() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setInt(fmd.fieldNumber, 0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            Integer result = columnDefaultValue == null ? Integer.valueOf(0) : Integer.valueOf(columnDefaultValue);
            return result;
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setInt(fmd.storeColumn, (Integer)value);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            int value = rs.getInt(fmd.storeColumn);
            if (logger.isDetailEnabled()) {
                logger.detail("Field " + fmd.name + " from column " + fmd.columnName + " set to value " + value);
            }
            handler.setInt(fmd.fieldNumber, value);
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            op.setBoundInt(fmd.storeColumn, type, (Integer)value);
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            filter.cmpInt(condition, fmd.storeColumn, (Integer)value);
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("setEqual " + fmd.columnName + " to value " + value);
            }
            op.equalInt(fmd.storeColumn, (Integer)value);
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getInt(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getInt(fmd.fieldNumber);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setInt(fmd.fieldNumber, (Integer)value);
        }
    }

    protected static abstract class ObjectOperationHandlerObjectByte
    extends ObjectOperationHandlerByte {
        protected ObjectOperationHandlerObjectByte() {
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Byte.valueOf((byte)0) : Byte.valueOf(columnDefaultValue);
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setObjectByte(fmd.fieldNumber, value != null ? Byte.valueOf(((Number)value).byteValue()) : null);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getObjectByte(fmd.fieldNumber);
        }
    }

    protected static abstract class ObjectOperationHandlerByte
    implements ObjectOperationHandler {
        protected ObjectOperationHandlerByte() {
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            handler.setByte(fmd.fieldNumber, (byte)0);
        }

        @Override
        public void operationGetValue(AbstractDomainFieldHandlerImpl fmd, Operation op) {
            op.getValue(fmd.storeColumn);
        }

        @Override
        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl fmd, String columnDefaultValue) {
            return columnDefaultValue == null ? Byte.valueOf((byte)0) : Byte.valueOf(columnDefaultValue);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.setByte(fmd.storeColumn, (Byte)value);
        }

        @Override
        public void operationSetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler, Operation op) {
            if (logger.isDetailEnabled()) {
                logger.detail("Column " + fmd.columnName + " set to value " + handler.getByte(fmd.fieldNumber));
            }
            op.setByte(fmd.storeColumn, handler.getByte(fmd.fieldNumber));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, ResultData rs, ValueHandler handler) {
            handler.setByte(fmd.fieldNumber, rs.getByte(fmd.storeColumn));
        }

        @Override
        public void objectSetValue(AbstractDomainFieldHandlerImpl fmd, Object value, ValueHandler handler) {
            handler.setByte(fmd.fieldNumber, ((Number)value).byteValue());
        }

        @Override
        public void operationSetBounds(AbstractDomainFieldHandlerImpl fmd, Object value, IndexScanOperation.BoundType type, IndexScanOperation op) {
            try {
                op.setBoundByte(fmd.storeColumn, type, ((Number)value).byteValue());
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void filterCompareValue(AbstractDomainFieldHandlerImpl fmd, Object value, ScanFilter.BinaryCondition condition, ScanFilter filter) {
            try {
                filter.cmpByte(condition, fmd.storeColumn, ((Number)value).byteValue());
            }
            catch (ClassCastException ex) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Type", (Object)"Number", (Object)value.getClass().getName()));
            }
        }

        @Override
        public void operationEqual(AbstractDomainFieldHandlerImpl fmd, Object value, Operation op) {
            op.equalByte(fmd.storeColumn, ((Number)value).byteValue());
        }

        @Override
        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl fmd, boolean hashNotOrdered) {
            return true;
        }

        @Override
        public Object getValue(QueryExecutionContext context, String index) {
            return context.getByte(index);
        }

        @Override
        public Object objectGetValue(AbstractDomainFieldHandlerImpl fmd, ValueHandler handler) {
            return handler.getByte(fmd.fieldNumber);
        }
    }

    protected static interface ObjectOperationHandler {
        public boolean isPrimitive();

        public Object objectGetValue(AbstractDomainFieldHandlerImpl var1, ValueHandler var2);

        public Object getValue(QueryExecutionContext var1, String var2);

        public void objectInitializeJavaDefaultValue(AbstractDomainFieldHandlerImpl var1, ValueHandler var2);

        public void operationGetValue(AbstractDomainFieldHandlerImpl var1, Operation var2);

        public Object getDefaultValueFor(AbstractDomainFieldHandlerImpl var1, String var2);

        public void operationSetValue(AbstractDomainFieldHandlerImpl var1, Object var2, Operation var3);

        public void operationSetValue(AbstractDomainFieldHandlerImpl var1, ValueHandler var2, Operation var3);

        public String handler();

        public void objectSetValue(AbstractDomainFieldHandlerImpl var1, ResultData var2, ValueHandler var3);

        public void objectSetValue(AbstractDomainFieldHandlerImpl var1, Object var2, ValueHandler var3);

        public void operationSetBounds(AbstractDomainFieldHandlerImpl var1, Object var2, IndexScanOperation.BoundType var3, IndexScanOperation var4);

        public void filterCompareValue(AbstractDomainFieldHandlerImpl var1, Object var2, ScanFilter.BinaryCondition var3, ScanFilter var4);

        public void operationEqual(AbstractDomainFieldHandlerImpl var1, Object var2, Operation var3);

        public boolean isValidIndexType(AbstractDomainFieldHandlerImpl var1, boolean var2);

        public void partitionKeySetPart(AbstractDomainFieldHandlerImpl var1, PartitionKey var2, ValueHandler var3);
    }
}

