/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreQuery;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.meta.ClassMetaData;

public class NdbOpenJPAStoreQuery
extends JDBCStoreQuery {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAStoreQuery.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAStoreQuery.class);

    NdbOpenJPAStoreQuery(NdbOpenJPAStoreManager storeManager, ExpressionParser expressionParser) {
        super((JDBCStore)storeManager, expressionParser);
    }

    protected Number executeDelete(StoreQuery.Executor ex, ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params) {
        NdbOpenJPAStoreManager store;
        NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler;
        if (logger.isDebugEnabled()) {
            logger.debug("NdbOpenJPAStoreQuery.executeDelete(Executor ex, ClassMetaData base, ClassMetaData[] metas, boolean subclasses, ExpressionFactory[] facts, QueryExpressions[] exps, Object[] params).\nClass: " + base.getTypeAlias() + " query expressions: " + exps + "[" + exps.length + "]" + " exps[0].filter: " + exps[0].filter);
        }
        if ((domainTypeHandler = (store = (NdbOpenJPAStoreManager)this.getStore()).getDomainTypeHandler((ClassMapping)base)).isSupportedType() && exps.length == 1 && exps[0].filter.getClass().getName().contains("EmptyExpression")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Empty Expression for delete will delete the entire extent.");
            }
            int count = store.deleteAll(domainTypeHandler);
            return count;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("NdbOpenJPAStoreQuery.executeDelete delegated to super.");
        }
        return super.executeDelete(ex, base, metas, subclasses, facts, exps, params);
    }
}

