/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.BlobTypes;
import testsuite.clusterj.model.IdBase;

public class QueryBlobIndexScanTest
extends AbstractQueryTest {
    protected BlobTypes[] instancesToUpdate = new BlobTypes[this.getNumberOfInstances()];

    @Override
    public Class<?> getInstanceType() {
        return BlobTypes.class;
    }

    @Override
    void createInstances(int number) {
        for (int i = 0; i < number; ++i) {
            BlobTypes b = (BlobTypes)this.session.newInstance(BlobTypes.class);
            b.setId(i);
            b.setBlobbytes(this.getByteArray(i));
            this.instances.add(b);
        }
    }

    public void test() {
        this.equalQuery("id", "PRIMARY", 5, 5);
        this.testUpdate(5);
        this.greaterEqualQuery("id", "PRIMARY", 7, 7, 8, 9);
        this.greaterThanQuery("id", "PRIMARY", 6, 7, 8, 9);
        this.testUpdate(7);
        this.lessEqualQuery("id", "PRIMARY", 4, 4, 3, 2, 1, 0);
        this.lessThanQuery("id", "PRIMARY", 4, 3, 2, 1, 0);
        this.betweenQuery("id", "PRIMARY", 2, 4, 2, 3, 4);
        this.greaterEqualAndLessEqualQuery("id", "PRIMARY", 2, 4, 2, 3, 4);
        this.greaterThanAndLessEqualQuery("id", "PRIMARY", 2, 4, 3, 4);
        this.greaterEqualAndLessThanQuery("id", "PRIMARY", 2, 4, 2, 3);
        this.greaterThanAndLessThanQuery("id", "PRIMARY", 2, 4, 3);
        this.testDelete(5);
        this.testDelete(8);
        this.failOnError();
    }

    protected byte[] getByteArray(int number) {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, (byte)number};
    }

    protected void testUpdate(int id) {
        try {
            BlobTypes before = this.instancesToUpdate[id];
            byte[] updateBytes = before.getBlobbytes();
            updateBytes[0] = -128;
            before.setBlobbytes(updateBytes);
            this.session.updatePersistent((Object)before);
            BlobTypes after = (BlobTypes)this.session.find(BlobTypes.class, (Object)id);
            String message = this.compareBytes(updateBytes, after.getBlobbytes());
            if (message != null) {
                this.error("Mismatch on update " + id + ": " + message);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void testDelete(int id) {
        BlobTypes before = this.instancesToUpdate[id];
        BlobTypes after = null;
        this.session.deletePersistent((Object)before);
        after = (BlobTypes)this.session.find(BlobTypes.class, (Object)id);
        if (after != null) {
            this.error("Failed to delete " + id + ".");
        }
    }

    @Override
    protected void printResultInstance(IdBase instance) {
        BlobTypes b = (BlobTypes)instance;
        int id = b.getId();
        this.instancesToUpdate[id] = b;
        String message = this.compareBytes(this.getByteArray(id), b.getBlobbytes());
        if (message != null) {
            this.error("Mismatch reading instance " + id + ": " + message);
        }
    }
}

