/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.CharsetSwedishUtf8;
import testsuite.clusterj.model.IdBase;

public class FixedLengthCharTest
extends AbstractClusterJModelTest {
    static AbstractClusterJModelTest.ColumnDescriptor utf_column = new AbstractClusterJModelTest.ColumnDescriptor("utfcolumn", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase instance, Object value) {
            ((CharsetSwedishUtf8)instance).setUtfColumn((String)value);
        }

        @Override
        public String getFieldValue(IdBase instance) {
            return ((CharsetSwedishUtf8)instance).getUtfColumn();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setString(j, (String)value);
        }

        @Override
        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            return rs.getString(j);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor swedish_column = new AbstractClusterJModelTest.ColumnDescriptor("swedishcolumn", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase instance, Object value) {
            ((CharsetSwedishUtf8)instance).setSwedishColumn((String)value);
        }

        @Override
        public String getFieldValue(IdBase instance) {
            return ((CharsetSwedishUtf8)instance).getSwedishColumn();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int j, Object value) throws SQLException {
            preparedStatement.setString(j, (String)value);
        }

        @Override
        public Object getResultSetValue(ResultSet rs, int j) throws SQLException {
            return rs.getString(j);
        }
    });
    protected static AbstractClusterJModelTest.ColumnDescriptor[] columnDescriptors = new AbstractClusterJModelTest.ColumnDescriptor[]{utf_column, swedish_column};

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(CharsetSwedishUtf8.class);
        try {
            this.tx.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addTearDownClasses(CharsetSwedishUtf8.class);
    }

    public void testUtf8() {
        this.writeRead(1, utf_column, "aaa");
        this.writeRead(2, utf_column, "aaaa");
        this.writeRead(3, utf_column, "aaaaaaaaaaaa");
        this.writeRead(4, utf_column, "\u20ac\u20ac\u20ac\u20ac");
        this.writeRead(5, utf_column, "aaaa  ", "aaaa");
        this.writeRead(6, utf_column, "\u20ac\u20ac\u20ac  ", "\u20ac\u20ac\u20ac");
        this.writeFail(20, utf_column, "aaaaaaaaaaaaa", ".*Data length 13 too long.*");
        this.failOnError();
    }

    public void testSwedish() {
        this.writeRead(7, swedish_column, "aaa");
        this.writeRead(8, swedish_column, "aaaa");
        this.writeRead(9, swedish_column, "aa  ", "aa");
        this.writeFail(21, swedish_column, "aaaaa", ".*Data length 5 too long..*");
        this.failOnError();
    }

    protected void writeRead(int id, AbstractClusterJModelTest.ColumnDescriptor columnDescriptor, String output, String expected) {
        CharsetSwedishUtf8 instance = (CharsetSwedishUtf8)this.session.newInstance(CharsetSwedishUtf8.class);
        instance.setId(id);
        columnDescriptor.setFieldValue(instance, output);
        this.session.currentTransaction().begin();
        this.session.persist((Object)instance);
        this.session.currentTransaction().commit();
        this.session.currentTransaction().begin();
        instance = (CharsetSwedishUtf8)this.session.find(CharsetSwedishUtf8.class, (Object)id);
        this.session.currentTransaction().commit();
        this.errorIfNotEqual("Failure on reading data from " + columnDescriptor.getColumnName(), expected, columnDescriptor.getFieldValue(instance));
    }

    protected void writeRead(int id, AbstractClusterJModelTest.ColumnDescriptor columnDescriptor, String output) {
        this.writeRead(id, columnDescriptor, output, output);
        this.queryAndVerifyResults(columnDescriptor.getColumnName() + " = " + output, columnDescriptors, columnDescriptor.getColumnName() + " = ?", new String[]{output}, id);
    }

    protected void writeFail(int id, AbstractClusterJModelTest.ColumnDescriptor columnDescriptor, String output, String exceptionPattern) {
        block2: {
            CharsetSwedishUtf8 instance = (CharsetSwedishUtf8)this.session.newInstance(CharsetSwedishUtf8.class);
            try {
                columnDescriptor.setFieldValue(instance, output);
            }
            catch (Exception ex) {
                if (ex.getMessage().matches(exceptionPattern)) break block2;
                this.error(ex.getMessage());
            }
        }
    }

    @Override
    protected AbstractClusterJModelTest.ColumnDescriptor[] getColumnDescriptors() {
        return columnDescriptors;
    }

    @Override
    protected String getTableName() {
        return "charsetswedishutf8";
    }
}

