/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.ConversationSummary;

public class Bug17200163Test
extends AbstractClusterJModelTest {
    protected int NUMBER_TO_INSERT = 10;
    protected List<ConversationSummary> instances = new ArrayList<ConversationSummary>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createInstances(this.NUMBER_TO_INSERT);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(ConversationSummary.class);
        this.tx.commit();
        this.addTearDownClasses(ConversationSummary.class);
    }

    public void test() {
        this.insert();
        this.testQuery(0L, 4L, 6L);
        this.failOnError();
    }

    protected void insert() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int count = 0;
        for (int i = 0; i < this.NUMBER_TO_INSERT; ++i) {
            this.session.makePersistent((Object)this.instances.get(i));
            ++count;
        }
        this.tx.commit();
    }

    protected void testQuery(long userId, long startDate, long endDate) {
        QueryBuilder builder = this.session.getQueryBuilder();
        QueryDomainType domain = builder.createQueryDefinition(ConversationSummary.class);
        Predicate compare = null;
        PredicateOperand column = domain.get("sourceUserId");
        PredicateOperand param = domain.param("filter_sourceUserId");
        compare = column.equal(param);
        PredicateOperand column2 = domain.get("updatedAt");
        PredicateOperand param2 = domain.param("filter_updatedAt1");
        compare = compare.and(column2.greaterEqual(param2));
        PredicateOperand column3 = domain.get("updatedAt");
        PredicateOperand param3 = domain.param("filter_updatedAt2");
        compare = compare.and(column3.lessEqual(param3));
        domain.where(compare);
        Query query = this.session.createQuery((QueryDefinition)domain);
        query.setParameter("filter_sourceUserId", (Object)userId);
        query.setParameter("filter_updatedAt1", (Object)startDate);
        query.setParameter("filter_updatedAt2", (Object)endDate);
        query.setLimits(0L, 2L);
        query.setOrdering(Query.Ordering.DESCENDING, new String[]{"updatedAt"});
        ArrayList<Long> expected = new ArrayList<Long>();
        expected.add(6L);
        expected.add(5L);
        ArrayList<Long> actual = new ArrayList<Long>();
        List results = query.getResultList();
        for (ConversationSummary result : results) {
            actual.add(result.getAnswererId());
        }
        this.errorIfNotEqual("Results of query with ordering and limits for ConversationSummary", expected, actual);
    }

    protected void createInstances(int number) {
        for (int i = 0; i < number; ++i) {
            ConversationSummary instance = (ConversationSummary)this.session.newInstance(ConversationSummary.class);
            instance.setSourceUserId(0L);
            instance.setAnswererId(i);
            instance.setDestUserId(i);
            instance.setLastMessageById(i);
            instance.setQueryHistoryId(i);
            instance.setText("Text " + i);
            instance.setUpdatedAt(i);
            instance.setViewed(0 == i % 2);
            this.instances.add(instance);
        }
    }
}

