/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.core.query.QueryExecutionContextImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfiguration;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainFieldHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAResult;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreQuery;
import com.mysql.clusterj.openjpa.NdbOpenJPAUtility;
import com.mysql.clusterj.query.QueryDomainType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryCacheStoreQuery;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.kernel.PreparedSQLStoreQuery;
import org.apache.openjpa.jdbc.kernel.SQLStoreQuery;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.util.OpenJPAId;

public class NdbOpenJPAStoreManager
extends JDBCStoreManager {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAStoreManager.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAStoreManager.class);
    private StoreContext storeContext;
    private NdbOpenJPAConfiguration ndbConfiguration;
    private SessionFactory sessionFactory;
    private SessionSPI session;
    private Transaction tx;
    private Dictionary dictionary;

    public void setContext(StoreContext ctx) {
        super.setContext(ctx);
        this.setContext(ctx, (NdbOpenJPAConfiguration)ctx.getConfiguration());
    }

    public void setContext(StoreContext ctx, NdbOpenJPAConfiguration conf) {
        this.storeContext = ctx;
        this.ndbConfiguration = conf;
        this.sessionFactory = conf.getSessionFactory();
        this.getSession();
    }

    protected NdbOpenJPADomainTypeHandlerImpl<?> getDomainTypeHandler(OpenJPAStateManager sm) {
        ClassMapping cmp = (ClassMapping)sm.getMetaData();
        return this.getDomainTypeHandler(cmp);
    }

    protected NdbOpenJPADomainTypeHandlerImpl<?> getDomainTypeHandler(ClassMapping cmp) {
        NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler = this.ndbConfiguration.getDomainTypeHandler(cmp, this.dictionary);
        return domainTypeHandler;
    }

    protected int deleteAll(DomainTypeHandler<?> base) {
        int result = this.session.deletePersistentAll(base);
        return result;
    }

    protected SessionSPI getSession() {
        if (this.session == null) {
            this.session = (SessionSPI)this.sessionFactory.getSession();
            this.dictionary = this.session.getDictionary();
        }
        return this.session;
    }

    public Object find(Object oid, ValueMapping vm, JDBCFetchConfiguration fetch) {
        ClassMapping cls;
        NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler;
        ValueHandler handler;
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.find(Object oid, ValueMapping vm, JDBCFetchConfiguration fetch) delegated to super with oid " + oid + ".");
        }
        if ((handler = (domainTypeHandler = this.getDomainTypeHandler(cls = vm.getDeclaredTypeMapping())).createKeyValueHandler(oid, null)) == null) {
            return null;
        }
        return super.find(oid, vm, fetch);
    }

    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) Id: " + sm.getId() + " requested fields: " + NdbOpenJPAUtility.printBitSet(sm, fields));
        }
        if (context != null && ((ConnectionInfo)context).result != null) {
            return super.load(sm, fields, fetch, lockLevel, context);
        }
        NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler = this.getDomainTypeHandler(sm);
        if (!this.isSupportedType(domainTypeHandler, "NdbOpenJPAStoreManager.load")) {
            return super.load(sm, fields, fetch, lockLevel, context);
        }
        try {
            return domainTypeHandler.load(sm, this, fields, (JDBCFetchConfiguration)fetch, context);
        }
        catch (SQLException sQLException) {
            logger.error("Fatal error from NdbOpenJPAStoreManager.load " + sQLException);
            return false;
        }
    }

    public Object load(ClassMapping mapping, JDBCFetchConfiguration fetch, BitSet exclude, Result result) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.load(ClassMapping mapping, JDBCFetchConfiguration fetch, BitSet exclude, Result result) for " + mapping.getDescribedType().getName() + " delegated to super.");
        }
        return super.load(mapping, fetch, exclude, result);
    }

    public Collection loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object context) {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object context) delegated to super.");
        }
        return super.loadAll(sms, state, load, fetch, context);
    }

    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object context) {
        NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler;
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object context)");
        }
        if (context != null) {
            ConnectionInfo info = (ConnectionInfo)context;
            ClassMapping mapping = info.mapping;
            Result result = info.result;
            logger.info("info mapping: " + mapping.getDescribedType().getName() + " result: " + result);
            try {
                return this.initializeState(sm, state, (JDBCFetchConfiguration)fetch, info);
            }
            catch (ClassNotFoundException e) {
                throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"), e);
            }
            catch (SQLException e) {
                throw new ClusterJDatastoreException(local.message("ERR_Datastore_Exception"), e);
            }
        }
        OpenJPAId id = (OpenJPAId)sm.getId();
        if (logger.isTraceEnabled()) {
            logger.trace("Id: " + id.getClass() + " " + id);
        }
        if (!this.isSupportedType(domainTypeHandler = this.getDomainTypeHandler(sm), "NdbOpenJPAStoreManager.initialize")) {
            boolean result = super.initialize(sm, state, fetch, context);
            if (logger.isDebugEnabled()) {
                logger.debug("NdbOpenJPAStoreManager.initialize delegated to super: returned " + result);
            }
            return result;
        }
        try {
            this.getSession();
            this.session.startAutoTransaction();
            ValueHandler keyValueHandler = domainTypeHandler.createKeyValueHandler(id.getIdObject(), null);
            ResultData resultData = this.session.selectUnique(domainTypeHandler, keyValueHandler, null);
            NdbOpenJPAResult result = new NdbOpenJPAResult(resultData, domainTypeHandler, null);
            if (result.next()) {
                domainTypeHandler.newInstance(sm);
                domainTypeHandler.load(sm, this, (JDBCFetchConfiguration)fetch, result);
            }
            if (logger.isDetailEnabled()) {
                logger.detail("After initializing PCState: " + sm.getPCState().getClass().getSimpleName() + " " + this.printLoaded(sm));
            }
            this.session.endAutoTransaction();
            return true;
        }
        catch (ClusterJException e) {
            this.session.failAutoTransaction();
            throw e;
        }
        catch (Exception e) {
            this.session.failAutoTransaction();
            throw new ClusterJFatalInternalException("Unexpected exception.", e);
        }
    }

    protected boolean initializeState(OpenJPAStateManager sm, PCState state, JDBCFetchConfiguration fetch, ConnectionInfo info) throws ClassNotFoundException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.initializeState(OpenJPAStateManager, PCState, JDBCFetchConfiguration, ConnectionInfo) delegated to super.");
        }
        return super.initializeState(sm, state, fetch, info);
    }

    public Collection<Exception> flush(Collection sms) {
        ArrayList<Exception> exceptions;
        Collection stateManagers = sms;
        StringBuffer buffer = null;
        if (logger.isTraceEnabled()) {
            buffer = new StringBuffer();
        }
        boolean allSupportedTypes = true;
        for (OpenJPAStateManager sm : stateManagers) {
            NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler = this.getDomainTypeHandler(sm);
            if (!domainTypeHandler.isSupportedType()) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Found unsupported class " + domainTypeHandler.getName());
                }
                if (this.ndbConfiguration.getFailOnJDBCPath()) {
                    throw new ClusterJFatalUserException(local.message("ERR_JDBC_Path", (Object)domainTypeHandler.getName()));
                }
                allSupportedTypes = false;
            }
            if (!logger.isTraceEnabled()) continue;
            buffer.append(this.printState(sm));
        }
        if (logger.isTraceEnabled()) {
            logger.trace(buffer.toString());
        }
        if (!allSupportedTypes) {
            exceptions = super.flush(sms);
            if (logger.isDetailEnabled()) {
                logger.detail("Found unsupported class(es); super resulted in exceptions: " + exceptions);
            }
            return exceptions;
        }
        this.getSession();
        exceptions = new ArrayList<Exception>();
        for (OpenJPAStateManager sm : stateManagers) {
            NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler = this.getDomainTypeHandler(sm);
            ValueHandler valueHandler = domainTypeHandler.getValueHandler(sm, this);
            PCState pcState = sm.getPCState();
            try {
                if (pcState == PCState.PNEW) {
                    this.session.insert(domainTypeHandler, valueHandler);
                    continue;
                }
                if (pcState == PCState.PDELETED) {
                    this.session.delete(domainTypeHandler, valueHandler);
                    continue;
                }
                if (pcState == PCState.PDIRTY) {
                    this.session.update(domainTypeHandler, valueHandler);
                    continue;
                }
                if (pcState == PCState.PNEWFLUSHEDDELETED) {
                    this.session.delete(domainTypeHandler, valueHandler);
                    continue;
                }
                if (pcState == PCState.PNEWFLUSHEDDELETEDFLUSHED) continue;
                throw new ClusterJUserException(local.message("ERR_Unsupported_Flush_Operation", (Object)pcState.toString()));
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Exception caught: " + ex.toString());
                }
                exceptions.add(ex);
            }
        }
        this.session.flush();
        return exceptions;
    }

    private boolean isSupportedType(NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler, String where) {
        boolean result = domainTypeHandler.isSupportedType();
        if (!result) {
            if (logger.isDebugEnabled()) {
                logger.debug(where + " found unsupported class " + domainTypeHandler.getName());
            }
            if (this.ndbConfiguration.getFailOnJDBCPath()) {
                throw new ClusterJFatalUserException(local.message("ERR_JDBC_Path", (Object)domainTypeHandler.getName()));
            }
        }
        return result;
    }

    public void beforeStateChange(OpenJPAStateManager sm, PCState fromState, PCState toState) {
        if (logger.isDetailEnabled()) {
            logger.detail(this.printState("from ", fromState) + this.printState(" to ", toState));
        }
        super.beforeStateChange(sm, fromState, toState);
    }

    public StoreQuery newQuery(String language) {
        ExpressionParser expressionParser = QueryLanguages.parserForLanguage((String)language);
        StoreQuery storeQuery = this.newStoreQuery(language, expressionParser);
        if (logger.isDetailEnabled()) {
            logger.detail("NdbOpenJPAStoreManager.newQuery language: " + language + " parser: " + expressionParser);
        }
        if (storeQuery == null || expressionParser == null) {
            return storeQuery;
        }
        QueryCache queryCache = this.storeContext.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        if (queryCache == null) {
            return storeQuery;
        }
        return new QueryCacheStoreQuery(storeQuery, queryCache);
    }

    private StoreQuery newStoreQuery(String language, ExpressionParser expressionParser) {
        if (expressionParser != null) {
            return new NdbOpenJPAStoreQuery(this, expressionParser);
        }
        if ("openjpa.SQL".equals(language)) {
            return new SQLStoreQuery((JDBCStore)this);
        }
        if ("openjpa.prepared.SQL".equals(language)) {
            return new PreparedSQLStoreQuery((JDBCStore)this);
        }
        return null;
    }

    public void beginOptimistic() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        super.beginOptimistic();
        try {
            this.getSession();
            this.tx = this.session.currentTransaction();
            if (this.tx.isActive()) {
                this.tx.commit();
            }
            this.tx.begin();
        }
        catch (Exception e) {
            logger.detail("NdbOpenJPAStoreManager.beginOptimistic():caught exception in session.currentTransaction.begin().");
            throw new ClusterJDatastoreException(local.message("ERR_Datastore_Exception"), e);
        }
    }

    public void begin() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        this.getSession();
        try {
            this.tx = this.session.currentTransaction();
            if (this.tx.isActive()) {
                this.tx.commit();
            }
            this.tx.begin();
        }
        catch (Exception e) {
            logger.detail("Caught exception in session.currentTransaction.commit()." + e.getMessage());
        }
        super.begin();
    }

    public void commit() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        try {
            this.session.commit();
        }
        catch (Exception ex) {
            logger.detail(" failed" + ex.toString());
            throw new ClusterJException(local.message("ERR_Commit_Failed", (Object)ex.toString()));
        }
        super.commit();
    }

    public void rollback() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        this.session.rollback();
        super.rollback();
    }

    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        if (this.session != null && !this.session.isClosed()) {
            if (this.session.currentTransaction().isActive()) {
                this.tx.commit();
            }
            this.session.close();
        }
    }

    protected String printState(OpenJPAStateManager sm) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("class: ");
        buffer.append(sm.getPersistenceCapable().getClass().getName());
        buffer.append(" objectId: ");
        buffer.append(sm.getObjectId());
        buffer.append(" PCState: ");
        buffer.append(sm.getPCState());
        buffer.append("\n");
        return buffer.toString();
    }

    protected String printState(String header, PCState state) {
        StringBuffer buffer = new StringBuffer(header);
        buffer.append(state.getClass().getSimpleName());
        return buffer.toString();
    }

    protected String printLoaded(OpenJPAStateManager sm) {
        BitSet loaded = sm.getLoaded();
        return "Loaded: " + NdbOpenJPAUtility.printBitSet(sm, loaded);
    }

    protected String printIsActive(Transaction tx) {
        return tx == null ? " is null." : (tx.isActive() ? " is active." : " is not active.");
    }

    public <T> QueryDomainType<T> createQueryDomainType(Class<T> type) {
        return this.session.getQueryBuilder().createQueryDefinition(type);
    }

    public NdbOpenJPAResult executeQuery(DomainTypeHandler<?> domainTypeHandler, QueryDomainType<?> queryDomainType, Map<String, Object> parameterMap) {
        QueryExecutionContextImpl context = new QueryExecutionContextImpl(this.session, parameterMap);
        ResultData resultData = context.getResultData(queryDomainType);
        NdbOpenJPAResult result = new NdbOpenJPAResult(resultData, domainTypeHandler, null);
        return result;
    }

    public NdbOpenJPAResult lookup(OpenJPAStateManager sm, NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler, List<NdbOpenJPADomainFieldHandlerImpl> fieldHandlers) {
        Table storeTable = domainTypeHandler.getStoreTable();
        this.session.startAutoTransaction();
        try {
            Operation op = this.session.getSelectOperation(storeTable);
            op.beginDefinition();
            int[] keyFields = domainTypeHandler.getKeyFieldNumbers();
            BitSet fieldsInResult = new BitSet();
            for (int i : keyFields) {
                fieldsInResult.set(i);
            }
            ValueHandler handler = domainTypeHandler.getValueHandler(sm, this);
            domainTypeHandler.operationSetKeys(handler, op);
            domainTypeHandler.operationGetKeys(op);
            for (NdbOpenJPADomainFieldHandlerImpl fieldHandler : fieldHandlers) {
                fieldHandler.operationGetValue(op);
                fieldsInResult.set(fieldHandler.getFieldNumber());
            }
            op.endDefinition();
            ResultData resultData = op.resultData();
            NdbOpenJPAResult result = new NdbOpenJPAResult(resultData, domainTypeHandler, fieldsInResult);
            this.session.endAutoTransaction();
            return result;
        }
        catch (RuntimeException ex) {
            this.session.failAutoTransaction();
            throw ex;
        }
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }
}

