/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.BlobImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbRecAttr;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

class ResultDataImpl
implements ResultData {
    static final I18NHelper local = I18NHelper.getInstance(ResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ResultDataImpl.class);
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    private NdbOperation ndbOperation = null;
    private NdbRecAttr[] ndbRecAttrs = null;
    private boolean nextDone;
    private ByteBuffer byteBuffer = null;
    private int[] offsets = null;
    private int[] lengths = null;
    private final Column[] storeColumns;
    private DbImpl.BufferManager bufferManager;

    public ResultDataImpl(NdbOperation ndbOperation, List<Column> storeColumns, int maximumColumnId, int bufferSize, int[] offsets, int[] lengths, DbImpl.BufferManager bufferManager, boolean allocateNew) {
        this.ndbOperation = ndbOperation;
        this.bufferManager = bufferManager;
        this.storeColumns = storeColumns.toArray(new Column[storeColumns.size()]);
        this.offsets = offsets;
        this.lengths = lengths;
        this.byteBuffer = allocateNew ? ByteBuffer.allocateDirect(bufferSize) : bufferManager.getResultDataBuffer(bufferSize);
        this.byteBuffer.order(ByteOrder.nativeOrder());
        this.ndbRecAttrs = new NdbRecAttr[maximumColumnId + 1];
        for (Column storeColumn : storeColumns) {
            NdbRecAttr ndbRecAttr = null;
            int columnId = storeColumn.getColumnId();
            this.byteBuffer.position(offsets[columnId]);
            ndbRecAttr = lengths[columnId] == 0 ? ndbOperation.getValue(columnId, null) : ndbOperation.getValue(columnId, this.byteBuffer);
            this.handleError(ndbRecAttr, ndbOperation);
            this.ndbRecAttrs[columnId] = ndbRecAttr;
        }
    }

    @Override
    public boolean next() {
        NdbErrorConst error = this.ndbOperation.getNdbError();
        int errorCode = error.code();
        if (errorCode != 0) {
            this.setNoResult();
        }
        if (this.nextDone) {
            return false;
        }
        this.nextDone = true;
        return true;
    }

    @Override
    public Blob getBlob(int column) {
        return this.getBlob(this.storeColumns[column]);
    }

    @Override
    public Blob getBlob(Column storeColumn) {
        NdbBlob ndbBlob = this.ndbOperation.getBlobHandle(storeColumn.getColumnId());
        this.handleError(ndbBlob, this.ndbOperation);
        return new BlobImpl(ndbBlob);
    }

    @Override
    public boolean getBoolean(int column) {
        return this.getBoolean(this.storeColumns[column]);
    }

    @Override
    public boolean getBoolean(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return Utility.getBoolean(storeColumn, ndbRecAttr);
    }

    @Override
    public boolean[] getBooleans(int column) {
        return this.getBooleans(this.storeColumns[column]);
    }

    @Override
    public boolean[] getBooleans(Column storeColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Not_Implemented"));
    }

    @Override
    public byte getByte(int column) {
        return this.getByte(this.storeColumns[column]);
    }

    @Override
    public byte getByte(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return Utility.getByte(storeColumn, ndbRecAttr);
    }

    @Override
    public short getShort(int column) {
        return this.getShort(this.storeColumns[column]);
    }

    @Override
    public short getShort(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return Utility.getShort(storeColumn, ndbRecAttr);
    }

    @Override
    public int getInt(int column) {
        return this.getInt(this.storeColumns[column]);
    }

    @Override
    public int getInt(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return Utility.getInt(storeColumn, ndbRecAttr);
    }

    @Override
    public long getLong(int column) {
        return this.getLong(this.storeColumns[column]);
    }

    @Override
    public long getLong(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return Utility.getLong(storeColumn, ndbRecAttr.int64_value());
    }

    @Override
    public float getFloat(int column) {
        return this.getFloat(this.storeColumns[column]);
    }

    @Override
    public float getFloat(Column storeColumn) {
        int index = storeColumn.getColumnId();
        float result = this.ndbRecAttrs[index].float_value();
        return result;
    }

    @Override
    public double getDouble(int column) {
        return this.getDouble(this.storeColumns[column]);
    }

    @Override
    public double getDouble(Column storeColumn) {
        int index = storeColumn.getColumnId();
        double result = this.ndbRecAttrs[index].double_value();
        return result;
    }

    @Override
    public String getString(int column) {
        return this.getString(this.storeColumns[column]);
    }

    @Override
    public String getString(Column storeColumn) {
        int actualLength;
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        if (ndbRecAttr.isNULL() == 1) {
            return null;
        }
        int prefixLength = storeColumn.getPrefixLength();
        int offset = this.offsets[index];
        this.byteBuffer.limit(this.byteBuffer.capacity());
        switch (prefixLength) {
            case 0: {
                actualLength = this.lengths[index];
                break;
            }
            case 1: {
                actualLength = (this.byteBuffer.get(offset) + 256) % 256;
                ++offset;
                break;
            }
            case 2: {
                actualLength = (this.byteBuffer.get(offset) + 256) % 256;
                int length2 = (this.byteBuffer.get(offset + 1) + 256) % 256;
                actualLength += 256 * length2;
                offset += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", prefixLength));
            }
        }
        this.byteBuffer.position(offset);
        this.byteBuffer.limit(offset + actualLength);
        String result = Utility.decode(this.byteBuffer, storeColumn.getCharsetNumber(), this.bufferManager);
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public byte[] getBytes(int column) {
        return this.getBytes(this.storeColumns[column]);
    }

    @Override
    public byte[] getBytes(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        if (ndbRecAttr.isNULL() == 1) {
            return null;
        }
        int prefixLength = storeColumn.getPrefixLength();
        int actualLength = this.lengths[index];
        int offset = this.offsets[index];
        switch (prefixLength) {
            case 0: {
                break;
            }
            case 1: {
                actualLength = (this.byteBuffer.get(offset) + 256) % 256;
                ++offset;
                break;
            }
            case 2: {
                actualLength = (this.byteBuffer.get(offset) + 256) % 256;
                int length2 = (this.byteBuffer.get(offset + 1) + 256) % 256;
                actualLength += 256 * length2;
                offset += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", prefixLength));
            }
        }
        this.byteBuffer.position(offset);
        byte[] result = new byte[actualLength];
        this.byteBuffer.get(result);
        return result;
    }

    @Override
    public Object getObject(int column) {
        return this.getObject(this.storeColumns[column]);
    }

    @Override
    public Object getObject(Column storeColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public boolean wasNull(Column storeColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Boolean getObjectBoolean(int column) {
        return this.getObjectBoolean(this.storeColumns[column]);
    }

    @Override
    public Boolean getObjectBoolean(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        if (ndbRecAttr.isNULL() == 1) {
            return null;
        }
        byte value = ndbRecAttr.int8_value();
        Boolean result = (value & 1) == 1;
        return result;
    }

    @Override
    public Byte getObjectByte(int column) {
        return this.getObjectByte(this.storeColumns[column]);
    }

    @Override
    public Byte getObjectByte(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return ndbRecAttr.isNULL() == 1 ? null : Byte.valueOf(Utility.getByte(storeColumn, ndbRecAttr));
    }

    @Override
    public Short getObjectShort(int column) {
        return this.getObjectShort(this.storeColumns[column]);
    }

    @Override
    public Short getObjectShort(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return ndbRecAttr.isNULL() == 1 ? null : Short.valueOf(Utility.getShort(storeColumn, ndbRecAttr));
    }

    @Override
    public Integer getObjectInteger(int column) {
        return this.getObjectInteger(this.storeColumns[column]);
    }

    @Override
    public Integer getObjectInteger(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return ndbRecAttr.isNULL() == 1 ? null : Integer.valueOf(Utility.getInt(storeColumn, ndbRecAttr));
    }

    @Override
    public Long getObjectLong(int column) {
        return this.getObjectLong(this.storeColumns[column]);
    }

    @Override
    public Long getObjectLong(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return ndbRecAttr.isNULL() == 1 ? null : Long.valueOf(Utility.getLong(storeColumn, ndbRecAttr.int64_value()));
    }

    @Override
    public Float getObjectFloat(int column) {
        return this.getObjectFloat(this.storeColumns[column]);
    }

    @Override
    public Float getObjectFloat(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return ndbRecAttr.isNULL() == 1 ? null : Float.valueOf(this.getFloat(storeColumn));
    }

    @Override
    public Double getObjectDouble(int column) {
        return this.getObjectDouble(this.storeColumns[column]);
    }

    @Override
    public Double getObjectDouble(Column storeColumn) {
        int index = storeColumn.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[index];
        return ndbRecAttr.isNULL() == 1 ? null : Double.valueOf(this.getDouble(storeColumn));
    }

    @Override
    public BigInteger getBigInteger(int column) {
        return this.getBigInteger(this.storeColumns[column]);
    }

    @Override
    public BigInteger getBigInteger(Column storeColumn) {
        int index = storeColumn.getColumnId();
        int offset = this.offsets[index];
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int length = Utility.getDecimalColumnSpace(precision, scale);
        this.byteBuffer.position(offset);
        return Utility.getBigInteger(this.byteBuffer, length, precision, scale);
    }

    @Override
    public BigDecimal getDecimal(int column) {
        return this.getDecimal(this.storeColumns[column]);
    }

    @Override
    public BigDecimal getDecimal(Column storeColumn) {
        int index = storeColumn.getColumnId();
        int offset = this.offsets[index];
        int precision = storeColumn.getPrecision();
        int scale = storeColumn.getScale();
        int length = Utility.getDecimalColumnSpace(precision, scale);
        this.byteBuffer.position(offset);
        return Utility.getDecimal(this.byteBuffer, length, precision, scale);
    }

    private void handleError(Object object, NdbOperation ndbOperation) {
        if (object == null) {
            Utility.throwError(object, ndbOperation.getNdbError());
        }
    }

    public void setNoResult() {
        this.nextDone = true;
    }

    @Override
    public Column[] getColumns() {
        return this.storeColumns;
    }
}

