/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class PartitionKeyImpl
implements PartitionKey {
    static final I18NHelper local = I18NHelper.getInstance(PartitionKeyImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(PartitionKeyImpl.class);
    private static PartitionKeyImpl theInstance = new PartitionKeyImpl();
    private List<KeyPartBuilder> keyPartBuilders = new ArrayList<KeyPartBuilder>();
    private List<KeyPart> keyParts = new ArrayList<KeyPart>();
    private String tableName = null;
    private int partitionId;

    PartitionKeyImpl() {
    }

    @Override
    public void addIntKey(final Column storeColumn, final int key) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer buffer = Utility.convertValue(storeColumn, key);
                KeyPart keyPart = new KeyPart(buffer, buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addShortKey(final Column storeColumn, final short key) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer buffer = Utility.convertValue(storeColumn, key);
                KeyPart keyPart = new KeyPart(buffer, buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addByteKey(final Column storeColumn, final byte key) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer buffer = Utility.convertValue(storeColumn, key);
                KeyPart keyPart = new KeyPart(buffer, buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addLongKey(final Column storeColumn, final long key) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer buffer = Utility.convertValue(storeColumn, key);
                KeyPart keyPart = new KeyPart(buffer, buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addStringKey(final Column storeColumn, final String string) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer buffer = Utility.encode(string, storeColumn, bufferManager);
                ByteBuffer copy = ByteBuffer.allocateDirect(buffer.limit() - buffer.position());
                copy.put(buffer);
                copy.flip();
                KeyPart keyPart = new KeyPart(copy, copy.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    @Override
    public void addBytesKey(final Column storeColumn, final byte[] key) {
        this.keyPartBuilders.add(new KeyPartBuilder(){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                ByteBuffer buffer = Utility.convertValue(storeColumn, key);
                KeyPart keyPart = new KeyPart(buffer, buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }
        });
    }

    public void setTable(String tableName) {
        this.tableName = tableName;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    protected void handleError(int returnCode, NdbOperation ndbOperation) {
        if (returnCode == 0) {
            return;
        }
        Utility.throwError(returnCode, ndbOperation.getNdbError());
    }

    protected static void handleError(Object object, NdbOperation ndbOperation) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperation.getNdbError());
    }

    public NdbTransaction enlist(DbImpl db) {
        DbImpl.BufferManager bufferManager = db.getBufferManager();
        for (KeyPartBuilder keyPartBuilder : this.keyPartBuilders) {
            keyPartBuilder.addKeyPart(bufferManager);
        }
        NdbTransaction result = null;
        if (this.keyParts == null || this.keyParts.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionKeyImpl.enlist via partitionId with keyparts " + (this.keyParts == null ? "null." : "size " + this.keyParts.size()) + " table: " + (this.tableName == null ? "null" : this.tableName) + " partition id: " + this.partitionId);
            }
            result = db.enlist(this.tableName, this.partitionId);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionKeyImpl.enlist via keyParts with keyparts " + (this.keyParts == null ? "null." : "size " + this.keyParts.size()) + " table: " + (this.tableName == null ? "null" : this.tableName));
            }
            result = db.enlist(this.tableName, this.keyParts);
        }
        return result;
    }

    public static PartitionKeyImpl getInstance() {
        return theInstance;
    }

    private static interface KeyPartBuilder {
        public void addKeyPart(DbImpl.BufferManager var1);
    }
}

