/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import com.mysql.clusterj.tie.NdbRecordScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import java.util.ArrayList;
import java.util.List;

class NdbRecordScanResultDataImpl
extends NdbRecordResultDataImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordScanResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordScanResultDataImpl.class);
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    private final ClusterTransactionImpl clusterTransaction;
    private final NdbRecordScanOperationImpl scanOperation;
    private final NdbScanOperation ndbScanOperation;
    protected final long skip;
    protected final long limit;
    protected long recordCounter = 0L;
    private final boolean lockRecordsDuringScan;
    private List<NdbOperationConst> recordsLocked = new ArrayList<NdbOperationConst>();

    public NdbRecordScanResultDataImpl(ClusterTransactionImpl clusterTransaction, NdbRecordScanOperationImpl scanOperation, long skip, long limit) {
        super(scanOperation);
        this.clusterTransaction = clusterTransaction;
        this.scanOperation = scanOperation;
        this.ndbScanOperation = (NdbScanOperation)scanOperation.ndbOperation;
        this.skip = skip;
        this.limit = limit;
        this.lockRecordsDuringScan = this.ndbScanOperation.getLockMode() != 2;
    }

    private void executeIfRecordsLocked() {
        if (this.recordsLocked.size() != 0) {
            this.clusterTransaction.executeNoCommit(false, true);
            for (NdbOperationConst ndbOperation : this.recordsLocked) {
                NdbErrorConst ndbError = ndbOperation.getNdbError();
                if (ndbError.code() == 0) continue;
                String detail = this.clusterTransaction.db.getNdbErrorDetail(ndbError);
                Utility.throwError(null, ndbError, detail);
            }
            this.recordsLocked.clear();
        }
    }

    @Override
    public boolean next() {
        if (this.recordCounter >= this.limit) {
            this.executeIfRecordsLocked();
            this.ndbScanOperation.close(true, true);
            return false;
        }
        boolean done = false;
        boolean fetch = false;
        boolean force = true;
        block5: while (!done) {
            int result = this.scanOperation.nextResultCopyOut(fetch, force);
            switch (result) {
                case 0: {
                    NdbOperationConst lockedRecord;
                    if (++this.recordCounter <= this.skip) continue block5;
                    if (this.lockRecordsDuringScan && (lockedRecord = this.scanOperation.lockCurrentTuple()) != null) {
                        this.recordsLocked.add(lockedRecord);
                    }
                    this.scanOperation.loadBlobValues();
                    return true;
                }
                case 1: {
                    this.executeIfRecordsLocked();
                    this.ndbScanOperation.close(true, true);
                    return false;
                }
                case 2: {
                    this.executeIfRecordsLocked();
                    fetch = true;
                    continue block5;
                }
            }
            Utility.throwError(result, this.ndbScanOperation.getNdbError());
        }
        return true;
    }
}

