/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordBlobImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordScanResultDataImpl;
import com.mysql.clusterj.tie.ScanFilterImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbInterpretedCode;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

public abstract class NdbRecordScanOperationImpl
extends NdbRecordOperationImpl
implements ScanOperation {
    NdbScanOperation.ScanOptions scanOptions = null;
    NdbScanFilter ndbScanFilter = null;
    NdbInterpretedCode ndbInterpretedCode = null;
    protected boolean multiRange = false;
    int lockMode;
    Query.Ordering ordering = null;

    public NdbRecordScanOperationImpl(ClusterTransactionImpl clusterTransaction, Table storeTable, int lockMode) {
        super(clusterTransaction, storeTable);
        this.ndbRecordKeys = clusterTransaction.getCachedNdbRecordImpl(storeTable);
        this.keyBufferSize = this.ndbRecordKeys.getBufferSize();
        this.ndbRecordValues = clusterTransaction.getCachedNdbRecordImpl(storeTable);
        this.valueBufferSize = this.ndbRecordValues.getBufferSize();
        this.numberOfColumns = this.ndbRecordValues.getNumberOfColumns();
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.lockMode = lockMode;
        this.resetMask();
    }

    public ResultData resultData(boolean execute) {
        return this.resultData(execute, 0L, Long.MAX_VALUE);
    }

    public ResultData resultData(boolean execute, long skip, long limit) {
        NdbRecordScanResultDataImpl result = new NdbRecordScanResultDataImpl(this, skip, limit);
        if (execute) {
            this.clusterTransaction.executeNoCommit(false, true);
        }
        return result;
    }

    public String toString() {
        return " scan " + this.tableName;
    }

    public void close() {
        ((NdbScanOperation)this.ndbOperation).close(true, true);
    }

    public void freeResourcesAfterExecute() {
        super.freeResourcesAfterExecute();
        if (this.ndbInterpretedCode != null) {
            this.db.delete(this.ndbInterpretedCode);
        }
        if (this.ndbScanFilter != null) {
            this.db.delete(this.ndbScanFilter);
        }
        if (this.scanOptions != null) {
            this.db.delete(this.scanOptions);
        }
    }

    public void deleteCurrentTuple() {
        int returnCode = ((NdbScanOperation)this.ndbOperation).deleteCurrentTuple();
        NdbRecordScanOperationImpl.handleError(returnCode, this.ndbOperation);
    }

    protected void getScanOptions() {
        long options = 0L;
        int flags = 0;
        if (this.ordering != null || this.multiRange || this.lockMode != 2 || this.ndbScanFilter != null) {
            this.scanOptions = this.db.createScanOptions();
            if (this.ordering != null) {
                options |= 1L;
                switch (this.ordering) {
                    case ASCENDING: {
                        flags |= 0x1000000;
                        break;
                    }
                    case DESCENDING: {
                        flags |= 0x2000000;
                        flags |= 0x1000000;
                        break;
                    }
                    default: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Ordering", (Object)this.ordering));
                    }
                }
            }
            if (this.multiRange) {
                options |= 1L;
                flags |= 0x8000000;
                flags |= 0x4000000;
            }
            if (this.lockMode != 2) {
                options |= 1L;
                flags |= 1;
            }
            if (this.ndbScanFilter != null) {
                options |= 0x20L;
                this.scanOptions.interpretedCode(this.ndbScanFilter.getInterpretedCode());
            }
            if (flags != 0) {
                this.scanOptions.scan_flags(flags);
            }
            this.scanOptions.optionsPresent(options);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ScanOptions: " + this.dumpScanOptions(options, flags));
        }
    }

    protected String dumpScanOptions(long optionsPresent, int flags) {
        StringBuilder builder = new StringBuilder();
        if (0L != (optionsPresent & 4L)) {
            builder.append("SO_BATCH ");
        }
        if (0L != (optionsPresent & 8L)) {
            builder.append("SO_GETVALUE ");
        }
        if (0L != (optionsPresent & 2L)) {
            builder.append("SO_PARALLEL ");
        }
        if (0L != (optionsPresent & 0x40L)) {
            builder.append("SO_CUSTOMDATA ");
        }
        if (0L != (optionsPresent & 0x20L)) {
            builder.append("SO_INTERPRETED ");
        }
        if (0L != (optionsPresent & 0x10L)) {
            builder.append("SO_PARTITION_ID ");
        }
        if (0L != (optionsPresent & 1L)) {
            builder.append("SO_SCANFLAGS(");
            if (0 != (flags & 1)) {
                builder.append("SF_KeyInfo ");
            }
            if (0 != (flags & 0x2000000)) {
                builder.append("SF_Descending ");
            }
            if (0 != (flags & 0x20000)) {
                builder.append("SF_DiskScan ");
            }
            if (0 != (flags & 0x8000000)) {
                builder.append("SF_MultiRange ");
            }
            if (0 != (flags & 0x1000000)) {
                builder.append("SF_OrderBy ");
            }
            if (0 != (flags & 0x4000000)) {
                builder.append("SF_ReadRangeNo ");
            }
            if (0 != (flags & 0x10000)) {
                builder.append("SF_TupScan ");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public ScanFilter getScanFilter(QueryExecutionContext context) {
        this.ndbInterpretedCode = this.db.createInterpretedCode(this.ndbRecordValues.getNdbTable(), 0);
        NdbRecordScanOperationImpl.handleError((Object)this.ndbInterpretedCode, this.ndbOperation);
        this.ndbScanFilter = this.db.createScanFilter(this.ndbInterpretedCode);
        NdbRecordScanOperationImpl.handleError((Object)this.ndbScanFilter, this.ndbOperation);
        ScanFilterImpl scanFilter = new ScanFilterImpl(this.ndbScanFilter);
        context.addFilter(scanFilter);
        return scanFilter;
    }

    public int nextResult(boolean fetch) {
        int result = ((NdbScanOperation)this.ndbOperation).nextResult(fetch, false);
        this.clusterTransaction.handleError(result);
        return result;
    }

    public int nextResultCopyOut(boolean fetch, boolean force) {
        this.allocateValueBuffer();
        int result = ((NdbScanOperation)this.ndbOperation).nextResultCopyOut(this.valueBuffer, fetch, force);
        return result;
    }

    public void lockCurrentTuple() {
        NdbOperationConst op;
        if (this.lockMode != 2 && (op = ((NdbScanOperation)this.ndbOperation).lockCurrentTuple(this.clusterTransaction.ndbTransaction, this.ndbRecordValues.getNdbRecord(), null, null, null, 0)) == null) {
            Utility.throwError(op, this.ndbOperation.getNdbError());
        }
    }

    public NdbRecordOperationImpl transformNdbRecordOperationImpl() {
        NdbRecordOperationImpl result = new NdbRecordOperationImpl(this);
        this.keyBuffer = this.valueBuffer = this.ndbRecordValues.newBuffer();
        return result;
    }

    public void setOrdering(Query.Ordering ordering) {
        this.ordering = ordering;
    }
}

