/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.IndexHandlerImpl;
import com.mysql.clusterj.core.metadata.KeyValueHandlerImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfigurationImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainFieldHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAResult;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import com.mysql.clusterj.openjpa.NdbOpenJPAUtility;
import com.mysql.clusterj.openjpa.NdbOpenJPAValueHandler;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NdbOpenJPADomainTypeHandlerImpl<T>
implements DomainTypeHandler<T> {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPADomainTypeHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPADomainTypeHandlerImpl.class);
    private String typeName;
    private Class<T> describedType;
    private Class<?> oidClass;
    private com.mysql.clusterj.core.store.Table storeTable;
    private String tableName;
    private List<NdbOpenJPADomainFieldHandlerImpl> primaryKeyFields = new ArrayList<NdbOpenJPADomainFieldHandlerImpl>();
    private int[] primaryKeyFieldNumbers;
    private List<NdbOpenJPADomainFieldHandlerImpl> fields = new ArrayList<NdbOpenJPADomainFieldHandlerImpl>();
    private ClassMapping classMapping;
    private NdbOpenJPADomainFieldHandlerImpl[] fieldHandlers;
    private Set<Column> allStoreColumns = new HashSet<Column>();
    private List<IndexHandlerImpl> indexHandlerImpls = new ArrayList<IndexHandlerImpl>();
    private String[] partitionKeyColumnNames;
    private int numberOfPartitionKeyColumns;
    private NdbOpenJPADomainFieldHandlerImpl[] partitionKeyFieldHandlers;
    private NdbOpenJPAConfigurationImpl domainTypeHandlerFactory;
    private Dictionary dictionary;
    private Set<NdbOpenJPADomainTypeHandlerImpl<?>> dependencies = new HashSet();
    private Status status = Status.IN_PROCESS;
    private List<String> reasons = new ArrayList<String>();

    NdbOpenJPADomainTypeHandlerImpl(Dictionary dictionary, ClassMapping classMapping, NdbOpenJPAConfigurationImpl domainTypeHandlerFactory) {
        int modifiers;
        String message = null;
        this.dictionary = dictionary;
        this.domainTypeHandlerFactory = domainTypeHandlerFactory;
        this.classMapping = classMapping;
        classMapping.resolve(-1);
        this.oidClass = classMapping.getObjectIdType();
        this.describedType = classMapping.getDescribedType();
        if (classMapping.getPCSuperclass() != null) {
            message = local.message("ERR_Subclass", (Object)this.describedType);
            this.setUnsupported(message);
        }
        if (classMapping.getPCSubclasses() != null && classMapping.getPCSubclasses().length > 0) {
            message = local.message("ERR_Superclass", (Object)this.describedType);
            this.setUnsupported(message);
        }
        if (Modifier.isAbstract(modifiers = this.describedType.getClass().getModifiers())) {
            message = local.message("ERR_Abstract_Class", (Object)this.describedType.getClass().getName());
            this.setUnsupported(message);
        }
        this.typeName = this.describedType.getName();
        Table table = classMapping.getTable();
        if (table != null) {
            this.tableName = table.getFullName();
            this.storeTable = dictionary.getTable(this.tableName);
            if (this.storeTable == null) {
                message = local.message("ERR_No_Table", (Object)this.describedType.getClass().getName(), (Object)this.tableName);
                logger.info(message);
                this.setUnsupported(message);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("initialize for class: " + this.typeName + " mapped to table: " + this.storeTable.getName());
                }
                this.partitionKeyColumnNames = this.storeTable.getPartitionKeyColumnNames();
                this.numberOfPartitionKeyColumns = this.partitionKeyColumnNames.length;
                this.partitionKeyFieldHandlers = new NdbOpenJPADomainFieldHandlerImpl[this.numberOfPartitionKeyColumns];
                if (logger.isDetailEnabled()) {
                    logger.detail("partition key columns for class: " + this.typeName + " partition key columns: " + this.numberOfPartitionKeyColumns + " names: " + Arrays.toString(this.partitionKeyColumnNames));
                }
            }
        } else {
            message = local.message("ERR_No_Mapped_Table", (Object)this.describedType.getClass().getName());
            logger.info(message);
            this.setUnsupported(message);
        }
        ArrayList<FieldMapping> allFieldMappings = new ArrayList<FieldMapping>();
        allFieldMappings.addAll(Arrays.asList(classMapping.getFieldMappings()));
        FieldMapping versionFieldMapping = classMapping.getVersionFieldMapping();
        if (versionFieldMapping != null) {
            allFieldMappings.add(versionFieldMapping);
        }
        for (FieldMapping fm : allFieldMappings) {
            if (logger.isDetailEnabled()) {
                logger.detail("field name: " + fm.getName() + " of type: " + fm.getTypeCode());
            }
            NdbOpenJPADomainFieldHandlerImpl fmd = new NdbOpenJPADomainFieldHandlerImpl(dictionary, this, domainTypeHandlerFactory, fm);
            this.fields.add(fmd);
            if (!fmd.isSupported()) {
                this.setUnsupported(fmd.getReason());
                continue;
            }
            for (Column column : fmd.getStoreColumns()) {
                this.allStoreColumns.add(column);
            }
            if (!fmd.isPrimaryKey()) continue;
            this.primaryKeyFields.add(fmd);
        }
        this.primaryKeyFieldNumbers = new int[this.primaryKeyFields.size()];
        int i = 0;
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.primaryKeyFields) {
            this.primaryKeyFieldNumbers[i++] = fmd.getFieldNumber();
        }
        this.fieldHandlers = this.fields.toArray(new NdbOpenJPADomainFieldHandlerImpl[this.fields.size()]);
        for (int j = 0; j < this.numberOfPartitionKeyColumns; ++j) {
            if (this.partitionKeyFieldHandlers[j] != null) continue;
            this.setUnsupported();
            this.reasons.add("Unmapped partition key " + this.partitionKeyColumnNames[j]);
        }
    }

    protected void registerPrimaryKeyColumn(NdbOpenJPADomainFieldHandlerImpl fmd, String columnName) {
        for (int j = 0; j < this.partitionKeyColumnNames.length; ++j) {
            if (this.partitionKeyColumnNames[j].equals(columnName)) {
                this.partitionKeyFieldHandlers[j] = fmd;
                continue;
            }
            if (!logger.isDetailEnabled()) continue;
            logger.detail("NdbOpenJPADomainTypeHandlerImpl.registerPrimaryKeyColumn mismatch between partition key column name: " + this.partitionKeyColumnNames[j] + " and primary key column name: " + columnName);
        }
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public Class<?> getOidClass() {
        return this.oidClass;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public DomainFieldHandler getFieldHandler(String fieldName) {
        if (logger.isDetailEnabled()) {
            logger.detail("In " + this.getName() + " looking for " + fieldName);
        }
        for (NdbOpenJPADomainFieldHandlerImpl domainFieldHandler : this.fields) {
            if (!fieldName.equals(domainFieldHandler.getName())) continue;
            return domainFieldHandler;
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Field_Name", (Object)fieldName, (Object)this.getName()));
    }

    @Override
    public Class<T> getProxyClass() {
        return null;
    }

    @Override
    public T newInstance(Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(ValueHandler valueHandler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(ResultData resultData, Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectMarkModified(ValueHandler handler, String fieldName) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetKeys(Object keys, Object instance) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetValues(ResultData rs, ValueHandler handler) {
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
            fmd.objectSetValue(rs, handler);
        }
    }

    public void objectSetValuesExcept(ResultData rs, ValueHandler handler, String indexName) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetCacheManager(CacheManager cm, Object instance) {
    }

    @Override
    public void objectResetModified(ValueHandler handler) {
    }

    @Override
    public void operationGetValues(Operation op) {
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
            fmd.operationGetValue(op);
        }
    }

    public void operationGetKeys(Operation op) {
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.primaryKeyFields) {
            fmd.operationGetValue(op);
        }
    }

    @Override
    public void operationGetValues(Operation op, BitSet fields) {
        if (fields == null) {
            this.operationGetValues(op);
        } else {
            int i = 0;
            for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
                if (!fields.get(i++)) continue;
                fmd.operationGetValue(op);
            }
        }
    }

    @Override
    public void operationSetKeys(ValueHandler handler, Operation op) {
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.primaryKeyFields) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class: " + this.typeName + " Primary Key Field: " + fmd.getName() + handler.pkToString(this));
            }
            fmd.operationSetValue(handler, op);
        }
    }

    @Override
    public void operationSetModifiedValues(ValueHandler handler, Operation op) {
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
            fmd.operationSetModifiedValue(handler, op);
        }
    }

    public void operationSetValuesExcept(ValueHandler handler, Operation op, String index) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
                if (fmd.includedInIndex(index)) continue;
                fmd.operationSetValue(handler, op);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetValuesExcept caught exception", exception);
        }
    }

    @Override
    public void operationSetModifiedNonPKValues(ValueHandler handler, Operation op) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
                if (fmd.isPrimaryKey()) continue;
                fmd.operationSetModifiedValue(handler, op);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetModifiedValuesExcept caught " + exception);
        }
    }

    @Override
    public T getInstance(ValueHandler handler) {
        OpenJPAStateManager sm = ((NdbOpenJPAValueHandler)handler).getStateManager();
        sm.initialize(this.describedType, PCState.PNONTRANS);
        Object instance = sm.getManagedInstance();
        return (T)instance;
    }

    @Override
    public ValueHandler createKeyValueHandler(Object keys, Db db) {
        FieldMapping[] primaryKeyFieldMappings = this.classMapping.getPrimaryKeyFieldMappings();
        int numberOfFields = this.classMapping.getFieldMappings().length;
        Object[] keyValues = new Object[numberOfFields];
        boolean nullKeyValue = false;
        if (primaryKeyFieldMappings.length != 1) {
            for (NdbOpenJPADomainFieldHandlerImpl fmd : this.primaryKeyFields) {
                Object keyValue;
                keyValues[fmd.getFieldNumber()] = keyValue = fmd.getKeyValue(keys);
                if (keyValue != null) continue;
                nullKeyValue = true;
            }
        } else {
            keyValues[primaryKeyFieldMappings[0].getIndex()] = keys;
        }
        KeyValueHandlerImpl keyHandler = new KeyValueHandlerImpl(keyValues);
        return nullKeyValue ? null : keyHandler;
    }

    @Override
    public ValueHandler getValueHandler(Object instance) {
        if (instance instanceof ValueHandler) {
            return (ValueHandler)instance;
        }
        OpenJPAStateManager sm = (OpenJPAStateManager)instance;
        return new NdbOpenJPAValueHandler(sm);
    }

    public ValueHandler getValueHandler(OpenJPAStateManager sm, NdbOpenJPAStoreManager store) {
        return new NdbOpenJPAValueHandler(sm, store);
    }

    @Override
    public int[] getKeyFieldNumbers() {
        return this.primaryKeyFieldNumbers;
    }

    public void newInstance(OpenJPAStateManager sm) {
        sm.initialize(this.describedType, PCState.PNONTRANS);
    }

    @Override
    public CandidateIndexImpl[] createCandidateIndexes() {
        CandidateIndexImpl[] result = new CandidateIndexImpl[this.indexHandlerImpls.size()];
        int i = 0;
        for (IndexHandlerImpl indexHandler : this.indexHandlerImpls) {
            result[i++] = indexHandler.toCandidateIndexImpl();
        }
        return result;
    }

    public boolean load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, BitSet fields, JDBCFetchConfiguration fetch, Object context) throws SQLException {
        if (logger.isDetailEnabled()) {
            StringBuilder buffer = new StringBuilder("load for ");
            buffer.append(this.typeName);
            buffer.append(" for fields ");
            buffer.append(NdbOpenJPAUtility.printBitSet(sm, fields));
            logger.detail(buffer.toString());
        }
        boolean loadedAny = false;
        ArrayList<NdbOpenJPADomainFieldHandlerImpl> requestedFields = new ArrayList<NdbOpenJPADomainFieldHandlerImpl>();
        int i = fields.nextSetBit(0);
        while (i >= 0) {
            if (!sm.getLoaded().get(i)) {
                NdbOpenJPADomainFieldHandlerImpl fieldHandler = this.fieldHandlers[i];
                if (logger.isDebugEnabled()) {
                    logger.debug("loading field " + fieldHandler.getName() + " for column " + fieldHandler.getColumnName());
                }
                if (fieldHandler.isRelation()) {
                    fieldHandler.load(sm, store, fetch);
                    loadedAny = true;
                } else {
                    requestedFields.add(fieldHandler);
                }
            }
            i = fields.nextSetBit(i + 1);
        }
        if (requestedFields.size() != 0) {
            NdbOpenJPAResult result = store.lookup(sm, this, requestedFields);
            for (NdbOpenJPADomainFieldHandlerImpl fieldHandler : this.fieldHandlers) {
                loadedAny = true;
                fieldHandler.load(sm, store, fetch, result);
            }
        }
        return loadedAny;
    }

    public void load(OpenJPAStateManager sm, NdbOpenJPAStoreManager store, JDBCFetchConfiguration fetch, NdbOpenJPAResult result) throws SQLException {
        for (NdbOpenJPADomainFieldHandlerImpl fieldHandler : this.fieldHandlers) {
            if (logger.isDebugEnabled()) {
                logger.debug("loading field " + fieldHandler.getName() + " for column " + fieldHandler.getColumnName() + " from result data.");
            }
            fieldHandler.load(sm, store, fetch, result);
        }
    }

    @Override
    public Set<Column> getStoreColumns(BitSet fields) {
        if (fields == null) {
            return this.allStoreColumns;
        }
        HashSet<Column> result = new HashSet<Column>();
        int i = fields.nextSetBit(0);
        while (i >= 0) {
            NdbOpenJPADomainFieldHandlerImpl fieldHandler = this.fieldHandlers[i];
            for (Column column : fieldHandler.getStoreColumns()) {
                result.add(column);
            }
            i = fields.nextSetBit(i + 1);
        }
        return result;
    }

    public NdbOpenJPADomainFieldHandlerImpl getDomainFieldHandler(FieldMapping fm) {
        for (NdbOpenJPADomainFieldHandlerImpl domainFieldHandler : this.fieldHandlers) {
            if (!fm.equals((Object)domainFieldHandler.getFieldMapping())) continue;
            return domainFieldHandler;
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Field_Mapping", (Object)this.getName(), (Object)fm.getName()));
    }

    public int[][] createIndexHandler(NdbOpenJPADomainFieldHandlerImpl fieldHandler, Dictionary dictionary, String indexName) {
        IndexHandlerImpl indexHandler = new IndexHandlerImpl(this, dictionary, indexName, fieldHandler);
        int currentIndex = this.indexHandlerImpls.size();
        this.indexHandlerImpls.add(indexHandler);
        int[][] result = new int[1][2];
        result[0][0] = currentIndex;
        result[0][1] = 0;
        return result;
    }

    public com.mysql.clusterj.core.store.Table getTable() {
        return this.storeTable;
    }

    @Override
    public com.mysql.clusterj.core.store.Table getStoreTable() {
        return this.storeTable;
    }

    @Override
    public PartitionKey createPartitionKey(ValueHandler handler) {
        PartitionKey result = this.storeTable.createPartitionKey();
        for (NdbOpenJPADomainFieldHandlerImpl fmd : this.partitionKeyFieldHandlers) {
            if (logger.isDetailEnabled()) {
                logger.detail("Field number " + fmd.getFieldNumber() + " column name " + fmd.getColumnName() + " field name " + fmd.getName());
            }
            fmd.partitionKeySetPart(result, handler);
        }
        return result;
    }

    public NdbOpenJPADomainTypeHandlerImpl<?> registerDependency(ClassMapping mapping) {
        NdbOpenJPADomainTypeHandlerImpl<?> domainTypeHandler = this.domainTypeHandlerFactory.getDomainTypeHandler(mapping, this.dictionary);
        this.dependencies.add(domainTypeHandler);
        return domainTypeHandler;
    }

    private Status supportStatus() {
        return this.status;
    }

    public void initializeRelations() {
        for (NdbOpenJPADomainFieldHandlerImpl fieldHandler : this.fieldHandlers) {
            fieldHandler.initializeRelations();
        }
        boolean supported = this.status != Status.BAD;
        boolean workToDo = !supported;
        ArrayList copyOfDependencies = new ArrayList(this.dependencies);
        for (NdbOpenJPADomainTypeHandlerImpl ndbOpenJPADomainTypeHandlerImpl : copyOfDependencies) {
            String message;
            this.dependencies.addAll(ndbOpenJPADomainTypeHandlerImpl.getDependencies());
            switch (ndbOpenJPADomainTypeHandlerImpl.supportStatus()) {
                case IN_PROCESS: {
                    workToDo = true;
                    break;
                }
                case GOOD: {
                    break;
                }
                case BAD: {
                    this.setUnsupported();
                    supported = false;
                    workToDo = true;
                    message = local.message("ERR_Bad_Dependency", (Object)ndbOpenJPADomainTypeHandlerImpl.typeName);
                    this.reasons.add(message);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug(message);
                }
            }
            message = "Processing class " + this.typeName + " found dependency " + ndbOpenJPADomainTypeHandlerImpl.typeName + " support status is: " + (Object)((Object)ndbOpenJPADomainTypeHandlerImpl.supportStatus());
            if (!logger.isDetailEnabled()) continue;
            logger.detail(message);
        }
        if (workToDo) {
            if (!supported) {
                for (NdbOpenJPADomainTypeHandlerImpl ndbOpenJPADomainTypeHandlerImpl : this.dependencies) {
                    ndbOpenJPADomainTypeHandlerImpl.setUnsupported();
                }
            } else {
                for (NdbOpenJPADomainTypeHandlerImpl ndbOpenJPADomainTypeHandlerImpl : this.dependencies) {
                    ndbOpenJPADomainTypeHandlerImpl.setSupported();
                }
            }
        } else {
            this.setSupported();
        }
        if (logger.isDetailEnabled()) {
            logger.detail("Processing class " + this.typeName + " has dependencies " + this.dependencies);
        }
        if (logger.isDetailEnabled()) {
            logger.detail("Processing class " + this.typeName + " has dependencies " + this.dependencies);
        }
    }

    private Set<NdbOpenJPADomainTypeHandlerImpl<?>> getDependencies() {
        return this.dependencies;
    }

    private void setUnsupported() {
        if (this.status != Status.BAD) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class " + this.typeName + " marked as BAD.");
            }
            this.status = Status.BAD;
        }
    }

    @Override
    public void setUnsupported(String reason) {
        if (this.status != Status.BAD) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class " + this.typeName + " marked as BAD.");
            }
            this.status = Status.BAD;
        }
        this.reasons.add(reason);
    }

    private void setSupported() {
        if (this.status != Status.GOOD) {
            if (logger.isDetailEnabled()) {
                logger.detail("Class " + this.typeName + " marked as GOOD.");
            }
            this.status = Status.GOOD;
        }
    }

    @Override
    public boolean isSupportedType() {
        return Status.GOOD == this.status;
    }

    public String getReasons() {
        if (this.reasons.size() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(local.message("MSG_Unsupported_Class", (Object)this.getName()));
        for (String reason : this.reasons) {
            result.append('\n');
            result.append(reason);
            result.append(';');
        }
        result.append('\n');
        return result.toString();
    }

    public String toString() {
        return "NdbOpenJPADomainTypeHandlerImpl:" + this.typeName;
    }

    @Override
    public String[] getFieldNames() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void operationSetValues(ValueHandler valueHandler, Operation op) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
                fmd.operationSetValue(valueHandler, op);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetValues caught exception", exception);
        }
    }

    @Override
    public void operationSetNonPKValues(ValueHandler valueHandler, Operation op) {
        try {
            for (NdbOpenJPADomainFieldHandlerImpl fmd : this.fields) {
                if (fmd.isPrimaryKey()) continue;
                fmd.operationSetValue(valueHandler, op);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("NdbOpenJPADomainTypeHandlerImpl.operationSetNonPKValues caught exception", exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        IN_PROCESS,
        GOOD,
        BAD;

    }
}

