/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.ArrayList;

public final class CandidateIndexImpl {
    static final I18NHelper local = I18NHelper.getInstance(CandidateIndexImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(CandidateIndexImpl.class);
    private String className = "none";
    private Index storeIndex;
    private String indexName = "none";
    private boolean unique;
    private boolean multiRange = false;
    private CandidateColumnImpl[] candidateColumns = null;
    private PredicateImpl.ScanType scanType = PredicateImpl.ScanType.TABLE_SCAN;
    private int fieldScore = 1;
    protected int score = 0;
    private boolean canBound = true;
    static CandidateIndexImpl indexForNullWhereClause = new CandidateIndexImpl();
    CandidateColumnImpl lastLowerBoundColumn = null;
    CandidateColumnImpl lastUpperBoundColumn = null;
    private final int BOUND_STATUS_NO_BOUND_DONE = 0;
    private final int BOUND_STATUS_LOWER_BOUND_DONE = 1;
    private final int BOUND_STATUS_UPPER_BOUND_DONE = 2;
    private final int BOUND_STATUS_BOTH_BOUNDS_DONE = 3;

    public CandidateIndexImpl(String className, Index storeIndex, boolean unique, AbstractDomainFieldHandlerImpl[] fields) {
        if (logger.isDebugEnabled()) {
            logger.debug("className: " + className + " storeIndex: " + storeIndex.getName() + " unique: " + Boolean.toString(unique) + " fields: " + this.toString(fields));
        }
        this.className = className;
        this.storeIndex = storeIndex;
        this.indexName = storeIndex.getName();
        this.unique = unique;
        this.candidateColumns = new CandidateColumnImpl[fields.length];
        if (fields.length == 1) {
            this.fieldScore = fields[0].getColumnNames().length;
        }
        int i = 0;
        for (AbstractDomainFieldHandlerImpl domainFieldHandler : fields) {
            CandidateColumnImpl candidateColumn = new CandidateColumnImpl(domainFieldHandler);
            this.candidateColumns[i++] = candidateColumn;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
    }

    private String toString(AbstractDomainFieldHandlerImpl[] fields) {
        StringBuilder builder = new StringBuilder();
        int separator = 91;
        for (AbstractDomainFieldHandlerImpl field : fields) {
            builder.append((char)separator);
            builder.append(field.getName());
            separator = 32;
        }
        builder.append(']');
        return builder.toString();
    }

    public static CandidateIndexImpl getIndexForNullWhereClause() {
        return indexForNullWhereClause;
    }

    protected CandidateIndexImpl() {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CandidateIndexImpl for class: ");
        buffer.append(this.className);
        buffer.append(" index: ");
        buffer.append(this.indexName);
        buffer.append(" unique: ");
        buffer.append(this.unique);
        if (this.candidateColumns != null) {
            for (CandidateColumnImpl column : this.candidateColumns) {
                buffer.append(" field: ");
                buffer.append(column.domainFieldHandler.getName());
            }
        } else {
            buffer.append(" no fields.");
        }
        return buffer.toString();
    }

    public void markLowerBound(int fieldNumber, PredicateImpl predicate, boolean strict) {
        if (this.candidateColumns != null) {
            this.candidateColumns[fieldNumber].markLowerBound(predicate, strict);
        }
    }

    public void markUpperBound(int fieldNumber, PredicateImpl predicate, boolean strict) {
        if (this.candidateColumns != null) {
            this.candidateColumns[fieldNumber].markUpperBound(predicate, strict);
        }
    }

    public void markEqualBound(int fieldNumber, PredicateImpl predicate) {
        if (this.candidateColumns != null) {
            this.candidateColumns[fieldNumber].markEqualBound(predicate);
        }
    }

    public void markInBound(int fieldNumber, InPredicateImpl predicate) {
        if (this.candidateColumns != null) {
            this.candidateColumns[fieldNumber].markInBound(predicate);
        }
    }

    String getIndexName() {
        return this.indexName;
    }

    synchronized void score() {
        this.score = 0;
        if (this.candidateColumns == null) {
            return;
        }
        boolean lowerBoundDone = false;
        boolean upperBoundDone = false;
        if (this.unique) {
            for (CandidateColumnImpl column : this.candidateColumns) {
                if (column.equalBound) continue;
                return;
            }
            this.scanType = "PRIMARY".equals(this.indexName) ? PredicateImpl.ScanType.PRIMARY_KEY : PredicateImpl.ScanType.UNIQUE_KEY;
            this.score = 100;
            return;
        }
        boolean firstColumn = true;
        for (CandidateColumnImpl candidateColumn : this.candidateColumns) {
            if (candidateColumn.equalBound) {
                this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
                if (!lowerBoundDone) {
                    this.score += this.fieldScore;
                    this.lastLowerBoundColumn = candidateColumn;
                }
                if (!upperBoundDone) {
                    this.score += this.fieldScore;
                    this.lastUpperBoundColumn = candidateColumn;
                }
            } else if (candidateColumn.inBound) {
                this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
                if (firstColumn) {
                    this.multiRange = true;
                }
                if (!lowerBoundDone) {
                    this.score += this.fieldScore;
                    this.lastLowerBoundColumn = candidateColumn;
                }
                if (!upperBoundDone) {
                    this.score += this.fieldScore;
                    this.lastUpperBoundColumn = candidateColumn;
                }
            } else if (!lowerBoundDone || !upperBoundDone) {
                boolean hasLowerBound = candidateColumn.hasLowerBound();
                boolean hasUpperBound = candidateColumn.hasUpperBound();
                if (hasLowerBound || hasUpperBound) {
                    this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
                }
                if (!lowerBoundDone) {
                    if (hasLowerBound) {
                        this.score += this.fieldScore;
                        this.lastLowerBoundColumn = candidateColumn;
                    } else {
                        lowerBoundDone = true;
                    }
                }
                if (!upperBoundDone) {
                    if (hasUpperBound) {
                        this.score += this.fieldScore;
                        this.lastUpperBoundColumn = candidateColumn;
                    } else {
                        upperBoundDone = true;
                    }
                }
                if (lowerBoundDone && upperBoundDone) continue;
            }
            firstColumn = false;
        }
        if (this.lastLowerBoundColumn != null) {
            this.lastLowerBoundColumn.markLastLowerBoundColumn();
        }
        if (this.lastUpperBoundColumn != null) {
            this.lastUpperBoundColumn.markLastUpperBoundColumn();
        }
    }

    public PredicateImpl.ScanType getScanType() {
        return this.scanType;
    }

    void operationSetBounds(QueryExecutionContext context, IndexScanOperation op) {
        if (this.multiRange) {
            ArrayList<Integer> parameterSizes = new ArrayList<Integer>();
            for (CandidateColumnImpl candidateColumn : this.candidateColumns) {
                if (!candidateColumn.hasInBound()) continue;
                parameterSizes.add(candidateColumn.getParameterSize(context));
            }
            if (parameterSizes.size() > 1) {
                throw new ClusterJUserException(local.message("ERR_Too_Many_In_For_Index", (Object)this.indexName));
            }
            if (this.candidateColumns.length == 1) {
                this.candidateColumns[0].operationSetAllBounds(context, op);
            } else {
                for (int parameterIndex = 0; parameterIndex < (Integer)parameterSizes.get(0); ++parameterIndex) {
                    int boundStatus = 0;
                    for (CandidateColumnImpl candidateColumn : this.candidateColumns) {
                        if (logger.isDetailEnabled()) {
                            logger.detail("parameterIndex: " + parameterIndex + " boundStatus: " + boundStatus + " candidateColumn: " + candidateColumn.domainFieldHandler.getName());
                        }
                        if (boundStatus == 3) continue;
                        boundStatus = candidateColumn.operationSetBounds(context, op, parameterIndex, boundStatus);
                    }
                    op.endBound(parameterIndex);
                }
            }
        } else {
            int boundStatus = 0;
            for (CandidateColumnImpl candidateColumn : this.candidateColumns) {
                if (logger.isDetailEnabled()) {
                    logger.detail("boundStatus: " + boundStatus + " candidateColumn: " + candidateColumn.domainFieldHandler.getName());
                }
                if (boundStatus == 3) continue;
                boundStatus = candidateColumn.operationSetBounds(context, op, -1, boundStatus);
            }
        }
    }

    void operationSetKeys(QueryExecutionContext context, Operation op) {
        for (CandidateColumnImpl candidateColumn : this.candidateColumns) {
            candidateColumn.operationSetKeys(context, op);
        }
    }

    public boolean supportsConditionsOfLength(int numberOfConditions) {
        if (this.unique) {
            return numberOfConditions == this.candidateColumns.length;
        }
        return true;
    }

    public Index getStoreIndex() {
        return this.storeIndex;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isMultiRange() {
        return this.multiRange;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int isUsable(QueryExecutionContext context, String[] orderingFields) {
        boolean ordering;
        boolean bl = ordering = orderingFields != null;
        if (ordering && !this.containsAllOrderingFields(orderingFields)) {
            return -1;
        }
        if (this.unique && this.score > 0) {
            return context.hasNoNullParameters() ? 1 : -1;
        }
        if (this.candidateColumns == null) {
            this.canBound = false;
        } else {
            CandidateColumnImpl candidateColumn = this.candidateColumns[0];
            PredicateImpl predicate = candidateColumn.predicate;
            boolean bl2 = this.canBound = predicate != null && predicate.isUsable(context);
        }
        if (this.canBound) {
            if (logger.isDebugEnabled()) {
                logger.debug("for " + this.indexName + " canBound true -> returns 1");
            }
            this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
            return 1;
        }
        if (ordering) {
            if (logger.isDebugEnabled()) {
                logger.debug("for " + this.indexName + " canBound false -> returns 0");
            }
            this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
            return 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("for " + this.indexName + " canBound false -> returns -1");
        }
        return -1;
    }

    public boolean containsAllOrderingFields(String[] orderingFields) {
        if (this.isUnique()) {
            return false;
        }
        int candidateColumnIndex = 0;
        if (orderingFields != null) {
            for (String orderingField : orderingFields) {
                if (candidateColumnIndex >= this.candidateColumns.length) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Index " + this.indexName + " cannot be used because " + orderingField + " is not part of this index.");
                    }
                    return false;
                }
                CandidateColumnImpl candidateColumn = this.candidateColumns[candidateColumnIndex++];
                if (orderingField.equals(candidateColumn.domainFieldHandler.getName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Index " + this.indexName + " cannot be used because CandidateColumn " + candidateColumn.domainFieldHandler.getName() + " does not match " + orderingField);
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CandidateIndexImpl.containsAllOrderingFields found possible index (unique: " + this.unique + ") " + this.indexName);
            }
            this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
            return true;
        }
        return false;
    }

    class CandidateColumnImpl {
        protected AbstractDomainFieldHandlerImpl domainFieldHandler;
        protected PredicateImpl predicate;
        protected PredicateImpl lowerBoundPredicate;
        protected PredicateImpl upperBoundPredicate;
        protected PredicateImpl equalPredicate;
        protected InPredicateImpl inPredicate;
        protected Boolean lowerBoundStrict = null;
        protected Boolean upperBoundStrict = null;
        protected boolean equalBound = false;
        protected boolean inBound = false;
        protected boolean lastLowerBoundColumn = false;
        protected boolean lastUpperBoundColumn = false;

        protected boolean hasLowerBound() {
            return this.lowerBoundPredicate != null || this.equalPredicate != null || this.inPredicate != null;
        }

        public void operationSetAllBounds(QueryExecutionContext context, IndexScanOperation op) {
            this.inPredicate.operationSetAllBounds(context, op);
        }

        public int getParameterSize(QueryExecutionContext context) {
            return this.inPredicate.getParameterSize(context);
        }

        protected boolean hasUpperBound() {
            return this.upperBoundPredicate != null || this.equalPredicate != null || this.inPredicate != null;
        }

        protected boolean hasInBound() {
            return this.inBound;
        }

        private CandidateColumnImpl(AbstractDomainFieldHandlerImpl domainFieldHandler) {
            this.domainFieldHandler = domainFieldHandler;
        }

        private void markLastLowerBoundColumn() {
            this.lastLowerBoundColumn = true;
        }

        private void markLastUpperBoundColumn() {
            this.lastUpperBoundColumn = true;
        }

        private void markLowerBound(PredicateImpl predicate, boolean strict) {
            this.lowerBoundStrict = strict;
            this.lowerBoundPredicate = predicate;
            this.predicate = predicate;
        }

        private void markUpperBound(PredicateImpl predicate, boolean strict) {
            this.upperBoundStrict = strict;
            this.upperBoundPredicate = predicate;
            this.predicate = predicate;
        }

        private void markEqualBound(PredicateImpl predicate) {
            this.equalBound = true;
            this.equalPredicate = predicate;
            this.predicate = predicate;
        }

        public void markInBound(InPredicateImpl predicate) {
            this.inBound = true;
            this.inPredicate = predicate;
            this.predicate = predicate;
        }

        private int operationSetBounds(QueryExecutionContext context, IndexScanOperation op, int index, int boundStatus) {
            if (this.inPredicate != null && index == -1 || !CandidateIndexImpl.this.canBound) {
                return 3;
            }
            int boundSet = PredicateImpl.NO_BOUND_SET;
            if (logger.isDetailEnabled()) {
                logger.detail("column: " + this.domainFieldHandler.getName() + " boundStatus: " + boundStatus + " lastLowerBoundColumn: " + this.lastLowerBoundColumn + " lastUpperBoundColumn: " + this.lastUpperBoundColumn);
            }
            switch (boundStatus) {
                case 3: {
                    return 3;
                }
                case 0: {
                    if (this.equalPredicate != null) {
                        boundSet |= this.equalPredicate.operationSetBounds(context, op, true);
                    }
                    if (this.inPredicate != null) {
                        boundSet |= this.inPredicate.operationSetBound(context, op, index, true);
                    }
                    if (this.lowerBoundPredicate != null) {
                        boundSet |= this.lowerBoundPredicate.operationSetLowerBound(context, op, this.lastLowerBoundColumn);
                    }
                    if (this.upperBoundPredicate == null) break;
                    boundSet |= this.upperBoundPredicate.operationSetUpperBound(context, op, this.lastUpperBoundColumn);
                    break;
                }
                case 1: {
                    if (this.equalPredicate != null) {
                        boundSet |= this.equalPredicate.operationSetUpperBound(context, op, this.lastUpperBoundColumn);
                    }
                    if (this.inPredicate != null) {
                        boundSet |= this.inPredicate.operationSetUpperBound(context, op, index);
                    }
                    if (this.upperBoundPredicate == null) break;
                    boundSet |= this.upperBoundPredicate.operationSetUpperBound(context, op, this.lastUpperBoundColumn);
                    break;
                }
                case 2: {
                    if (this.equalPredicate != null) {
                        boundSet |= this.equalPredicate.operationSetLowerBound(context, op, this.lastLowerBoundColumn);
                    }
                    if (this.inPredicate != null) {
                        boundSet |= this.inPredicate.operationSetLowerBound(context, op, index);
                    }
                    if (this.lowerBoundPredicate == null) break;
                    boundSet |= this.lowerBoundPredicate.operationSetLowerBound(context, op, this.lastLowerBoundColumn);
                }
            }
            if (0 == (boundSet & PredicateImpl.LOWER_BOUND_SET)) {
                boundStatus |= 1;
            }
            if (0 == (boundSet & PredicateImpl.UPPER_BOUND_SET)) {
                boundStatus |= 2;
            }
            return boundStatus;
        }

        private void operationSetKeys(QueryExecutionContext context, Operation op) {
            this.equalPredicate.operationEqual(context, op);
        }
    }
}

