/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClusterJTest
extends TestCase {
    static final Logger logger = LoggerFactoryService.getFactory().getInstance("com.mysql.clusterj.test");
    protected static final String JDBC_DRIVER_NAME = "jdbc.driverName";
    protected static final String JDBC_URL = "jdbc.url";
    protected static Connection connection;
    protected static String jdbcDriverName;
    protected static String jdbcPassword;
    protected static String jdbcURL;
    protected static String jdbcUsername;
    protected static Properties props;
    protected static List<String> schemaDefinition;
    protected static boolean schemaInitialized;
    String PROPS_FILE_NAME = System.getProperty("clusterj.properties", "clusterj.properties");
    protected Session session;
    protected SessionFactory sessionFactory;
    protected Transaction tx;
    protected StringBuffer errorMessages;
    private Collection<Class<?>> tearDownClasses = new LinkedList();
    private Collection<Object> tearDownInstances = new LinkedList<Object>();
    private String NL = "\n";
    protected boolean debug = this.getDebug();

    protected boolean getDebug() {
        return false;
    }

    protected void addTearDownClasses(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.tearDownClasses.add(cls);
        }
    }

    protected void createSessionFactory() {
        if (this.sessionFactory == null) {
            this.loadProperties();
            Properties modifiedProperties = this.modifyProperties();
            if (this.debug) {
                System.out.println("createSessionFactory props: " + modifiedProperties);
            }
            this.sessionFactory = ClusterJHelper.getSessionFactory((Map)modifiedProperties);
            this.loadSchema();
        }
    }

    protected Properties modifyProperties() {
        return props;
    }

    public void createSession() {
        if (this.session != null && !this.session.isClosed()) {
            this.tx = this.session.currentTransaction();
            if (this.tx.isActive()) {
                this.tx.commit();
            }
            this.session.close();
        }
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
    }

    protected void dumpSystemProperties() {
        Properties sysprops = System.getProperties();
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(sysprops.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                return ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey());
            }
        });
        for (Map.Entry entry : entries) {
            System.out.println("key: " + entry.getKey() + "; value: " + entry.getValue());
        }
    }

    protected void error(String message) {
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
    }

    protected void error(String context, Exception ex) {
        String message = context + " " + ex.getClass().getName() + ":" + ex.getMessage();
        this.error(message);
        if (this.getDebug()) {
            ex.printStackTrace();
        }
    }

    protected void errorIfNotEqual(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
        this.errorMessages.append("Expected: " + (expected == null ? "null" : expected.toString()) + " actual: " + (actual == null ? "null" : actual.toString()) + this.NL);
    }

    protected void errorIfNotEqual(String message, int[] expected, int[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected.length == actual.length) {
            int i;
            for (i = 0; i < expected.length && expected[i] == actual[i]; ++i) {
            }
            if (i == expected.length) {
                return;
            }
        }
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
        this.errorMessages.append("Expected: " + (expected == null ? "null" : Arrays.toString(expected)) + " actual: " + (actual == null ? "null" : Arrays.toString(actual)) + this.NL);
    }

    protected void errorIfEqual(String message, Object expected, Object actual) {
        if (expected == null && actual != null) {
            return;
        }
        if (expected != null && !expected.equals(actual)) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(message + this.NL);
        this.errorMessages.append("Error value: " + (expected == null ? "null" : expected.toString()));
    }

    protected void failOnError() {
        if (this.errorMessages != null) {
            AbstractClusterJTest.fail((String)this.errorMessages.toString());
        }
    }

    protected void closeConnection() {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Caught SQLException during close.", e);
        }
        finally {
            connection = null;
        }
    }

    protected void getConnection(Properties extraProperties) {
        Properties properties = new Properties();
        properties.put("user", jdbcUsername);
        properties.put("password", jdbcPassword);
        properties.putAll((Map<?, ?>)extraProperties);
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
                connection = null;
            }
            if (this.debug) {
                System.out.println("Getting new connection with properties " + properties);
            }
            connection = DriverManager.getConnection(jdbcURL, properties);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new ClusterJException("Exception getting connection to " + jdbcURL + "; username " + jdbcUsername, (Throwable)ex);
        }
    }

    protected Connection getConnection() {
        if (connection == null) {
            try {
                Class.forName(jdbcDriverName, true, Thread.currentThread().getContextClassLoader());
                connection = DriverManager.getConnection(jdbcURL, jdbcUsername, jdbcPassword);
            }
            catch (SQLException ex) {
                throw new ClusterJException("Exception getting connection to " + jdbcURL + "; username " + jdbcUsername, (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new ClusterJException("Exception loading JDBC driver." + jdbcDriverName, (Throwable)ex);
            }
        }
        return connection;
    }

    protected void getConnection(String propertiesFileName) {
        this.loadProperties(propertiesFileName);
        this.loadDriver();
        String url = props.getProperty(JDBC_URL);
        try {
            connection = DriverManager.getConnection(url);
            this.setAutoCommit(connection, false);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get Connection: " + url, e);
        }
    }

    protected void loadDriver() {
        String driverName = props.getProperty(JDBC_DRIVER_NAME);
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + driverName, e);
        }
    }

    protected void setAutoCommit(Connection connection, boolean b) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException("setAutoCommit failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSQL(String sql) {
        Statement statement = null;
        try {
            boolean autoCommit = connection.getAutoCommit();
            if (!autoCommit) {
                connection.setAutoCommit(true);
            }
            statement = connection.createStatement();
            statement.execute(sql);
            if (!autoCommit) {
                connection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            this.error("Caught " + e.getClass() + " trying: " + sql);
            if (statement == null) {
                this.error(this.analyzeWarnings(connection));
            } else {
                this.error(this.analyzeWarnings(statement));
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.error("Error closing statement " + sql);
                }
            }
        }
    }

    protected String analyzeWarnings(Connection connection) {
        SQLWarning warning = null;
        StringBuilder builder = new StringBuilder();
        try {
            warning = connection.getWarnings();
            this.analyzeWarnings(warning, builder);
        }
        catch (SQLException e) {
            builder.append("Error getting warnings from connection:\n");
            builder.append(e.getMessage());
        }
        return builder.toString();
    }

    protected String analyzeWarnings(Statement statement) {
        SQLWarning warning = null;
        StringBuilder builder = new StringBuilder();
        try {
            warning = statement.getWarnings();
            this.analyzeWarnings(warning, builder);
        }
        catch (SQLException e) {
            builder.append("Error getting warnings from statement:\n");
            builder.append(e.getMessage());
        }
        return builder.toString();
    }

    protected StringBuilder analyzeWarnings(SQLWarning warning, StringBuilder builder) {
        if (warning != null) {
            builder.append(warning.getMessage());
            builder.append("\n");
            this.analyzeWarnings(warning.getNextWarning(), builder);
        }
        return builder;
    }

    Properties getProperties(String fileName) {
        Properties result = null;
        try {
            FileInputStream stream = new FileInputStream(new File(fileName));
            result = new Properties();
            result.load(stream);
            return result;
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (result == null) {
            try {
                ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
                InputStream stream = cl.getResourceAsStream(fileName);
                result = new Properties();
                result.load(stream);
                return result;
            }
            catch (IOException ex) {
                AbstractClusterJTest.fail((String)("Could not create ConnectionFactory " + ex));
            }
            catch (NullPointerException ex) {
                AbstractClusterJTest.fail((String)("Missing properties file " + fileName));
            }
        }
        return null;
    }

    protected void initializeErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new StringBuffer();
            this.errorMessages.append(this.NL);
        }
    }

    protected void initializeJDBC() {
        this.loadProperties();
        this.getConnection();
    }

    protected void initializeSchema() {
        this.getConnection();
        Iterator<String> it = schemaDefinition.iterator();
        it.next();
        it.next();
        String statement = null;
        try {
            while (it.hasNext()) {
                statement = it.next();
                if (this.debug) {
                    System.out.println("Executing statement " + statement + ";");
                }
                PreparedStatement s = connection.prepareStatement(statement);
                s.execute();
                s.close();
            }
            schemaInitialized = true;
            System.out.println("Successfully initialized schema.");
        }
        catch (SQLException ex) {
            this.resetSchema();
            throw new ClusterJException("initializeSchema threw exception on " + statement, (Throwable)ex);
        }
    }

    protected void loadProperties() {
        this.loadProperties(this.PROPS_FILE_NAME);
    }

    protected void loadProperties(String propsFileName) {
        props = this.getProperties(propsFileName);
        jdbcDriverName = props.getProperty("com.mysql.clusterj.jdbc.driver");
        jdbcURL = props.getProperty("com.mysql.clusterj.jdbc.url");
        jdbcUsername = props.getProperty("com.mysql.clusterj.jdbc.username");
        jdbcPassword = props.getProperty("com.mysql.clusterj.jdbc.password");
        if (jdbcPassword == null) {
            jdbcPassword = "";
        }
    }

    protected void loadSchema() {
        this.initializeJDBC();
        if (!schemaInitialized) {
            this.loadSchemaDefinition();
            if (!this.testSchema()) {
                this.initializeSchema();
            }
        }
    }

    protected void loadSchemaDefinition() {
        InputStream inputStream = null;
        StringBuffer buffer = new StringBuffer();
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema.sql");
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.contains("#")) continue;
                int semi = line.indexOf(";");
                if (semi != -1) {
                    buffer.append(line.substring(0, semi));
                    schemaDefinition.add(buffer.toString());
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(line);
            }
        }
        catch (IOException ex) {
            throw new ClusterJException("Exception reading schema.sql.", (Throwable)ex);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    protected void localSetUp() {
    }

    protected void localTearDown() {
    }

    protected final void setUp() throws Exception {
        this.localSetUp();
    }

    protected final void tearDown() throws Exception {
        this.localTearDown();
        if (this.session != null && !this.session.isClosed()) {
            if (this.tx == null) {
                this.tx = this.session.currentTransaction();
            }
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            if (!this.tearDownClasses.isEmpty() | !this.tearDownInstances.isEmpty()) {
                this.tx.begin();
                for (Class<?> cls : this.tearDownClasses) {
                    this.session.deletePersistentAll(cls);
                }
                for (Object o : this.tearDownInstances) {
                    this.session.deletePersistent(o);
                }
                this.tx.commit();
                this.session.close();
                this.session = null;
            }
        }
        this.session = null;
        this.sessionFactory = null;
    }

    protected void removeAll(Class<?> cls) {
        this.sessionFactory.getSession();
        this.session.currentTransaction().begin();
        this.session.deletePersistentAll(cls);
        this.session.currentTransaction().commit();
    }

    protected boolean testSchema() {
        try {
            Statement statement = connection.createStatement();
            statement.execute(schemaDefinition.get(1));
            statement.close();
            return true;
        }
        catch (SQLException ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            System.out.println("Test schema failed (normal) " + schemaDefinition.get(1));
            return false;
        }
    }

    protected boolean resetSchema() {
        try {
            Statement statement = connection.createStatement();
            statement.execute(schemaDefinition.get(0));
            statement.close();
            return true;
        }
        catch (SQLException ex) {
            System.out.println("Test schema failed (normal) " + schemaDefinition.get(0));
            return false;
        }
    }

    protected static String dump(String string) {
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < string.length(); ++i) {
            char theCharacter = string.charAt(i);
            buffer.append((int)theCharacter);
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected String dump(List<String> list) {
        StringBuffer result = new StringBuffer();
        for (String string : list) {
            result.append(AbstractClusterJTest.dump(string));
            result.append('\n');
        }
        return result.toString();
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuffer buffer = new StringBuffer("byte[");
        buffer.append(bytes.length);
        buffer.append("]: [");
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(bytes[i]);
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String dump(Object object) {
        if (object instanceof byte[]) {
            return AbstractClusterJTest.dumpBytes((byte[])object);
        }
        return object.toString();
    }

    static {
        schemaDefinition = new ArrayList<String>();
        schemaInitialized = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static List<Throwable> uncaughtExceptions = new ArrayList<Throwable>();

        public List<Throwable> getUncaughtExceptions() {
            return uncaughtExceptions;
        }

        @Override
        public synchronized void uncaughtException(Thread t, Throwable e) {
            uncaughtExceptions.add(e);
        }
    }
}

