/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.OperationImpl;
import com.mysql.clusterj.tie.ScanFilterImpl;
import com.mysql.clusterj.tie.ScanResultDataImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;

class ScanOperationImpl
extends OperationImpl
implements ScanOperation {
    private NdbScanOperation ndbScanOperation;
    private Query.Ordering ordering = null;

    ScanOperationImpl(Table storeTable, NdbScanOperation operation, ClusterTransactionImpl clusterTransaction) {
        super(storeTable, operation, clusterTransaction);
        this.ndbScanOperation = operation;
    }

    public void close() {
        this.ndbScanOperation.close(true, true);
    }

    public void deleteCurrentTuple() {
        int returnCode = this.ndbScanOperation.deleteCurrentTuple();
        this.handleError(returnCode, this.ndbScanOperation);
    }

    public ScanFilter getScanFilter(QueryExecutionContext context) {
        NdbScanFilter ndbScanFilter = NdbScanFilter.create(this.ndbScanOperation);
        ScanOperationImpl.handleError(ndbScanFilter, this.ndbScanOperation);
        ScanFilterImpl scanFilter = new ScanFilterImpl(ndbScanFilter);
        context.addFilter(scanFilter);
        return scanFilter;
    }

    public int nextResult(boolean fetch) {
        int result = this.ndbScanOperation.nextResult(fetch, false);
        this.clusterTransaction.handleError(result);
        return result;
    }

    public ResultData resultData() {
        return this.resultData(true, 0L, Long.MAX_VALUE);
    }

    public ResultData resultData(boolean execute, long skip, long limit) {
        ScanResultDataImpl result = new ScanResultDataImpl(this.ndbScanOperation, this.storeColumns, this.maximumColumnId, this.bufferSize, this.offsets, this.lengths, this.maximumColumnLength, this.bufferManager, skip, limit);
        this.clusterTransaction.executeNoCommit(false, true);
        return result;
    }

    protected void handleError(int returnCode, NdbOperation ndbOperation) {
        if (returnCode == 0) {
            return;
        }
        NdbErrorConst ndbError = ndbOperation.getNdbError();
        if (ndbError != null) {
            Utility.throwError(returnCode, ndbError);
        } else {
            this.clusterTransaction.handleError(returnCode);
        }
    }

    public void setOrdering(Query.Ordering ordering) {
        this.ordering = ordering;
    }
}

