/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.NdbRecordBlobImpl;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NdbRecordOperationImpl
implements Operation {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordOperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordOperationImpl.class);
    protected ClusterTransactionImpl clusterTransaction = null;
    protected NdbOperationConst ndbOperation = null;
    protected NdbRecordImpl ndbRecordKeys = null;
    protected NdbRecordImpl ndbRecordValues = null;
    byte[] mask;
    ByteBuffer keyBuffer = null;
    ByteBuffer valueBuffer = null;
    protected NdbRecordBlobImpl[] blobs = null;
    protected List<NdbRecordBlobImpl> activeBlobs = new ArrayList<NdbRecordBlobImpl>();
    protected int keyBufferSize;
    protected int valueBufferSize;
    protected DbImpl.BufferManager bufferManager;
    protected String tableName;
    protected Table storeTable;
    protected Column[] storeColumns;
    int numberOfColumns;
    protected DbImpl db;

    public NdbRecordOperationImpl(ClusterConnectionImpl clusterConnection, Db db, Table storeTable) {
        this.db = (DbImpl)db;
        this.storeTable = storeTable;
        this.tableName = storeTable.getName();
        this.ndbRecordKeys = this.ndbRecordValues = clusterConnection.getCachedNdbRecordImpl(storeTable);
        this.valueBufferSize = this.ndbRecordValues.getBufferSize();
        this.keyBufferSize = this.ndbRecordKeys.getBufferSize();
        this.keyBuffer = this.valueBuffer = this.ndbRecordValues.newBuffer();
        this.storeColumns = this.ndbRecordValues.storeColumns;
        this.numberOfColumns = this.storeColumns.length;
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.bufferManager = ((DbImpl)db).getBufferManager();
        this.resetMask();
    }

    public NdbRecordOperationImpl(ClusterTransactionImpl clusterTransaction, Table storeTable) {
        this.clusterTransaction = clusterTransaction;
        this.db = clusterTransaction.db;
        this.bufferManager = clusterTransaction.getBufferManager();
        this.tableName = storeTable.getName();
        this.ndbRecordValues = clusterTransaction.getCachedNdbRecordImpl(storeTable);
        this.valueBufferSize = this.ndbRecordValues.getBufferSize();
        this.valueBuffer = this.ndbRecordValues.newBuffer();
        this.numberOfColumns = this.ndbRecordValues.getNumberOfColumns();
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.resetMask();
    }

    public NdbRecordOperationImpl(NdbRecordOperationImpl ndbRecordOperationImpl2) {
        this.ndbRecordValues = ndbRecordOperationImpl2.ndbRecordValues;
        this.valueBufferSize = ndbRecordOperationImpl2.valueBufferSize;
        this.ndbRecordKeys = this.ndbRecordValues;
        this.keyBufferSize = this.ndbRecordKeys.bufferSize;
        this.keyBuffer = this.valueBuffer = ndbRecordOperationImpl2.valueBuffer;
        this.bufferManager = ndbRecordOperationImpl2.bufferManager;
        this.tableName = ndbRecordOperationImpl2.tableName;
        this.storeColumns = ndbRecordOperationImpl2.ndbRecordValues.storeColumns;
        this.numberOfColumns = this.storeColumns.length;
        this.blobs = new NdbRecordBlobImpl[this.numberOfColumns];
        this.activeBlobs = ndbRecordOperationImpl2.activeBlobs;
        this.resetMask();
    }

    public NdbOperationConst insert(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.insertTuple(this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        clusterTransactionImpl.addOperationToCheck(this);
        for (NdbRecordBlobImpl blob : this.activeBlobs) {
            blob.setNdbBlob();
            blob.setValue();
        }
        return this.ndbOperation;
    }

    public NdbOperationConst delete(ClusterTransactionImpl clusterTransactionImpl) {
        this.keyBuffer.limit(this.keyBufferSize);
        this.keyBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.deleteTuple(this.ndbRecordKeys.getNdbRecord(), this.keyBuffer, this.mask, null);
        return this.ndbOperation;
    }

    public void update(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.updateTuple(this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        clusterTransactionImpl.addOperationToCheck(this);
        for (NdbRecordBlobImpl blob : this.activeBlobs) {
            blob.setNdbBlob();
            blob.setValue();
        }
    }

    public void write(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.writeTuple(this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        clusterTransactionImpl.addOperationToCheck(this);
        for (NdbRecordBlobImpl blob : this.activeBlobs) {
            blob.setNdbBlob();
            blob.setValue();
        }
    }

    public void load(ClusterTransactionImpl clusterTransactionImpl) {
        this.valueBuffer.limit(this.valueBufferSize);
        this.valueBuffer.position(0);
        this.ndbOperation = clusterTransactionImpl.readTuple(this.ndbRecordKeys.getNdbRecord(), this.keyBuffer, this.ndbRecordValues.getNdbRecord(), this.valueBuffer, this.mask, null);
        for (NdbRecordBlobImpl blob : this.activeBlobs) {
            blob.setNdbBlob();
        }
    }

    protected void resetMask() {
        this.mask = new byte[1 + this.numberOfColumns / 8];
    }

    public void allocateValueBuffer() {
        this.valueBuffer = this.ndbRecordValues.newBuffer();
    }

    protected void activateBlobs() {
        for (NdbRecordBlobImpl blob : this.activeBlobs) {
            blob.setNdbBlob();
        }
    }

    public void equalBigInteger(Column storeColumn, BigInteger value) {
        int columnId = this.ndbRecordKeys.setBigInteger(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalBoolean(Column storeColumn, boolean booleanValue) {
        byte value = booleanValue ? (byte)1 : 0;
        this.equalByte(storeColumn, value);
    }

    public void equalByte(Column storeColumn, byte value) {
        int columnId = this.ndbRecordKeys.setByte(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalBytes(Column storeColumn, byte[] value) {
        int columnId = this.ndbRecordKeys.setBytes(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalDecimal(Column storeColumn, BigDecimal value) {
        int columnId = this.ndbRecordKeys.setDecimal(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalDouble(Column storeColumn, double value) {
        int columnId = this.ndbRecordKeys.setDouble(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalFloat(Column storeColumn, float value) {
        int columnId = this.ndbRecordKeys.setFloat(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalInt(Column storeColumn, int value) {
        int columnId = this.ndbRecordKeys.setInt(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalLong(Column storeColumn, long value) {
        int columnId = this.ndbRecordKeys.setLong(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalShort(Column storeColumn, short value) {
        int columnId = this.ndbRecordKeys.setShort(this.keyBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void equalString(Column storeColumn, String value) {
        int columnId = this.ndbRecordKeys.setString(this.keyBuffer, this.bufferManager, storeColumn, value);
        this.columnSet(columnId);
    }

    public void getBlob(Column storeColumn) {
        this.getBlobHandle(storeColumn);
    }

    public Blob getBlobHandle(Column storeColumn) {
        int columnId = storeColumn.getColumnId();
        NdbRecordBlobImpl result = this.blobs[columnId];
        if (result == null) {
            this.columnSet(columnId);
            this.blobs[columnId] = result = new NdbRecordBlobImpl(this, storeColumn);
            this.activeBlobs.add(result);
        }
        return result;
    }

    public void getValue(Column storeColumn) {
        int columnId = storeColumn.getColumnId();
        this.columnSet(columnId);
    }

    public void postExecuteCallback(Runnable callback) {
        this.clusterTransaction.postExecuteCallback(callback);
    }

    public ResultData resultData() {
        return this.resultData(true);
    }

    public ResultData resultData(boolean execute) {
        NdbRecordResultDataImpl result = new NdbRecordResultDataImpl(this);
        if (execute) {
            this.clusterTransaction.executeNoCommit(false, true);
        }
        return result;
    }

    public void setBigInteger(Column storeColumn, BigInteger value) {
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            int columnId = this.ndbRecordValues.setBigInteger(this.valueBuffer, storeColumn, value);
            this.columnSet(columnId);
        }
    }

    public void setBigInteger(int columnId, BigInteger value) {
        this.setBigInteger(this.storeColumns[columnId], value);
    }

    public void setBoolean(Column storeColumn, Boolean booleanValue) {
        byte value = booleanValue != false ? (byte)1 : 0;
        this.setByte(storeColumn, value);
    }

    public void setBoolean(int columnId, boolean value) {
        this.setBoolean(this.storeColumns[columnId], (Boolean)value);
    }

    public void setByte(Column storeColumn, byte value) {
        int columnId = this.ndbRecordValues.setByte(this.valueBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void setByte(int columnId, byte value) {
        this.setByte(this.storeColumns[columnId], value);
    }

    public void setBytes(Column storeColumn, byte[] value) {
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            int columnId = this.ndbRecordValues.setBytes(this.valueBuffer, storeColumn, value);
            this.columnSet(columnId);
        }
    }

    public void setBytes(int columnId, byte[] value) {
        this.setBytes(this.storeColumns[columnId], value);
    }

    public void setDecimal(Column storeColumn, BigDecimal value) {
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            int columnId = this.ndbRecordValues.setDecimal(this.valueBuffer, storeColumn, value);
            this.columnSet(columnId);
        }
    }

    public void setDecimal(int columnId, BigDecimal value) {
        this.setDecimal(this.storeColumns[columnId], value);
    }

    public void setDouble(Column storeColumn, Double value) {
        int columnId = this.ndbRecordValues.setDouble(this.valueBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void setDouble(int columnId, double value) {
        this.setDouble(this.storeColumns[columnId], (Double)value);
    }

    public void setFloat(Column storeColumn, Float value) {
        int columnId = this.ndbRecordValues.setFloat(this.valueBuffer, storeColumn, value.floatValue());
        this.columnSet(columnId);
    }

    public void setFloat(int columnId, float value) {
        this.setFloat(this.storeColumns[columnId], Float.valueOf(value));
    }

    public void setInt(Column storeColumn, Integer value) {
        int columnId = this.ndbRecordValues.setInt(this.valueBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void setInt(int columnId, int value) {
        this.setInt(this.storeColumns[columnId], (Integer)value);
    }

    public void setLong(Column storeColumn, long value) {
        int columnId = this.ndbRecordValues.setLong(this.valueBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void setLong(int columnId, long value) {
        this.setLong(this.storeColumns[columnId], value);
    }

    public void setNull(Column storeColumn) {
        int columnId = this.ndbRecordValues.setNull(this.valueBuffer, storeColumn);
        this.columnSet(columnId);
    }

    public void setNull(int columnId) {
        this.setNull(this.storeColumns[columnId]);
    }

    public void setShort(Column storeColumn, Short value) {
        int columnId = this.ndbRecordValues.setShort(this.valueBuffer, storeColumn, value);
        this.columnSet(columnId);
    }

    public void setShort(int columnId, short value) {
        this.setShort(this.storeColumns[columnId], (Short)value);
    }

    public void setObjectBoolean(int columnId, Boolean value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setBoolean(storeColumn, value);
        }
    }

    public void setObjectByte(int columnId, Byte value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setByte(storeColumn, (byte)value);
        }
    }

    public void setObjectDouble(int columnId, Double value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setDouble(storeColumn, value);
        }
    }

    public void setObjectFloat(int columnId, Float value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setFloat(storeColumn, value);
        }
    }

    public void setObjectInt(int columnId, Integer value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setInt(storeColumn, value);
        }
    }

    public void setObjectLong(int columnId, Long value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setLong(storeColumn, (long)value);
        }
    }

    public void setObjectShort(int columnId, Short value) {
        Column storeColumn = this.storeColumns[columnId];
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            this.setShort(storeColumn, value);
        }
    }

    public void setString(Column storeColumn, String value) {
        if (value == null) {
            this.setNull(storeColumn);
        } else {
            int columnId = this.ndbRecordValues.setString(this.valueBuffer, this.bufferManager, storeColumn, value);
            this.columnSet(columnId);
        }
    }

    public void setString(int columnId, String value) {
        this.setString(this.storeColumns[columnId], value);
    }

    public int errorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    protected static void handleError(int returnCode, NdbOperationConst ndbOperation2) {
        if (returnCode == 0) {
            return;
        }
        Utility.throwError(returnCode, ndbOperation2.getNdbError());
    }

    protected static void handleError(Object object, NdbOperationConst ndbOperation) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperation.getNdbError());
    }

    protected static void handleError(Object object, NdbDictionary.Dictionary ndbDictionary) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbDictionary.getNdbError());
    }

    public NdbBlob getNdbBlob(Column storeColumn) {
        NdbBlob result = this.ndbOperation.getBlobHandle(storeColumn.getColumnId());
        NdbRecordOperationImpl.handleError((Object)result, this.ndbOperation);
        return result;
    }

    protected void columnSet(int columnId) {
        int byteOffset = columnId / 8;
        int bitInByte = columnId - byteOffset * 8;
        int n = byteOffset;
        this.mask[n] = (byte)(this.mask[n] | NdbRecordImpl.BIT_IN_BYTE_MASK[bitInByte]);
    }

    public NdbRecordImpl getValueNdbRecord() {
        return this.ndbRecordValues;
    }

    public boolean getBoolean(int columnId) {
        return this.ndbRecordValues.getBoolean(this.valueBuffer, columnId);
    }

    public boolean getBoolean(Column storeColumn) {
        return this.ndbRecordValues.getBoolean(this.valueBuffer, storeColumn.getColumnId());
    }

    public boolean[] getBooleans(int column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getBooleans(int)"));
    }

    public boolean[] getBooleans(Column storeColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getBooleans(Column)"));
    }

    public byte getByte(int columnId) {
        return this.ndbRecordValues.getByte(this.valueBuffer, columnId);
    }

    public byte getByte(Column storeColumn) {
        return this.ndbRecordValues.getByte(this.valueBuffer, storeColumn.getColumnId());
    }

    public short getShort(int columnId) {
        return this.ndbRecordValues.getShort(this.valueBuffer, columnId);
    }

    public short getShort(Column storeColumn) {
        return this.ndbRecordValues.getShort(this.valueBuffer, storeColumn.getColumnId());
    }

    public int getInt(int columnId) {
        return this.ndbRecordValues.getInt(this.valueBuffer, columnId);
    }

    public int getInt(Column storeColumn) {
        return this.getInt(storeColumn.getColumnId());
    }

    public long getLong(int columnId) {
        return this.ndbRecordValues.getLong(this.valueBuffer, columnId);
    }

    public float getFloat(int columnId) {
        return this.ndbRecordValues.getFloat(this.valueBuffer, columnId);
    }

    public float getFloat(Column storeColumn) {
        return this.getFloat(storeColumn.getColumnId());
    }

    public double getDouble(int columnId) {
        return this.ndbRecordValues.getDouble(this.valueBuffer, columnId);
    }

    public double getDouble(Column storeColumn) {
        return this.getDouble(storeColumn.getColumnId());
    }

    public String getString(int columnId) {
        return this.ndbRecordValues.getString(this.valueBuffer, columnId, this.bufferManager);
    }

    public String getString(Column storeColumn) {
        return this.ndbRecordValues.getString(this.valueBuffer, storeColumn.getColumnId(), this.bufferManager);
    }

    public byte[] getBytes(int column) {
        return this.ndbRecordValues.getBytes(this.valueBuffer, column);
    }

    public byte[] getBytes(Column storeColumn) {
        return this.ndbRecordValues.getBytes(this.valueBuffer, storeColumn);
    }

    public Object getObject(int column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getObject(int)"));
    }

    public Object getObject(Column storeColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.getObject(Column)"));
    }

    public boolean wasNull(Column storeColumn) {
        throw new ClusterJFatalInternalException(local.message("ERR_Method_Not_Implemented", (Object)"NdbRecordResultDataImpl.wasNull(Column)"));
    }

    public Boolean getObjectBoolean(int column) {
        return this.ndbRecordValues.getObjectBoolean(this.valueBuffer, column);
    }

    public Boolean getObjectBoolean(Column storeColumn) {
        return this.ndbRecordValues.getObjectBoolean(this.valueBuffer, storeColumn.getColumnId());
    }

    public Byte getObjectByte(int columnId) {
        return this.ndbRecordValues.getObjectByte(this.valueBuffer, columnId);
    }

    public Byte getObjectByte(Column storeColumn) {
        return this.ndbRecordValues.getObjectByte(this.valueBuffer, storeColumn.getColumnId());
    }

    public Float getObjectFloat(int column) {
        return this.ndbRecordValues.getObjectFloat(this.valueBuffer, column);
    }

    public Float getObjectFloat(Column storeColumn) {
        return this.ndbRecordValues.getObjectFloat(this.valueBuffer, storeColumn.getColumnId());
    }

    public Double getObjectDouble(int column) {
        return this.ndbRecordValues.getObjectDouble(this.valueBuffer, column);
    }

    public Double getObjectDouble(Column storeColumn) {
        return this.ndbRecordValues.getObjectDouble(this.valueBuffer, storeColumn.getColumnId());
    }

    public Integer getObjectInteger(int columnId) {
        return this.ndbRecordValues.getObjectInteger(this.valueBuffer, columnId);
    }

    public Integer getObjectInteger(Column storeColumn) {
        return this.ndbRecordValues.getObjectInteger(this.valueBuffer, storeColumn.getColumnId());
    }

    public Long getObjectLong(int column) {
        return this.ndbRecordValues.getObjectLong(this.valueBuffer, column);
    }

    public Long getObjectLong(Column storeColumn) {
        return this.ndbRecordValues.getObjectLong(this.valueBuffer, storeColumn.getColumnId());
    }

    public Short getObjectShort(int columnId) {
        return this.ndbRecordValues.getObjectShort(this.valueBuffer, columnId);
    }

    public Short getObjectShort(Column storeColumn) {
        return this.ndbRecordValues.getObjectShort(this.valueBuffer, storeColumn.getColumnId());
    }

    public BigInteger getBigInteger(int column) {
        return this.ndbRecordValues.getBigInteger(this.valueBuffer, column);
    }

    public BigInteger getBigInteger(Column storeColumn) {
        return this.ndbRecordValues.getBigInteger(this.valueBuffer, storeColumn);
    }

    public BigDecimal getDecimal(int column) {
        return this.ndbRecordValues.getDecimal(this.valueBuffer, column);
    }

    public BigDecimal getDecimal(Column storeColumn) {
        return this.ndbRecordValues.getDecimal(this.valueBuffer, storeColumn);
    }

    public void beginDefinition() {
    }

    public void endDefinition() {
    }

    public void freeResourcesAfterExecute() {
    }

    public String dumpValues() {
        return this.ndbRecordValues.dumpValues(this.valueBuffer, this.mask);
    }

    public String dumpKeys() {
        return this.ndbRecordKeys.dumpValues(this.keyBuffer, null);
    }

    public boolean isModified(int columnId) {
        return this.ndbRecordValues.isPresent(this.mask, columnId);
    }

    public boolean isNull(int columnId) {
        return this.ndbRecordValues.isNull(this.valueBuffer, columnId);
    }

    public void markModified(int columnId) {
        this.ndbRecordValues.markPresent(this.mask, columnId);
    }

    public void resetModified() {
        this.mask = new byte[1 + this.numberOfColumns / 8];
    }

    public NdbRecordBlobImpl getBlobHandle(int columnId) {
        return (NdbRecordBlobImpl)this.getBlobHandle(this.storeColumns[columnId]);
    }

    public int getErrorCode() {
        return this.ndbOperation.getNdbError().code();
    }

    public int getClassification() {
        return this.ndbOperation.getNdbError().classification();
    }

    public int getMysqlCode() {
        return this.ndbOperation.getNdbError().mysql_code();
    }

    public int getStatus() {
        return this.ndbOperation.getNdbError().status();
    }

    public String toString() {
        return this.tableName;
    }

    public void loadBlobValues() {
        for (NdbRecordBlobImpl ndbRecordBlobImpl : this.activeBlobs) {
            ndbRecordBlobImpl.readData();
        }
    }

    public NdbRecordOperationImpl transformNdbRecordOperationImpl() {
        this.keyBuffer = this.valueBuffer;
        this.resetModified();
        return this;
    }
}

