/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordScanOperationImpl;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NdbRecordIndexScanOperationImpl
extends NdbRecordScanOperationImpl
implements IndexScanOperation {
    private NdbIndexScanOperation ndbIndexScanOperation;
    private int indexBoundRange = 0;
    private ByteBuffer indexBoundLowBuffer = null;
    private int indexBoundLowCount = 0;
    private boolean indexBoundLowStrict = false;
    private ByteBuffer indexBoundHighBuffer = null;
    private int indexBoundHighCount = 0;
    private boolean indexBoundHighStrict = false;
    private boolean equalScan = true;
    List<NdbIndexScanOperation.IndexBound> ndbIndexBoundList = null;
    NdbIndexScanOperation.IndexBound ndbIndexBound = null;
    List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private Index index;

    public NdbRecordIndexScanOperationImpl(ClusterTransactionImpl clusterTransaction, Index storeIndex, Table storeTable, int lockMode) {
        this(clusterTransaction, storeIndex, storeTable, false, lockMode);
    }

    public NdbRecordIndexScanOperationImpl(ClusterTransactionImpl clusterTransaction, Index storeIndex, Table storeTable, boolean multiRange, int lockMode) {
        super(clusterTransaction, storeTable, lockMode);
        this.index = storeIndex;
        this.multiRange = multiRange;
        if (this.multiRange) {
            this.ndbIndexBoundList = new ArrayList<NdbIndexScanOperation.IndexBound>();
        }
        this.ndbRecordKeys = clusterTransaction.getCachedNdbRecordImpl(storeIndex, storeTable);
        this.keyBufferSize = this.ndbRecordKeys.bufferSize;
        this.indexBoundLowBuffer = this.ndbRecordKeys.newBuffer();
        this.buffers.add(this.indexBoundLowBuffer);
        this.indexBoundHighBuffer = this.ndbRecordKeys.newBuffer();
        this.buffers.add(this.indexBoundHighBuffer);
    }

    public void endDefinition() {
        this.getScanOptions();
        if (logger.isDetailEnabled()) {
            logger.detail("scan index '" + this.index.getName() + "' with options " + this.dumpScanOptions(this.scanOptions.optionsPresent(), this.scanOptions.scan_flags()));
        }
        this.ndbIndexScanOperation = this.clusterTransaction.scanIndex(this.ndbRecordKeys.getNdbRecord(), this.ndbRecordValues.getNdbRecord(), this.mask, this.scanOptions);
        this.ndbOperation = this.ndbIndexScanOperation;
        if (this.ndbIndexBoundList != null) {
            if (logger.isDetailEnabled()) {
                logger.detail("list size " + this.ndbIndexBoundList.size());
            }
            for (NdbIndexScanOperation.IndexBound ndbIndexBound : this.ndbIndexBoundList) {
                int returnCode = this.ndbIndexScanOperation.setBound(this.ndbRecordKeys.getNdbRecord(), ndbIndexBound);
                NdbRecordIndexScanOperationImpl.handleError(returnCode, (NdbOperationConst)this.ndbIndexScanOperation);
            }
        } else {
            this.ndbIndexBound = this.getNdbIndexBound();
            if (this.ndbIndexBound != null) {
                int returnCode = this.ndbIndexScanOperation.setBound(this.ndbRecordKeys.getNdbRecord(), this.ndbIndexBound);
                NdbRecordIndexScanOperationImpl.handleError(returnCode, (NdbOperationConst)this.ndbIndexScanOperation);
            }
        }
        this.clusterTransaction.postExecuteCallback(new Runnable(){

            public void run() {
                NdbRecordIndexScanOperationImpl.this.freeResourcesAfterExecute();
            }
        });
    }

    public void setBoundBigInteger(Column storeColumn, IndexScanOperation.BoundType type, BigInteger value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setBigInteger(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setBigInteger(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setBigInteger(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundByte(Column storeColumn, IndexScanOperation.BoundType type, byte value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setByte(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setByte(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setByte(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundBytes(Column storeColumn, IndexScanOperation.BoundType type, byte[] value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setBytes(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setBytes(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setBytes(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundDecimal(Column storeColumn, IndexScanOperation.BoundType type, BigDecimal value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setDecimal(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setDecimal(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setDecimal(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundDouble(Column storeColumn, IndexScanOperation.BoundType type, Double value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setDouble(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setDouble(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setDouble(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundFloat(Column storeColumn, IndexScanOperation.BoundType type, Float value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setFloat(this.indexBoundLowBuffer, storeColumn, value.floatValue());
            this.ndbRecordKeys.setFloat(this.indexBoundHighBuffer, storeColumn, value.floatValue());
        } else {
            this.ndbRecordKeys.setFloat(keyBuffer, storeColumn, value.floatValue());
        }
    }

    public void setBoundShort(Column storeColumn, IndexScanOperation.BoundType type, short value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setShort(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setShort(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setShort(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundInt(Column storeColumn, IndexScanOperation.BoundType type, Integer value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setInt(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setInt(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setInt(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundLong(Column storeColumn, IndexScanOperation.BoundType type, long value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setLong(this.indexBoundLowBuffer, storeColumn, value);
            this.ndbRecordKeys.setLong(this.indexBoundHighBuffer, storeColumn, value);
        } else {
            this.ndbRecordKeys.setLong(keyBuffer, storeColumn, value);
        }
    }

    public void setBoundString(Column storeColumn, IndexScanOperation.BoundType type, String value) {
        ByteBuffer keyBuffer;
        if (logger.isDetailEnabled()) {
            logger.detail(storeColumn.getName() + " " + (Object)((Object)type) + " " + value);
        }
        if ((keyBuffer = this.assignBoundBuffer(type)) == null) {
            this.ndbRecordKeys.setString(this.indexBoundLowBuffer, this.bufferManager, storeColumn, value);
            this.ndbRecordKeys.setString(this.indexBoundHighBuffer, this.bufferManager, storeColumn, value);
        } else {
            this.ndbRecordKeys.setString(keyBuffer, this.bufferManager, storeColumn, value);
        }
    }

    public void endBound(int rangeNumber) {
        if (logger.isDetailEnabled()) {
            logger.detail("range: " + rangeNumber);
        }
        this.indexBoundRange = rangeNumber;
        this.ndbIndexBoundList.add(this.getNdbIndexBound());
    }

    private ByteBuffer assignBoundBuffer(IndexScanOperation.BoundType type) {
        switch (type) {
            case BoundEQ: {
                ++this.indexBoundHighCount;
                ++this.indexBoundLowCount;
                return null;
            }
            case BoundGE: {
                this.equalScan = false;
                ++this.indexBoundHighCount;
                return this.indexBoundHighBuffer;
            }
            case BoundGT: {
                this.equalScan = false;
                this.indexBoundHighStrict = true;
                ++this.indexBoundHighCount;
                return this.indexBoundHighBuffer;
            }
            case BoundLE: {
                this.equalScan = false;
                ++this.indexBoundLowCount;
                return this.indexBoundLowBuffer;
            }
            case BoundLT: {
                this.equalScan = false;
                this.indexBoundLowStrict = true;
                ++this.indexBoundLowCount;
                return this.indexBoundLowBuffer;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    private NdbIndexScanOperation.IndexBound getNdbIndexBound() {
        ByteBuffer reclaimed = null;
        if (this.indexBoundLowCount + this.indexBoundHighCount > 0) {
            if (this.indexBoundLowCount == 0) {
                this.indexBoundLowBuffer = null;
            } else {
                this.indexBoundLowBuffer.limit(this.keyBufferSize);
                this.indexBoundLowBuffer.position(0);
            }
            if (this.indexBoundHighCount == 0) {
                this.indexBoundHighBuffer = null;
            } else {
                this.indexBoundHighBuffer.limit(this.keyBufferSize);
                this.indexBoundHighBuffer.position(0);
            }
            if (this.equalScan) {
                reclaimed = this.indexBoundLowBuffer;
                this.indexBoundLowBuffer = this.indexBoundHighBuffer;
            }
            NdbIndexScanOperation.IndexBound ndbindexBound = this.db.createIndexBound();
            ndbindexBound.low_key(this.indexBoundLowBuffer);
            ndbindexBound.high_key(this.indexBoundHighBuffer);
            ndbindexBound.low_key_count(this.indexBoundLowCount);
            ndbindexBound.high_key_count(this.indexBoundHighCount);
            ndbindexBound.low_inclusive(!this.indexBoundLowStrict);
            ndbindexBound.high_inclusive(!this.indexBoundHighStrict);
            ndbindexBound.range_no(this.indexBoundRange);
            if (logger.isDetailEnabled()) {
                logger.detail(" indexBoundLowCount: " + this.indexBoundLowCount + " indexBoundHighCount: " + this.indexBoundHighCount + " indexBoundLowStrict: " + this.indexBoundLowStrict + " indexBoundHighStrict: " + this.indexBoundHighStrict + " range: " + this.indexBoundRange);
            }
            if (reclaimed != null) {
                this.indexBoundLowBuffer = reclaimed;
                this.ndbRecordKeys.initializeBuffer(reclaimed);
            } else {
                this.indexBoundLowBuffer = this.ndbRecordKeys.newBuffer();
                this.buffers.add(this.indexBoundLowBuffer);
            }
            this.indexBoundHighBuffer = this.ndbRecordKeys.newBuffer();
            this.buffers.add(this.indexBoundHighBuffer);
            this.indexBoundLowCount = 0;
            this.indexBoundHighCount = 0;
            this.indexBoundLowStrict = false;
            this.indexBoundHighStrict = false;
            this.indexBoundRange = 0;
            this.equalScan = true;
            return ndbindexBound;
        }
        return null;
    }

    public void freeResourcesAfterExecute() {
        super.freeResourcesAfterExecute();
        this.buffers = null;
        if (this.ndbIndexBound != null) {
            this.db.delete(this.ndbIndexBound);
            this.ndbIndexBound = null;
        }
        if (this.ndbIndexBoundList != null) {
            for (NdbIndexScanOperation.IndexBound ndbindexBound : this.ndbIndexBoundList) {
                this.db.delete(ndbindexBound);
            }
            this.ndbIndexBoundList = null;
        }
    }
}

