/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.metadata.IndexHandlerImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDomainTypeHandlerImpl<T>
implements DomainTypeHandler<T> {
    protected static final I18NHelper local = I18NHelper.getInstance(AbstractDomainTypeHandlerImpl.class);
    protected static final Logger logger = LoggerFactoryService.getFactory().getInstance(AbstractDomainTypeHandlerImpl.class);
    protected String name;
    protected String tableName;
    protected Table table;
    protected int numberOfIdFields;
    protected int[] idFieldNumbers;
    protected DomainFieldHandler[] idFieldHandlers;
    protected DomainFieldHandler[] fieldHandlers;
    protected String[] primaryKeyColumnNames;
    protected int numberOfPartitionKeyColumns = 0;
    protected DomainFieldHandler[] partitionKeyFieldHandlers;
    protected String[] partitionKeyColumnNames;
    protected int numberOfFields = 0;
    protected List<DomainFieldHandler> persistentFieldHandlers = new ArrayList<DomainFieldHandler>();
    protected List<DomainFieldHandler> nonPKFieldHandlers = new ArrayList<DomainFieldHandler>();
    protected List<DomainFieldHandler> primitiveFieldHandlers = new ArrayList<DomainFieldHandler>();
    protected Map<String, Integer> fieldNameToNumber = new HashMap<String, Integer>();
    protected String[] fieldNames;
    protected List<IndexHandlerImpl> indexHandlerImpls = new ArrayList<IndexHandlerImpl>();
    protected Set<String> indexNames = new HashSet<String>();
    private StringBuilder reasons = null;

    public void registerPrimaryKeyColumn(DomainFieldHandler fmd, String columnName) {
        for (int i = 0; i < this.primaryKeyColumnNames.length; ++i) {
            if (!this.primaryKeyColumnNames[i].equals(columnName)) continue;
            this.idFieldHandlers[i] = fmd;
            this.idFieldNumbers[i] = fmd.getFieldNumber();
            if (!logger.isDetailEnabled()) continue;
            logger.detail("registerPrimaryKeyColumn found primary key " + columnName);
        }
        for (int j = 0; j < this.partitionKeyColumnNames.length; ++j) {
            if (!this.partitionKeyColumnNames[j].equals(columnName)) continue;
            this.partitionKeyFieldHandlers[j] = fmd;
            if (!logger.isDetailEnabled()) continue;
            logger.detail("registerPrimaryKeyColumn found partition key " + columnName);
        }
    }

    public int[][] registerIndices(AbstractDomainFieldHandlerImpl fmd, String columnName) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int i = 0; i < this.indexHandlerImpls.size(); ++i) {
            IndexHandlerImpl indexHandler = this.indexHandlerImpls.get(i);
            String[] columns = indexHandler.getColumnNames();
            for (int j = 0; j < columns.length; ++j) {
                if (!fmd.getColumnName().equals(columns[j])) continue;
                if (logger.isDetailEnabled()) {
                    logger.detail("Found field " + fmd.getName() + " column " + fmd.getColumnName() + " matching " + indexHandler.getIndexName());
                }
                indexHandler.setDomainFieldHandlerFor(j, fmd);
                result.add(new int[]{i, j});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + result.size() + " indexes for " + columnName);
        }
        return (int[][])result.toArray((T[])new int[result.size()][]);
    }

    public Set<String> getIndexNames(int[][] indexArray) {
        HashSet<String> result = new HashSet<String>();
        for (int[] index : indexArray) {
            result.add(this.indexHandlerImpls.get(index[0]).getIndexName());
        }
        return result;
    }

    protected String[] getColumnNames(String indexName, Column[] columns) {
        HashSet<String> columnNames = new HashSet<String>();
        for (Column column : columns) {
            String columnName = column.getName();
            if (columnNames.contains(columnName)) {
                throw new ClusterJUserException(local.message("ERR_Duplicate_Column", this.name, indexName, columnName));
            }
            columnNames.add(columnName);
        }
        return columnNames.toArray(new String[columnNames.size()]);
    }

    @Override
    public CandidateIndexImpl[] createCandidateIndexes() {
        CandidateIndexImpl[] result = new CandidateIndexImpl[this.indexHandlerImpls.size()];
        int i = 0;
        for (IndexHandlerImpl indexHandler : this.indexHandlerImpls) {
            result[i++] = indexHandler.toCandidateIndexImpl();
        }
        return result;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public int getNumberOfFields() {
        return this.numberOfFields;
    }

    public DomainFieldHandler[] getIdFieldHandlers() {
        return this.idFieldHandlers;
    }

    public DomainFieldHandler[] getFieldHandlers() {
        return this.fieldHandlers;
    }

    @Override
    public DomainFieldHandler getFieldHandler(String fieldName) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            if (!fmd.getName().equals(fieldName)) continue;
            return fmd;
        }
        throw new ClusterJUserException(local.message("ERR_Not_A_Member", (Object)fieldName, (Object)this.name));
    }

    public int getFieldNumber(String fieldName) {
        Integer fieldNumber = this.fieldNameToNumber.get(fieldName);
        if (fieldNumber == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_No_Field_Number", (Object)fieldName, (Object)this.name));
        }
        return fieldNumber;
    }

    @Override
    public void operationSetNonPKValues(ValueHandler handler, Operation op) {
        for (DomainFieldHandler fmd : this.nonPKFieldHandlers) {
            if (!handler.isModified(fmd.getFieldNumber())) continue;
            fmd.operationSetValue(handler, op);
        }
    }

    @Override
    public void operationSetValues(ValueHandler handler, Operation op) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            if (logger.isDetailEnabled()) {
                logger.detail("operationSetValues field: " + fmd.getName());
            }
            fmd.operationSetValue(handler, op);
        }
    }

    @Override
    public void operationSetModifiedNonPKValues(ValueHandler handler, Operation op) {
        for (DomainFieldHandler fmd : this.nonPKFieldHandlers) {
            fmd.operationSetModifiedValue(handler, op);
        }
    }

    @Override
    public void operationSetModifiedValues(ValueHandler handler, Operation op) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            fmd.operationSetModifiedValue(handler, op);
        }
    }

    @Override
    public void operationSetKeys(ValueHandler handler, Operation op) {
        for (DomainFieldHandler fmd : this.idFieldHandlers) {
            fmd.operationSetValue(handler, op);
        }
    }

    @Override
    public void operationGetValues(Operation op) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            fmd.operationGetValue(op);
        }
    }

    @Override
    public void operationGetValues(Operation op, BitSet fields) {
        if (fields == null) {
            this.operationGetValues(op);
        } else {
            int i = 0;
            for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
                if (!fields.get(i++)) continue;
                fmd.operationGetValue(op);
            }
        }
    }

    public void operationGetValuesExcept(IndexOperation op, String index) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            if (fmd.includedInIndex(index)) continue;
            if (logger.isDetailEnabled()) {
                logger.detail("operationGetValuesExcept index: " + index);
            }
            fmd.operationGetValue(op);
        }
    }

    @Override
    public void objectSetValues(ResultData rs, ValueHandler handler) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            fmd.objectSetValue(rs, handler);
        }
    }

    public void objectSetValuesExcept(ResultData rs, ValueHandler handler, String indexName) {
        for (DomainFieldHandler fmd : this.persistentFieldHandlers) {
            fmd.objectSetValueExceptIndex(rs, handler, indexName);
        }
    }

    protected Table getTable(Dictionary dictionary) {
        Table result;
        try {
            result = dictionary.getTable(this.tableName);
        }
        catch (Exception ex) {
            throw new ClusterJException(local.message("ERR_Get_NdbTable", (Object)this.name, (Object)this.tableName), ex);
        }
        return result;
    }

    @Override
    public int[] getKeyFieldNumbers() {
        return this.idFieldNumbers;
    }

    @Override
    public Table getStoreTable() {
        return this.table;
    }

    @Override
    public PartitionKey createPartitionKey(ValueHandler handler) {
        PartitionKey result = this.table.createPartitionKey();
        for (DomainFieldHandler fmd : this.partitionKeyFieldHandlers) {
            if (logger.isDetailEnabled()) {
                logger.detail("Field number " + fmd.getFieldNumber() + " column name " + fmd.getName() + " field name " + fmd.getName());
            }
            fmd.partitionKeySetPart(result, handler);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<String> getColumnNames(BitSet fields) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Set<Column> getStoreColumns(BitSet fields) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public ValueHandler createKeyValueHandler(Object keys, Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T getInstance(ValueHandler handler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Class<?> getOidClass() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Class<T> getProxyClass() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public ValueHandler getValueHandler(Object instance) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public boolean isSupportedType() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public T newInstance(ResultData resultData, Db db) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectMarkModified(ValueHandler handler, String fieldName) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectResetModified(ValueHandler handler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void objectSetCacheManager(CacheManager cm, Object instance) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    protected String removeUniqueSuffix(String indexName) {
        int beginIndex = indexName.lastIndexOf("$unique");
        if (beginIndex < 0) {
            return indexName;
        }
        String result = indexName.substring(0, beginIndex);
        return result;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setUnsupported(String reason) {
        if (this.reasons == null) {
            this.reasons = new StringBuilder();
        }
        this.reasons.append(reason);
    }

    public String getUnsupported() {
        return this.reasons == null ? null : this.reasons.toString();
    }

    @Override
    public T newInstance(ValueHandler valueHandler) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }
}

