/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.DbImplForNdbRecord;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordSmartValueHandlerFactoryImpl;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.Ndb_cluster_connection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClusterConnectionImpl
implements ClusterConnection {
    static final I18NHelper local = I18NHelper.getInstance(ClusterConnectionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterConnectionImpl.class);
    protected Ndb_cluster_connection clusterConnection;
    final String connectString;
    final int nodeId;
    private Map<Db, Object> dbs = new IdentityHashMap<Db, Object>();
    private ConcurrentMap<String, NdbRecordImpl> ndbRecordImplMap = new ConcurrentHashMap<String, NdbRecordImpl>();
    NdbDictionary.Dictionary dictionaryForNdbRecord = null;
    private static final String USE_SMART_VALUE_HANDLER_NAME = "com.mysql.clusterj.UseSmartValueHandler";
    private static final boolean USE_SMART_VALUE_HANDLER = ClusterJHelper.getBooleanProperty("com.mysql.clusterj.UseSmartValueHandler", "true");

    public ClusterConnectionImpl(String connectString, int nodeId) {
        this.connectString = connectString;
        this.nodeId = nodeId;
        this.clusterConnection = Ndb_cluster_connection.create(connectString, nodeId);
        ClusterConnectionImpl.handleError(this.clusterConnection, connectString, nodeId);
        logger.info(local.message("INFO_Create_Cluster_Connection", (Object)connectString, (Object)nodeId));
    }

    public void connect(int connectRetries, int connectDelay, boolean verbose) {
        this.checkConnection();
        int returnCode = this.clusterConnection.connect(connectRetries, connectDelay, verbose ? 1 : 0);
        ClusterConnectionImpl.handleError(returnCode, this.clusterConnection, this.connectString, this.nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db createDb(String database, int maxTransactions) {
        this.checkConnection();
        Ndb ndb = null;
        ClusterConnectionImpl clusterConnectionImpl = this;
        synchronized (clusterConnectionImpl) {
            ndb = Ndb.create(this.clusterConnection, database, "def");
            ClusterConnectionImpl.handleError(ndb, this.clusterConnection, this.connectString, this.nodeId);
            if (this.dictionaryForNdbRecord == null) {
                Ndb ndbForNdbRecord = Ndb.create(this.clusterConnection, database, "def");
                ClusterConnectionImpl.handleError(ndbForNdbRecord, this.clusterConnection, this.connectString, this.nodeId);
                DbImplForNdbRecord dbForNdbRecord = new DbImplForNdbRecord(this, ndbForNdbRecord);
                this.dbs.put(dbForNdbRecord, null);
                this.dictionaryForNdbRecord = dbForNdbRecord.getNdbDictionary();
            }
        }
        DbImpl result = new DbImpl(this, ndb, maxTransactions);
        this.dbs.put(result, null);
        return result;
    }

    public void waitUntilReady(int connectTimeoutBefore, int connectTimeoutAfter) {
        this.checkConnection();
        int returnCode = this.clusterConnection.wait_until_ready(connectTimeoutBefore, connectTimeoutAfter);
        ClusterConnectionImpl.handleError(returnCode, this.clusterConnection, this.connectString, this.nodeId);
    }

    private void checkConnection() {
        if (this.clusterConnection == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Cluster_Connection_Must_Not_Be_Null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleError(int returnCode, Ndb_cluster_connection clusterConnection, String connectString, int nodeId) {
        if (returnCode >= 0) {
            return;
        }
        try {
            ClusterConnectionImpl.throwError(returnCode, clusterConnection, connectString, nodeId);
        }
        finally {
            Ndb_cluster_connection.delete(clusterConnection);
        }
    }

    protected static void handleError(Object object, Ndb_cluster_connection clusterConnection, String connectString, int nodeId) {
        if (object != null) {
            return;
        }
        ClusterConnectionImpl.throwError(null, clusterConnection, connectString, nodeId);
    }

    protected static void handleError(Ndb_cluster_connection clusterConnection, String connectString, int nodeId) {
        if (clusterConnection == null) {
            String message = local.message("ERR_Connect", (Object)connectString, (Object)nodeId);
            logger.error(message);
            throw new ClusterJDatastoreException(message);
        }
    }

    protected static void throwError(Object returnCode, Ndb_cluster_connection clusterConnection, String connectString, int nodeId) {
        String message = clusterConnection.get_latest_error_msg();
        int errorCode = clusterConnection.get_latest_error();
        String msg = local.message("ERR_NdbError", returnCode, errorCode, message, connectString, nodeId);
        throw new ClusterJDatastoreException(msg);
    }

    public void close() {
        if (this.clusterConnection != null) {
            logger.info(local.message("INFO_Close_Cluster_Connection", (Object)this.connectString, (Object)this.nodeId));
            for (NdbRecordImpl ndbRecord : this.ndbRecordImplMap.values()) {
                ndbRecord.releaseNdbRecord();
            }
            this.ndbRecordImplMap.clear();
            if (this.dbs.size() != 0) {
                IdentityHashMap<Db, Object> dbsToClose = new IdentityHashMap<Db, Object>(this.dbs);
                for (Db db : dbsToClose.keySet()) {
                    db.close();
                }
            }
            Ndb_cluster_connection.delete(this.clusterConnection);
            this.clusterConnection = null;
        }
    }

    public void close(Db db) {
        this.dbs.remove(db);
    }

    public int dbCount() {
        int dbForNdbRecord = this.dictionaryForNdbRecord == null ? 0 : 1;
        return this.dbs.size() - dbForNdbRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl getCachedNdbRecordImpl(Table storeTable) {
        NdbRecordImpl newNdbRecordImpl;
        String tableName = storeTable.getName();
        NdbRecordImpl result = (NdbRecordImpl)this.ndbRecordImplMap.get(tableName);
        if (result != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl found for " + tableName);
            }
            return result;
        }
        NdbDictionary.Dictionary dictionary = this.dictionaryForNdbRecord;
        synchronized (dictionary) {
            result = (NdbRecordImpl)this.ndbRecordImplMap.get(tableName);
            if (result != null) {
                return result;
            }
            newNdbRecordImpl = new NdbRecordImpl(storeTable, this.dictionaryForNdbRecord);
        }
        NdbRecordImpl winner = this.ndbRecordImplMap.putIfAbsent(tableName, newNdbRecordImpl);
        if (winner == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl created for " + tableName);
            }
            return newNdbRecordImpl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("NdbRecordImpl lost race for " + tableName);
        }
        newNdbRecordImpl.releaseNdbRecord();
        return winner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl getCachedNdbRecordImpl(Index storeIndex, Table storeTable) {
        NdbRecordImpl newNdbRecordImpl;
        String recordName = storeTable.getName() + "+" + storeIndex.getInternalName();
        NdbRecordImpl result = (NdbRecordImpl)this.ndbRecordImplMap.get(recordName);
        if (result != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl found for " + recordName);
            }
            return result;
        }
        NdbDictionary.Dictionary dictionary = this.dictionaryForNdbRecord;
        synchronized (dictionary) {
            result = (NdbRecordImpl)this.ndbRecordImplMap.get(recordName);
            if (result != null) {
                return result;
            }
            newNdbRecordImpl = new NdbRecordImpl(storeIndex, storeTable, this.dictionaryForNdbRecord);
        }
        NdbRecordImpl winner = this.ndbRecordImplMap.putIfAbsent(recordName, newNdbRecordImpl);
        if (winner == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl created for " + recordName);
            }
            return newNdbRecordImpl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("NdbRecordImpl lost race for " + recordName);
        }
        newNdbRecordImpl.releaseNdbRecord();
        return winner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadSchema(String tableName) {
        ConcurrentMap<String, NdbRecordImpl> concurrentMap = this.ndbRecordImplMap;
        synchronized (concurrentMap) {
            Iterator iterator = this.ndbRecordImplMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(tableName)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing cached NdbRecord for " + key);
                }
                NdbRecordImpl record = (NdbRecordImpl)entry.getValue();
                iterator.remove();
                if (record == null) continue;
                record.releaseNdbRecord();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Removing dictionary entry for cached table " + tableName);
            }
            this.dictionaryForNdbRecord.removeCachedTable(tableName);
        }
    }

    public ValueHandlerFactory getSmartValueHandlerFactory() {
        NdbRecordSmartValueHandlerFactoryImpl result = null;
        if (USE_SMART_VALUE_HANDLER) {
            result = new NdbRecordSmartValueHandlerFactoryImpl();
        }
        return result;
    }

    public NdbRecordOperationImpl newNdbRecordOperationImpl(DbImpl db, Table storeTable) {
        return new NdbRecordOperationImpl(this, db, storeTable);
    }
}

