/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Employee;
import testsuite.clusterj.model.LongIntStringPK;

public class PartitionKeyTest
extends AbstractClusterJTest {
    public void localSetUp() {
        this.createSessionFactory();
        this.addTearDownClasses(Employee.class, LongIntStringPK.class);
    }

    public void test() {
        this.badClass();
        this.wrongKeyTypePrimitive();
        this.wrongKeyTypePrimitiveNull();
        this.wrongKeyTypeCompound();
        this.wrongKeyTypeCompoundNull();
        this.wrongKeyTypeCompoundNullPart();
        this.setPartitionKeyTwice();
        this.goodIntKey();
        this.goodCompoundKey();
        this.session = this.sessionFactory.getSession();
        this.failOnError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void badClass() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.setPartitionKey(Integer.class, (Object)0);
            this.error("Failed to throw exception on setPartitionKey(Integer.class, 0)");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrongKeyTypePrimitive() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.setPartitionKey(Employee.class, (Object)0L);
            this.error("Failed to throw exception on setPartitionKey(Employee.class, 0L)");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrongKeyTypePrimitiveNull() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.setPartitionKey(Employee.class, null);
            this.error("Failed to throw exception on setPartitionKey(Employee.class, null)");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrongKeyTypeCompound() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.setPartitionKey(LongIntStringPK.class, (Object)0L);
            this.error("Failed to throw exception on setPartitionKey(LongIntStringPK.class, 0L)");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrongKeyTypeCompoundPart() {
        try {
            Object[] key = new Object[]{0L, 0L, ""};
            this.session = this.sessionFactory.getSession();
            this.session.setPartitionKey(LongIntStringPK.class, (Object)key);
            this.error("Failed to throw exception on setPartitionKey(LongIntStringPK.class, new Object[] {0L, 0L, \"\"})");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrongKeyTypeCompoundNull() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.setPartitionKey(LongIntStringPK.class, null);
            this.error("Failed to throw exception on setPartitionKey(LongIntStringPK.class, null)");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wrongKeyTypeCompoundNullPart() {
        try {
            this.session = this.sessionFactory.getSession();
            Object[] key = new Object[]{0L, null, ""};
            this.session.setPartitionKey(LongIntStringPK.class, (Object)key);
            this.error("Failed to throw exception on setPartitionKey(LongIntStringPK.class, new Object[] {0L, null, \"\"})");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPartitionKeyTwice() {
        try {
            this.session = this.sessionFactory.getSession();
            Object[] key = new Object[]{0L, 0, ""};
            this.session.setPartitionKey(LongIntStringPK.class, (Object)key);
            this.session.setPartitionKey(LongIntStringPK.class, (Object)key);
            this.error("Failed to throw exception on second setPartitionKey");
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void goodIntKey() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.deletePersistentAll(Employee.class);
            Employee employee = (Employee)this.session.newInstance(Employee.class);
            employee.setId(1000);
            employee.setAge(1000);
            employee.setMagic(1000);
            employee.setName("Employee 1000");
            this.session.setPartitionKey(Employee.class, (Object)1000);
            this.session.makePersistent((Object)employee);
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void goodCompoundKey() {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.deletePersistentAll(LongIntStringPK.class);
            Object[] key = new Object[]{1000L, 1000, null};
            LongIntStringPK instance = (LongIntStringPK)this.session.newInstance(LongIntStringPK.class);
            instance.setLongpk(1000L);
            instance.setIntpk(1000);
            instance.setStringpk("1 Thousand");
            this.session.setPartitionKey(LongIntStringPK.class, (Object)key);
            this.session.makePersistent((Object)instance);
        }
        finally {
            this.session.close();
            this.session = null;
        }
    }
}

