/**
*** Program jdbcMysqlPSParam.java     
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;
import java.util.Vector;
import java.io.InputStream;
import java.sql.*;

final class jdbcMysqlPSParam
{
/** An exercise in redundancy. */
int pNumber;

/** The currently building byte array. */
byte[] currentBytes;

/** The used size of the building byte array. */
int currentByteSize;

/** Prior byte arrays */
Vector bytes;

/** Do we have an input stream */
InputStream is;

/** Stream read set size */
int streamSetSize;

/** Do we insert apostrophes */
boolean apostrophize;

/** Are we nulled */
boolean nulled;

/** Null string */
byte[] nullString;


/** Constructor
*** @param number Redundant statement of parameter number.
**/
jdbcMysqlPSParam(int number)
    {
    this.pNumber = number;
    this.apostrophize = true;
    String nn = "NULL";
    this.nullString = nn.getBytes();
    clear();
    }

void clear() 
    {
    currentBytes = new byte[256];
    currentByteSize = 0;
    bytes = new Vector();
    is = null;
    streamSetSize = 0;
    nulled = false;
    }

void addRawByte(byte b)
    {
    currentBytes[currentByteSize++] = b;
    if(currentByteSize > 255)
        {
        bytes.addElement(currentBytes);
        currentBytes = new byte[256];
        currentByteSize = 0;
        }
    }

void addByte(byte b)
    {
    if(b == '\\' || b == '\'' || b == '\"') addRawByte((byte)'\\');
    addRawByte(b);
    }

void addBytes(byte[] b, int s)
    {
    int min;
    if(s < 0) min = b.length;
    else min = s < b.length ? s : b.length;
    for(int i = 0; i < min; i++) addByte(b[i]);
    }

void addString(String s)
    {
    byte[] b = s.getBytes();
    int l = b.length;
    for(int i = 0;  i < l; i++) addByte(b[i]);
    }
          
void apostrophize(boolean v)
    { apostrophize = v; }

void setNullString(String s)
    { nullString = s.getBytes(); }

void setNull()
    {
    clear();
    nulled = true;
    }

void setBytes(byte[] b)
    {
    clear();
    addBytes(b, -1);
    }

void setString(String s)
    {
    clear();
    addString(s);
    }

void setStream(InputStream s, int l)
    {
    clear();
    is = s;
    streamSetSize = l;
    }

void bagIt(jdbcMysqlBag bag) throws SQLException
    { 
    try{
        if(nulled)
            {
            if(apostrophize) { bag.putByteArray(nullString, -1); }
            return;
            }
        if(apostrophize) bag.putByte((byte)'\'');
        if(is == null)
            {
            byte[] b;
            int l = bytes.size();
            for(int i = 0; i < l ; i++)
                {
                b = (byte[]) bytes.elementAt(i);
                bag.putByteArray(b, -1);
                }
            bag.putByteArray(currentBytes, currentByteSize);
            if(apostrophize) bag.putByte((byte)'\'');
            return;
            }
        int c;
        int count = streamSetSize;
        byte[] ba = new byte[1024];
        byte[] bo = new byte[2048];
        int bi, bx, by;
        // swapped 
        int bs = count > 1024 ? 1024 :  count;
        bi = is.read(ba, 0, bs);
        while(count > 0) 
            {
            if(bi == -1) count = 0;
            else{
                by = 0;
                for(bx = 0; bx < bi; bx++)
                    {
                    c = ba[bx];
                    if(c == '\\' || c == '\'' || c == '\"')
                           bo[by++] = (byte)'\\';
                    bo[by++] = (byte)c;
                    }
                bag.putByteArray(bo, by);
                count -= bi;
                if(count > 0)
                    {
		      // swapped here too.
                    bs = count > 1024 ? 1024 : count;
                    bi = is.read(ba, 0, bs);
                    }
                }
            }
        if(apostrophize) bag.putByte((byte)'\'');
        }
    catch(Exception e) 
        { 
        throw new SQLException("E0500 Error writing parameter " +
                               + pNumber + " to output buffer. \n"
                               + e.getMessage());
        }
    }     
}

         
