#include <stdio.h>
#include <stdlib.h>
#include <mysql/mysql.h>

typedef char *DYNAMIC_STR;

/* Undefine all the things in <mysql/mysql.h> which we need to make simple functions for. */

#undef mysql_num_rows
#undef mysql_num_fields
#undef mysql_eof
#undef mysql_fetch_field_direct
#undef mysql_fetch_fields
#undef mysql_row_tell
#undef mysql_field_tell
#undef mysql_affected_rows
#undef mysql_insert_id
#undef mysql_error
#undef mysql_errno
#undef mysql_info
#undef mysql_reload
#undef mysql_thread_id

char * STDCALL
mysql_stk_version()
{
    return VERSION;
}

my_ulonglong STDCALL
mysql_num_rows(MYSQL_RES *res)
{
    return res->row_count;
}

unsigned int STDCALL
mysql_num_fields(MYSQL_RES *res)
{
    return res->field_count;
}

my_bool STDCALL
mysql_eof(MYSQL_RES *res)
{
    return res->eof;
}

MYSQL_FIELD STDCALL
mysql_fetch_field_direct(MYSQL_RES *res, int fieldnr)
{
    return res->fields[fieldnr];
}

MYSQL_FIELD * STDCALL
mysql_fetch_fields(MYSQL_RES *res)
{
    return res->fields;
}

MYSQL_ROWS * STDCALL
mysql_row_tell(MYSQL_RES *res)
{
    return res->data_cursor;
}

unsigned int STDCALL
mysql_field_tell(MYSQL_RES *res)
{
    return res->current_field;
}

my_ulonglong STDCALL
mysql_affected_rows(MYSQL *mysql)
{
    return mysql->affected_rows;
}

my_ulonglong STDCALL
mysql_insert_id(MYSQL *mysql)
{
    return mysql->insert_id;
}

char * STDCALL
mysql_error(MYSQL *mysql)
{
    return mysql->net.last_error;
}

unsigned int STDCALL
mysql_errno(MYSQL *mysql)
{
    return mysql->net.last_errno;
}

char * STDCALL
mysql_info(MYSQL *mysql)
{
    return mysql->info;
}

int STDCALL
mysql_reload(MYSQL *mysql)
{
    return mysql_refresh(mysql, REFRESH_GRANT);
}

unsigned long STDCALL
mysql_thread_id(MYSQL *mysql)
{
    return mysql->thread_id;
}

void
STk_init_libmysqlclientstk()
{
    return;
}


/*
 * Here are some utility functions to make it possible for STk clients to get
 * inside MySQL structs that the STk <--> C interface doesn't know about.
 */


/*
 * mysql_fetch_column
 *
 * Given a MYSQL_ROW (obtained by calling mysql_fetch_row), use this function
 * to fetch (as a char *) the value of a column in that row. This simply gets the appropriate
 * field out of the row array.
 */

char * STDCALL
mysql_fetch_column(MYSQL_ROW row, int column)
{
    return row[column];
}

/*
 * mysql_fetch_length
 *
 * Pulls a single length out of an array pointed to by the return result of mysql_fetch_lengths.
 */

ulong STDCALL
mysql_fetch_length(ulong *lengths, int i)
{
    return lengths[i];
}

/*
 * mysql_stk_escape_string
 *
 * A version of myqsl_escape_string that returns a dynamically allocated string.
 * The STk C interface will free this when it goes out of scope. 
 */

#define STK_LAST_ARG_LEN length
DYNAMIC_STR STDCALL
mysql_stk_escape_string(char *string, unsigned int STK_LAST_ARG_LEN)
{
    char *new;

    if (length < 0){
	length = strlen(string);
    }

    if (!(new = malloc((length << 1) + 1))){
	return NULL;
    }

    (void) mysql_escape_string(new, string, length);

    return new;
}
#undef STK_LAST_ARG_LEN


/*
 * TODO:
 *
 * mysql_fetch_field_direct + supporting functions for individual field members.
 */

