/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 */
/*
 * File: guile/sql_imp.h
 * Usage: declarations of interface routines between squile and
 *        specific sql engines
 *
 * Copyright (C) 1996-98 all source by Hal Roberts
 */

#ifndef GH_SQL_SQL_IMP_HEADER
#define GH_SQL_SQL_IMP_HEADER

#include <guile/gh.h>

int gh_sql_imp_connect(void *db, char *host_name, char *user_name, 
			char *pass);
int gh_sql_imp_select_db(void *db, char *db_name);
char *gh_sql_imp_error(void *db);
void gh_sql_imp_close(void *db);
int gh_sql_imp_query(void *db, char *query);
void *gh_sql_imp_store_result(void *db);
int gh_sql_imp_num_fields(void *res);
int gh_sql_imp_num_rows(void *res);
char *gh_sql_imp_fetch_field_name(void *res);
char **gh_sql_imp_fetch_row(void *res);
void gh_sql_imp_free_result(void *res);
int gh_sql_imp_affected_rows(void *db);

SCM gh_sql_imp_sql2scm(void *res, char **data, int pos);

void *gh_sql_alloc_db(void);

#define gh_sql_error(gse) fprintf(stderr, gse); fflush(stderr)

#endif
