#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <syslog.h>
#include <stdarg.h>
#include <alloca.h>

#include <mysql/mysql.h>

#define PAM_SM_AUTH
#define PAM_SM_ACCOUNT
#define PAM_SM_SESSION
#define PAM_SM_PASSWORD

#define PAM_MODULE_NAME  "pam_mysql" 
#define DB_DATABASE      "system"
#define DB_HOST          "localhost"
#define DB_USER          "user_name"
#define DB_PASS          "user_pass"

#include <security/pam_modules.h>


static void _pam_log(int err, const char *format, ...)
{
    va_list args;

    va_start(args, format);
    openlog(PAM_MODULE_NAME,LOG_PID, LOG_AUTH);
    vsyslog(err, format, args);
    va_end(args);
    closelog();
}


/* --- authentication management functions --- */


    
MYSQL auth_sql_server,*mysql_auth=NULL;
#define MYSQL_ERROR(mysql) ((mysql)?(mysql_error(mysql)):"mysql server has gone away")


int db_connect() {
  int retvalue=PAM_AUTH_ERR;
  
  mysql_auth = mysql_connect(&auth_sql_server,DB_HOST,DB_USER,DB_PASS);
  if (mysql_auth) {
    mysql_select_db(&auth_sql_server,DB_DATABASE);
    retvalue=PAM_SUCCESS;
  }
  
  return retvalue;
}


static int db_getuid(const char *user ) {
  char *sql;
  MYSQL_RES *result;
  MYSQL_ROW sql_row;
  int uid=-1;

  sql =(char *) malloc(100);
  sprintf(sql,"select uid from tb_users where login='%s'",user);
  
  mysql_query(&auth_sql_server,sql);
  result = mysql_store_result(&auth_sql_server);
  
  if (!result ) 
    return PAM_AUTH_ERR;

  if (mysql_num_rows(result) ==1 ) {
    sql_row = mysql_fetch_row(result);
    uid = atoi(sql_row[0]);
  }
  
  free(sql);
  
  return uid;
}


static int db_checkpass(int uid,char *pass ) {
  char *sql;
  MYSQL_RES *result;
  MYSQL_ROW sql_row;
  int retvalue=-1;

  sql =(char *) malloc(100);
  sprintf(sql,"select passwd from tb_users where uid=%d ",uid );
  
  mysql_query(&auth_sql_server,sql);
  result = mysql_store_result(&auth_sql_server);
  
  if (!result ) 
    return PAM_AUTH_ERR;

  if (mysql_num_rows(result) ==1 ) {
    sql_row = mysql_fetch_row(result);
    retvalue= strcmp(sql_row[0],pass);
  }
  free(sql);
  return retvalue;
}


int converse(	pam_handle_t *pamh,
		int nargs, 
		struct pam_message **message,
		struct pam_response **response	)

{
	int retval;
	struct pam_conv *conv;

	retval = pam_get_item(	pamh, PAM_CONV,  (const void **) &conv ) ; 
	if ( retval == PAM_SUCCESS )
		{
	  		retval = conv->conv( 	nargs,  
	  					( const struct pam_message ** ) message, 
	  					response, 
	  					conv->appdata_ptr );
     		}
	return retval;
}



int _set_auth_tok(	pam_handle_t *pamh, 
			int flags, int argc, 
			const char **argv	)
{
	int	retval;
	char	*p;
	
	struct pam_message msg[1],*pmsg[1];
	struct pam_response *resp;

	/* set up conversation call */

	pmsg[0] = &msg[0];
	msg[0].msg_style = PAM_PROMPT_ECHO_OFF;
	msg[0].msg = "Password: ";
	resp = NULL;

	if ( ( retval = converse( pamh, 1 , pmsg, &resp ) ) != PAM_SUCCESS ) 
		return retval;

	if ( resp ) 
		{
			if ( ( flags & PAM_DISALLOW_NULL_AUTHTOK ) && 
							resp[0].resp == NULL ) 
		       		{
					free( resp );
					return PAM_AUTH_ERR;
		  		}

			p = resp[ 0 ].resp;
			
			/* This could be a memory leak. If resp[0].resp 
			   is malloc()ed, then it has to be free()ed! 
			   	-- alex 
			*/
			
		  	resp[ 0 ].resp = NULL; 		  				  

	     	} 
	else 
		return PAM_CONV_ERR;

	free( resp );
	pam_set_item( pamh, PAM_AUTHTOK, p );
	return PAM_SUCCESS;
}








PAM_EXTERN int pam_sm_authenticate(pam_handle_t *pamh,int flags,int argc
			,const char **argv)
{
  int retval,uid;
  const char *name;
  char *p;

  _pam_log(LOG_INFO,"Looking for username :%s ",name);

  if ( (retval = pam_get_user( pamh, &name, "login: ") ) != PAM_SUCCESS )
    return retval;

  if (name == (char *) NULL) 
    return PAM_USER_UNKNOWN;
  
  if (db_connect()== PAM_AUTH_ERR)
    return PAM_AUTH_ERR;
  
  uid = db_getuid(name);

  _pam_log(LOG_INFO,"username :%s uid:%d  ",name,uid ); 
  
  if (uid >=0) {
    pam_get_item( pamh, PAM_AUTHTOK, (void*) &p );

    if ( !p ) 
      {
	retval = _set_auth_tok( pamh, flags, argc, argv );
	if ( retval != PAM_SUCCESS ) 
	  return retval;
      }

    pam_get_item( pamh, PAM_AUTHTOK, (void*) &p );
    _pam_log (LOG_INFO," Name:%s pass:%s ",name,p);
    
    if (!db_checkpass(uid,p)) {
      retval = PAM_SUCCESS;
    }
    else 
      retval= PAM_AUTH_ERR;

  } 

  return retval;
}

PAM_EXTERN int pam_sm_setcred(pam_handle_t *pamh,int flags,int argc
		   ,const char **argv)
{
  _pam_log(LOG_INFO,"setscred   flag:%d ",flags); 
  return PAM_SUCCESS;
}

/* --- account management functions --- */





PAM_EXTERN int pam_sm_acct_mgmt(pam_handle_t *pamh,int flags,int argc
		     ,const char **argv)
{

     _pam_log(LOG_INFO,"acct_mgmt    \n"); 
     return PAM_SUCCESS;
}

/* --- password management --- */

PAM_EXTERN int pam_sm_chauthtok(pam_handle_t *pamh,int flags,int argc
		     ,const char **argv)
{
     _pam_log(LOG_INFO,"aouthok   \n"); 
     return PAM_SUCCESS;
}

/* --- session management --- */

PAM_EXTERN int pam_sm_open_session(pam_handle_t *pamh,int flags,int argc
			,const char **argv)
{
     _pam_log(LOG_INFO," Starting Session \n"); 
 	
	
    return PAM_SUCCESS;
}

PAM_EXTERN int pam_sm_close_session(pam_handle_t *pamh,int flags,int argc
			 ,const char **argv)
{
    _pam_log(LOG_INFO," Closing  Session \n"); 
     return PAM_SUCCESS;
}

/* end of module definition */

/* static module data */
#ifdef PAM_STATIC
struct pam_module _pam_mysql_modstruct = {
    "pam_mysql",
    pam_sm_authenticate,
    pam_sm_setcred,
    pam_sm_acct_mgmt,
    pam_sm_open_session,
    pam_sm_close_session,
    pam_sm_chauthtok
};
#endif
