/********************************************************/
/* mysqltop.c
/*
/* Author: Thomas Wana
/* Date  : 1999-08-04 
/*
/* Executes a query in a fixed time interval. Very useful
/* for presentations to see what's going on in a database!
/*
/* Get the most recent version from http://wana.tsx.org!
/*
/* REQUIRES: *) ncurses
/*           *) mysql > 3.22.x (tested OK with 3.22.24)
/*
/********************************************************/

#include <stdio.h>
#include <ncurses.h>
#include <string.h>
#include <stdlib.h>
#include <mysql.h>
#include <unistd.h>

#define VERSION "2.0"

void Help();
int CommandLine(int argc, char **argv);

char user[20],host[80],password[30];
char query[500],database[80];
 
void main(int argc, char **argv)
{
   MYSQL mysql;
   MYSQL_ROW row;
   MYSQL_RES *result;
   MYSQL_FIELD *field;
   char taste,hilf[30];
   unsigned long delay;
   int ende,i,j,k,x,y,columns;
   int row_width[80];

   initscr();
   printw("MYSQL TOP %s - (c) 1999 by Thomas Wana <wana@ycom.at>\n\n",VERSION);
   refresh();
   if(!CommandLine(argc,argv))
   {
      printw("-h ... host to connect\n");
      printw("-u ... username\n");
      printw("-p ... password\n");
      printw("-d ... database\n\n");
      printw("Example: mysqltop -hlocalhost -uroot -psecret -dmydb\n\n");
      printw("You can leave out some parameters. You will then be asked later.\n\n");
      printw("There is an interactive help available. Press '?' at runtime.");
      printw("\n\n<press any key>\n");
      noecho();
      nodelay(stdscr,FALSE);
      refresh();
      getch();
      endwin();
      exit(1);
   }
   mysql_init(&mysql);
   if(mysql_real_connect(&mysql,host,user,password,database,0,NULL,0)!=NULL)
   {
      printw("Successfully connected.\n");
      printw("Enter query to execute: ");
      refresh();
      getstr(query);
      printw("Enter delay between single queries (in microseconds; 1,000,000=1 second): ");
      refresh();
      scanw("%ld",&delay);
         nodelay(stdscr,TRUE);
         ende=0;
         while(!ende)
         {
            erase();
            if(mysql_query(&mysql,query)==0)
            {
               result=mysql_store_result(&mysql);
               x=0; y=0; columns=0;
               for(i=0;(field=mysql_fetch_field(result))!=NULL && i<80;i++)
               {
                  if(strlen(field->name) > field->max_length)
                     row_width[i]=strlen(field->name);
                  else 
                     row_width[i]=field->max_length;
                  if(row_width[i]<4) 
                     row_width[i]=4;
                  move(y,x);
                  printw("%c",'+');
                  for(j=0;j<row_width[i]+3;j++)
                  {
                     printw("%c",'-');
                  }
                  move(y+2,x);
                  printw("%c",'+');
                  for(j=0;j<row_width[i]+3;j++)
                  {
                     printw("%c",'-');
                  }
                  move(y+1,x);
                  printw("| %s",field->name);
                  x+=row_width[i]+3;
                  columns++;
               }
               move(y,x); printw("%c",'+');
               move(y+1,x); printw("%c",'|');
               x=0; y=3;
               for(i=0;(row=mysql_fetch_row(result))!=NULL;i++)
               {
                  for(k=0;k<columns;k++)
                  {
                     move(y,x);
                     if(row[k]==NULL)
                        printw("| NULL");
                     else 
                        printw("| %s",row[k]);
                     x+=row_width[k]+3;
                  }
                  move(y,x); printw("%c",'|');
                  y++;
                  x=0;
               }
               for(k=0;k<columns;k++)
               {            
                  move(y,x);
                  printw("%c",'+');
                  for(j=0;j<row_width[k]+3;j++)
                 {
                     printw("%c",'-');
                 }
                  x+=row_width[k]+3;
               }
               move(y,x);
               printw("%c",'+');
               mysql_free_result(result);
            }
            else
            {
               printw("mysql_query returned with error.\n");
               printw("Use the interactive query-command ('n') to enter a "
                      "valid query.");
            }
            refresh();
            if((taste=getch())!=ERR)
            {
               switch(taste)
               {
                  case 'q': ende=1; break;
                  case '?': Help(); break;
                  case 'n': nodelay(stdscr,FALSE);
                            erase();
                            printw("Enter new query: ");
                            refresh();
                            getstr(query); 
                            nodelay(stdscr,TRUE); break;
                  case 'd': nodelay(stdscr,FALSE);
                            erase();
                            printw("Enter new delay (in microseconds): ");
                            refresh();
                            getstr(hilf);
                            delay=strtol(hilf,(char **)NULL,10);
                            nodelay(stdscr,TRUE); break;
               }
            }
            else usleep(delay);
         }
      endwin();
      mysql_close(&mysql);
   }
   else
   {
      endwin();
      printf("Unable to connect.\nError: %s\n",mysql_error(&mysql));
   }
}

void Help()
{
   erase();
   printw("Interactive help for mysqltop\n-----------------------------\n\n");
   printw("q ... Exit mysqltop\n");
   printw("n ... Enter new query\n");
   printw("d ... Enter new delay\n");
   nodelay(stdscr,FALSE);
   refresh();
   getch();
   nodelay(stdscr,TRUE);   
}

int CommandLine(int argc, char **argv)
{
   int host_done=0, user_done=0, password_done=0, database_done=0;
   int i,rval=1;
   char *wo;
   if(argc==1)               // Aufruf ohne Parameter
   {
      printw("Call without parameters. Use mysqltop -? for syntax.\n\n");
   }
   for(i=1;i<argc && rval!=0;i++)
   {
      if((wo=strstr(argv[i],"-h")))
      {
         strcpy(host,wo+2); 
         host_done=1;
      }
      else if((wo=strstr(argv[i],"-u")))
      {
         strcpy(user,wo+2);
         user_done=1;
      }
      else if((wo=strstr(argv[i],"-p")))
      {
         strcpy(password,wo+2);
         password_done=1;
      }
      else if((wo=strstr(argv[i],"-d")))
      {
         strcpy(database,wo+2);
         database_done=1;
      }
      else if((wo=strstr(argv[i],"-?")))
      {
         rval=0;
      }
   }
   if(rval!=0)
   {
      if(host_done==0)
      {
         printw("Host to connect: ");
         getstr(host);
      }
      else printw("Host: %s\n",host);
      refresh();
      if(user_done==0)
      {
         printw("Username: ");
         getstr(user);
      }
      else printw("Username: %s\n",user);
      refresh();
      if(password_done==0)
      {
         printw("Password: ");
         refresh();
         noecho();
         getstr(password); 
         echo();
      }
      refresh();
      if(database_done==0)
      {
         printw("Database: ");
         getstr(database);
      }
      else printw("Database: %s\n",database);
      refresh();
   }
   return rval;
}
