#include "xport.h"
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qfile.h>

void Xport::xport_export()
{
	bool all;

	QString database  = export_database->currentText();

	if(export_table->currentItem() == 0)
	{
		all = TRUE;
	}
	else
	{
		all = FALSE;
	}

	xport = "";

	xport += "# MySQL Navigator Xport utility version 0.2.0.\n";
	xport += "# Database: ";
	xport += database;
	xport += "\n";
	xport += "# " + user + "@" + host;
	xport += "\n\n";
	
	if(all)
	{
		if(export_all_table(database))
		{
			export_save();
			QMessageBox::information(this, tr("MySQL Navigator"), tr("Export is successfully completed."));
		}
	}
	else
	{
		if(export_one_table(database, export_table->currentText()))
		{
			export_save();
			QMessageBox::information(this, tr("MySQL Navigator"), tr("Export is successfully completed."));
		}
	}
}

bool Xport::export_all_table(const QString &database)
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	mysql_select_db(mysql, database.latin1());

	result = mysql_list_tables(mysql, NULL);

	if(result == NULL)
	{
		return TRUE;
	}

	while((row = mysql_fetch_row(result)))
	{
		export_one_table(database, row[0]);
	}

	//debug(xport.latin1());

	return TRUE;			
}

bool Xport::export_one_table(const QString &database, const QString &table)
{
	MYSQL_RES *result;
	MYSQL_ROW row;
	MYSQL_FIELD *field;

	QString si;
	
	mysql_select_db(mysql, database.latin1());

	if(mysql_query(mysql, QString(QString("lock tables ") + table + QString(" write")).latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE;
	}


	if(mysql_query(mysql, QString(QString("show create table ") + table).latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE;
	}

	result = mysql_store_result(mysql);

	if(result == NULL)
	{
		return FALSE;
	}

	row = mysql_fetch_row(result);

	xport += "#\n# Table structure for table \'";
	xport += table;
	xport += "\'\n#\n\n";

	xport += "# DROP TABLE IF EXISTS ";
	xport += table;
	xport += ";\n";

	xport += row[1];
	xport += ";\n\n";

	mysql_free_result(result);

	xport += "#\n# Dumping data for table \'";
	xport += table;
	xport += "\'\n#\n\n";

	mysql_select_db(mysql, database.latin1());

	if(mysql_query(mysql, QString(QString("select * from ") + table).latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)) + QString(tr("\nPlease retry again.")));
		return FALSE;
	}

	result = mysql_store_result(mysql);	

	if(result == NULL)
	{
		return FALSE;
	}

	si = "";

	int si_ = 0;;

	while((row = mysql_fetch_row(result)))
	{
		si += QString("INSERT INTO ") + table + QString(" VALUES (");

		si_ ++;

		int l = 0;	

		while((field = mysql_fetch_field(result)))
		{
			if(IS_NUM(field->type) == FALSE)
			{
				if(row[l] == NULL)
				{
					si += "";
				}
				else
				{
					si += "\'";
					si += row[l];
					si += "\'";
				}
			}
			else
			{
				if(row[l] == NULL)
				{
					si += "";
				}
				else
				{
					si += row[l];
				}
			}
			si += ", ";
			l++;
		}

		si = si.left(si.length() - 2);

		si += QString(");");

		xport += si;
		xport += "\n";

		//debug(si.latin1());
	
		mysql_free_result(result);

		if(mysql_query(mysql, QString(QString("select * from ") + table).latin1()))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)) + QString(tr("\nPlease retry again.")));
			return FALSE;
		}

		result = mysql_store_result(mysql);	

		mysql_data_seek(result, si_);
		
		si = "";
	}

	xport += "\n";

	mysql_free_result(result);

	if(mysql_query(mysql, QString("unlock tables").latin1()))
	{
		QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE;
	}


	return TRUE;			
}

void Xport::export_save()
{
	QFile si(export_file->text());

	if(si.open(IO_WriteOnly) ==FALSE)
	{
		debug("open() system call fail.");
		return;
	}

	si.writeBlock(xport.latin1(), xport.length());

	si.close();

	xport = "";
}
