#include "popupcombobox.h"

PopupComboBox::PopupComboBox(bool flag, QWidget *parent, const char *name)
	: QComboBox(flag, parent, name)
{
	signal_connect();

	flag = FALSE;
}

PopupComboBox::~PopupComboBox()
{
}

void PopupComboBox::signal_connect()
{
	connect((const QObject *)lineEdit(), SIGNAL(textChanged(const QString &)), (const QObject *)this, SLOT(slot_popup()));
}

void PopupComboBox::signal_disconnect()
{
	disconnect((const QObject *)lineEdit(), SIGNAL(textChanged(const QString &)), (const QObject *)this, SLOT(slot_popup()));
}

void PopupComboBox::slot_popup()
{
	if(lineEdit()->text().length() == 0)
	{
		listBox()->hide();
	}
	else
	{
		popup();

		listBox()->setCurrentItem(listBox()->findItem(lineEdit()->text().stripWhiteSpace()));

		lineEdit()->setFocus();
	}
}
