#include "script.h"
#include <qfiledialog.h>
#include <qradiobutton.h>
#include <qfile.h>
#include <qmessagebox.h>

void Script::slot_ok()
{
	if(script->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter script file."));

		return;
	}
	if(log->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter log file."));
		return;
	}

	int total = 0;
	int fail = 0;

	bool error = ignore->isOn();

	QString script = this->script->text();

	QFile file(script);

	QString query;
	
	char buffer;

	int test;

	if(file.open(IO_ReadOnly) == FALSE)
	{
		debug("script file open error.");
	}
	else
	{
		while(1)
		{
			test = file.readBlock(&buffer, 1);

			if(test == -1)
			{
				debug("file readblock error.");
				break;
			}
			else if(test == 0)
			{
				break;
			}
			else
			{
				if(buffer == '#')
				{
					while(1)
					{
						test = file.readBlock(&buffer, 1);

						if(test == 0)
						{
							break;
						}
						else if(test == -1)
						{
							break;
						}
						
						if(buffer == '\n')
						{
							break;
						}
						else
						{
						}
					}
				}
				else if(buffer == ';')
				{
					query += QString((QChar)buffer); 

					query = query.simplifyWhiteSpace();

					//debug("%s", query.latin1());

					total++;

					if((mysql_query(mysql,query.latin1())))
					{
						// log error
						emit signal_error_log(log->text(), query);

						fail ++;

						if(error)
						{
							// ignore
						}
						else
						{
							QMessageBox::critical(this, tr("MySQL Navigator"), tr("An error occured while running script. retry again later. :-P"));
							file.close();

							emit signal_tree();

							return;	
							// stop
						}
					}
					
					query = "";
				}
				else
				{
					query += QString((QChar)buffer); 
				}
			}
		}
	}

	file.close();

	char se[150];

	emit signal_tree();

	sprintf(se, "Statistics\n\nTotal: %d\t\tFail: %d", total, fail);

	QMessageBox::information(this, tr("MySQL Navigator"), se);

	//parentWidget()->close();
}

void Script::slot_cancel()
{
	parentWidget()->close();
}

void Script::slot_script()
{
	QString file = QFileDialog::getOpenFileName(QString::null, "*.*", this);

	if(!file.isEmpty())
	{
		script->setText(file);
	}
}

void Script::slot_log()
{
	QString file = QFileDialog::getSaveFileName(QString::null, "*.*", this);

	if(!file.isEmpty())
	{
		log->setText(file);
	}
}
