#include <qfile.h>
#include <stdlib.h>
#include <qlineedit.h>
#include "mainwindow.h"

#define HISTORY ".mysql_navigator.history"

// must change OS specific code to port to other OS. 

void MainWindow::load_history()
{
	char buffer[255];
	int si;

	sprintf(buffer, "%s/%s", getenv("HOME"), HISTORY);

	QFile history(buffer);

	if(QFile::exists(buffer) == FALSE)
	{
		sprintf(buffer, "touch %s/%s", getenv("HOME"), HISTORY);
		
		si = system(buffer);

		if(si == 127 || si == -1)
		{
			//debug("system() system call fail.");
			return;
		}
	}

	if(history.open(IO_ReadOnly) == FALSE)
	{
		//debug("open() system call fail.");
		return;
	}

	query->signal_disconnect();

	while((si = history.readLine(buffer, sizeof(buffer))))
	{
		if(si == -1)
		{
			break;
		}	

		query->insertItem(buffer);
	}
	
	query->lineEdit()->setText("");
	
	query->signal_connect();

	history.close();	
}

void MainWindow::save_history(const QString &query)
{
	char buffer[255];
	int si;

	sprintf(buffer, "echo \"%s\" >> %s/%s", query.latin1(), getenv("HOME"), HISTORY);  

	si = system(buffer);

	if(si == 127 || si == -1)
	{
		//debug("system() system call fail");
	}
}

void MainWindow::clear_history()
{
	int si;

	char buffer[255];

	sprintf(buffer, "rm -rf %s/%s", getenv("HOME"), HISTORY);

	si = system(buffer);

	if(si == 127 || si == -1)
	{
		//debug("system() system call fail.");
	}
}
