/* 
 * Mysql mex-file source version 1.12
 *
 * (c) Kimmo Uutela, 1999
 * http://boojum.hut.fi/~kuutela/mysqlmex.html
 *
 * Modified Nov 1999 to output numeric query results as matrices
 * by John Fisher <jfisher@are.berkeley.edu>.
 *
 * Modified Sep 2000 to output data from BLOB columns as uint8 arrays
 * by Brian Shand <bshand@dip.ee.uct.ac.za>
 *
 * Modified Mar 2001 to accept HOST:PORT host definition
 * by Guido Dietz <Guido.Dietz@dlr.de>
 *
 */

#ifdef _MSC_VER
  #include <windows.h>
#endif

#include "mex.h"
#include "matrix.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql.h>

#define REAL 0          /* For mxCreate*Matrix */
#define CPLX 1          /* Ditto */

static char *ermsg=NULL;
static MYSQL mysql;
static int isopen=0;

static char goodchar[]=
"________________________________________________0123456789_______ABCDEFGHIJKLMNOPQRSTUVWXYZ______abcdefghijklmnopqrstuvwxyz_____________________________________________________________________________________________________________________________________";

char *getstring(const mxArray *a) {
  int llen;
  char *line;
  if (!mxIsChar(a)) return NULL;
  llen=mxGetN(a)*mxGetM(a)+1;
  line=malloc(llen);
  mxGetString(a,line,llen);
  return line;
}
  

static void
fixnames(char **ca,int na) {
  int i,j;
  unsigned char *c;
  char cline[5];
  int needscheck=1;

  for (i=0;i<na;++i) {
    c=(unsigned char*) ca[i];
    while (*c!='\0') *c++=goodchar[*c];
  }
  while (needscheck) {
    needscheck=0;
    for (i=0;i<na-1;++i) {
      for (j=i+1;j<na;++j) {
	if (strcmp(ca[i],ca[j])==0) {
	  sprintf(cline,"%d",j);
	  ca[j]=realloc(ca[j],strlen(ca[j])+strlen(cline)+1);
	  strcat(ca[j],cline);
	  needscheck=1;
	}
      }
    }
  }
}


/* Convert a blob into a horizontal Matlab uint8 array */
mxArray *blobToMatlab(const void *src, int length) {
  mxArray * result;
  const int numDims = 2;
  int dims[2];
  dims[0] = 1;   dims[1] = length;
  result = mxCreateNumericArray(numDims, dims, mxUINT8_CLASS, mxREAL);
  memcpy(mxGetData(result), src, length);
  return result;
}
              

enum {ARG_QUERY, ARG_OPT};
enum {ARG_HOST=ARG_OPT, ARG_USER, ARG_PASSWD};
enum {RES_STRUCT,RES_AFFECTED,RES_INSERTID};
	
void mexFunction(int nlhs, mxArray *plhs[],
		 int nrhs, const mxArray *prhs[]) {
  
  MYSQL_RES *res=NULL;
  MYSQL_ROW row;
  int i,j,nfields,nrows;
  char *line=NULL;
  char *host=NULL;
  char *user=NULL;
  char *pass=NULL;
  char *port="";
  char **fieldnames=NULL;
  char *opt=NULL;
  int fn=0, asmatrix=0;
  double d;
  double *dptr;
  char **endptr;
  mxArray *tmp;
  if (nrhs<=ARG_QUERY) goto usage;
  line=getstring(prhs[ARG_QUERY]);
  if (!strcmp(line,"open")) {
    if (isopen) mysql_close(&mysql);
    if (nrhs>ARG_HOST) {
      host=getstring(prhs[ARG_HOST]);
      if ((port=strchr(host, ':'))!=NULL)
	  *(port++)=0;
      else
	port="";
    }
    if (nrhs>ARG_USER)
      user=getstring(prhs[ARG_USER]);
    if (nrhs>ARG_PASSWD)
      pass=getstring(prhs[ARG_PASSWD]);
#ifdef HAVE_MYSQL_REAL_CONNECT
# if MYSQL_VERSION_ID >= 32200
    if (mysql_init(&mysql)==NULL)
      goto error;
    if (mysql_real_connect(&mysql, host, user, pass, NULL, 
			   atoi(port), NULL, 0)==NULL)
      goto error;
# else
    if (mysql_real_connect(&mysql, host, user, pass, 
			   atoi(port), NULL, 0)==NULL)
      goto error;
# endif
#else
    if (mysql_connect(&mysql, host, user, pass)==NULL) goto error;
#endif
    isopen=1;
  } else if (!strcmp(line,"close")) {
    if (isopen) mysql_close(&mysql);
    isopen=0;
  } else {
    if (nrhs>ARG_OPT) {
      opt=getstring(prhs[ARG_HOST]);
      if (strcmp(opt,"fn")==0) fn=1;
      else if(strcmp(opt,"mat")==0) asmatrix=1;
      free(opt); opt=NULL;
    }
    if (!isopen) {
      free(line);
      mexErrMsgTxt("No connection open");
    }
    if (mysql_query(&mysql, line))
      goto error;
    res=mysql_store_result(&mysql);
    if (res!=NULL) {
      nfields=mysql_num_fields(res);
      nrows=mysql_num_rows(res);
      fieldnames=(char **) malloc(nfields*sizeof(char*));
      if (fn) {
	for (i=0;i<nfields;++i) {
	  fieldnames[i]=malloc(10);
	  sprintf(fieldnames[i],"fn%d",i);
	}
      } else {
	for (i=0;i<nfields;++i) {
	  fieldnames[i]=strdup(res->fields[i].name);
	}
	fixnames(fieldnames,nfields);
      }
      if(asmatrix) {
	/* For numeric database values only. */
	if(!(endptr=malloc(sizeof(char *)))) {
	  mexErrMsgTxt("Malloc on char buffer failed.\n");
	}
	if(!(*endptr = malloc(1))) {
	  mexErrMsgTxt("Malloc on char buffer failed.\n");
	}
	plhs[RES_STRUCT]=mxCreateDoubleMatrix(nrows,nfields,REAL);
	dptr=mxGetPr(plhs[RES_STRUCT]);
	for (i=0;i<nrows;++i) {
	  row=mysql_fetch_row(res);
	  for (j=0;j<nfields;++j) {
	    d=strtod(row[j], endptr);
	    if(*row[j]==**endptr) {
	      mexErrMsgTxt("Non-numeric value found in query output.\n");
	    }
	    dptr[i+(j*nrows)]=d;
	  }
	}
	
	goto done;
      }
      
      plhs[RES_STRUCT]=mxCreateStructMatrix(nrows, 1, nfields, fieldnames);
      for (i=0;i<nfields;++i) {
	free(fieldnames[i]);
      }
      free(fieldnames);
      for (i=0;i<nrows;++i) {
	row= mysql_fetch_row(res);
	for (j=0;j<nfields;++j) {
	  if (row[j]==NULL)
	    tmp=mxCreateDoubleMatrix(0,0,mxREAL);
	  else {
	    switch (res->fields[j].type) {
	    case FIELD_TYPE_DECIMAL:
	    case FIELD_TYPE_TINY:
	    case FIELD_TYPE_SHORT:
	    case FIELD_TYPE_LONG:
	    case FIELD_TYPE_FLOAT:
	    case FIELD_TYPE_DOUBLE:
	    case FIELD_TYPE_LONGLONG:
	    case FIELD_TYPE_INT24:
	      sscanf(row[j],"%lf",&d);
	      tmp=mxCreateDoubleMatrix(1,1,mxREAL);
	      mxGetPr(tmp)[0]=d;
	      break;
            case FIELD_TYPE_TINY_BLOB:
            case FIELD_TYPE_MEDIUM_BLOB:
            case FIELD_TYPE_LONG_BLOB:
            case FIELD_TYPE_BLOB:
              tmp=blobToMatlab(row[j], mysql_fetch_lengths(res)[j]);
              break;
	    default:
	      tmp=mxCreateString(row[j]);
	      break;
	    }
	  }
	  mxSetFieldByNumber(plhs[RES_STRUCT], i, j, tmp);
	}
      }
    } else if (nlhs>RES_STRUCT) {
      plhs[RES_STRUCT]=mxCreateDoubleMatrix(0,0,mxREAL);
    }
    if (nlhs>1) {
      plhs[RES_AFFECTED]=mxCreateDoubleMatrix(1, 1, mxREAL);
#ifdef _MSC_VER
      mxGetPr(plhs[1])[0]=(__int64)mysql_affected_rows(&mysql);
#else
      mxGetPr(plhs[1])[0]=mysql_affected_rows(&mysql);
#endif
    }
    if (nlhs>2) {
      plhs[2]=mxCreateDoubleMatrix(1, 1, mxREAL);
#ifdef _MSC_VER
      mxGetPr(plhs[RES_INSERTID])[0]=(__int64)mysql_insert_id(&mysql);
#else
      mxGetPr(plhs[RES_INSERTID])[0]=mysql_insert_id(&mysql);
#endif
    }
  }

 done:
  mysql_free_result(res);
  free(line);free(user);free(pass);free(host);
  return;
  
 error:
  free(line);free(user);free(pass);free(host);
  free(ermsg);
  ermsg=strdup(mysql_error(&mysql));
  if (res!=NULL) mysql_free_result(res);
  mexErrMsgTxt(ermsg);
  return;
  usage:
  free(line);
  mexErrMsgTxt("Incorrect arguments");
}
