
package mysqladmin;

/** 
    SelectDRiver is a part of Admin and done for loggin in to it...
    It creates a ComboBox out of a file called rdbms.dat in the
    Admin InstallDir

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import java.net.*;

public class SelectDriver extends JComboBox {

    private Vector v;

    public SelectDriver(String selected) {

	//System.out.println("Selected: " + selected);
	selected = selected.toLowerCase();
	String line="";
	String tmp = "";
      	v = new Vector();
        int sel=0;
	int idx = -1;

	   DataInputStream in  = new DataInputStream(SelectDriver.class.getResourceAsStream("rdbms.dat"));

	    while (line != null) {
		try  {
		    line = in.readLine();
		    if (line != null) {
			if ( ! line.startsWith("#") ) {
			    idx = idx + 1;
			    JdbcStuff js = new JdbcStuff() ;
			    js.setObject(line);
			    v.addElement(js);
			    this.addItem(js.getName());
			    tmp = js.getName().toLowerCase();
			    if (tmp.startsWith(selected)) sel = idx;
			}
		    }
		} catch (IOException iox) { line=null; }		
	    }
	    if (sel > 0)this.setSelectedIndex(sel);
    }
	
    public JdbcStuff getData(int i) { 
	return (JdbcStuff) v.elementAt(i);
    }


   
}



