package mysqladmin;

/** 
    SelectDRiver is a part of Admin and done for loggin in to it...
    It creates a ComboBox out of a file called rdbms.dat in the
    Admin InstallDir

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.util.*;
import javax.swing.ImageIcon;
import java.io.File;

public class JdbcStuff {

  public String name, jdbcDriver, dbUrl, port, gif;
 
    public JdbcStuff() { ; }

    public void setObject(String line) {

      try {
	  StringTokenizer st = new StringTokenizer(line,"^");
	  setName(st.nextToken());
	  setJDBCDriver(st.nextToken());
	  setDbUrl(st.nextToken());
	  setPort(st.nextToken());
	  setGif(st.nextToken());
      } catch (NoSuchElementException nse) { ; }

  }


    public void setName(String name) { this.name=name; }
    public void setJDBCDriver(String jdbcDriver) { this.jdbcDriver = jdbcDriver; }
    public void setDbUrl(String dbUrl) { this.dbUrl = dbUrl; }
    public void setPort(String port ) { this.port = port; }
    public void setGif(String gif) { this.gif = gif; }

    public String getName() { return name; }
    public String getJDBCDriver() { return jdbcDriver; }
    public String getDbUrl() { return dbUrl; }
    public String getPort() { return port; }
    public int getPortAsInt() {
	int i=0;
	try {
	    i = Integer.parseInt(port);
	} catch ( NumberFormatException nfe) { ; }
	return i;
    }
    public String getGif() { return gif; }
    public ImageIcon getImage() {
	try {
	    ImageIcon img = new ImageIcon(JdbcStuff.class.getResource("images"+ File.separator + gif));
	    return img;
	} catch (Exception e) { return  null; }
 
    }

}
