package mysqladmin;

/** 

    CreateTable is a part of Admin

    Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.DefaultCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;



public class CreateTable extends JPanel {

    public JButton create, cancel;
    private JTextField tableName;
    private JTextField fieldName;
    private JTextArea fieldParams;
    private JTextArea sqlStatement;
    private JCheckBox fieldNull;
    private JTabbedPane jt;

    private JTable table;
    private CrTable cr;
    private JComboBox fieldType,primaryKey;
    private Vector fName, fType,fNull,fParam;


    /**
       * Get the value of tableName.
       * @return Value of tableName.
       */
    public String getTableName() {return tableName.getText();}
    
    /**
       * Set the value of tableName.
       * @param v  Value to assign to tableName.
       */
    public void setTableName(String  v) {this.tableName.setText(v);}
    

    private void enterTableName() {
       String v = JOptionPane.showInputDialog(this, "Please enter Tablename");	
       if (  v == null ) { 
	   JOptionPane.showMessageDialog(this, "You have to enter a name");
	   enterTableName();
       }
       setTableName(v);
    }

    private ImageIcon loadImage(String image) {

        ImageIcon img = new ImageIcon(Admin.class.getResource("images"+ java.io.File.separator + image));
        return img;
    }


  


    public CreateTable() {

        fName = new Vector();
	fType = new Vector();
	fNull = new Vector();
        fParam= new Vector();
	
	this.setLayout(new BorderLayout());
	this.add("Center",mainPanel());

    }

    private JPanel mainPanel() {

	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());


       jt = new JTabbedPane();

       JPanel panel2 = new JPanel();
       panel2.setLayout(new BorderLayout());
       panel2.add("North",upperPanel());
       panel2.add("Center",create());
       panel2.add("South",buttonPanel());
       

       jt.add("Table",panel2);

       panel.add("Center",jt);
       return panel;

    }


    private JPanel indices() {

	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());	
	
	panel.add("West",indPanel());
	

	return panel;

    }


    private JPanel indPanel() {

	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());	
	
	FfAlignerLayoutPanel ffp = new FfAlignerLayoutPanel();
	ffp.setNumberOfRows(1);
	ffp.addComponent(new JLabel("Select Field for Primary Key"));
	setPrimaryKey();
	ffp.addComponent(primaryKey);

	panel.add("West",ffp);
	return panel;
    }


    private void setPrimaryKey() {

	primaryKey = new JComboBox();
	for (int i = 0; i < table.getRowCount(); i++) {
	    String s0 = (String)cr.getValueAt(i,0);
	    if ( s0.length() > 0 ) primaryKey.addItem(s0);
	}
	primaryKey.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		sqlStatement.setText(getSqlCommand());
		sqlStatement.updateUI();
		}});
	
    }



    private JPanel sql () {

	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());
	
	sqlStatement = new JTextArea(10,30);
	sqlStatement.setWrapStyleWord(true);
	sqlStatement.setLineWrap(true);
	sqlStatement.setEditable(true);	
        JScrollPane sqlPane = new JScrollPane();
        sqlPane.getViewport().add(sqlStatement);

	panel.add(sqlPane);


	return panel;


    }



    private JPanel upperPanel() {

	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());
	panel.add("North",enterTable());
	panel.add("Center",fieldPanel());
	return panel;

    }

    private JPanel buttonPanel() {

	create = new JButton("Create Table");
	create.setToolTipText("this will create the table");

	cancel = new JButton("Cancel");
	cancel.setToolTipText("leave it");


	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());

	panel.add(create);
	panel.add(cancel);
	return panel;
    }

    private JPanel enterTable() {

	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());
	panel.add(new JLabel("Tablename:"));

	tableName = new JTextField(20);
	panel.add(tableName);


	panel.setBorder(BorderFactory.createEtchedBorder());
	return panel;
    }



    private JPanel fieldPanel() {
	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());

	JPanel panel2 =  new JPanel();;
	panel2.setLayout(new BorderLayout());
	JButton addF = new JButton("add Field");
	addF.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		addRow();
		}});
	panel2.add("North",addF);

	JButton sqlCmd = new JButton("Extended");
	sqlCmd.setToolTipText("press this Button, to perform additional creation tasks");
	sqlCmd.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {

		try {
		    jt.removeTabAt(1);
		    jt.removeTabAt(1);
		} catch (Exception ex) { ; }

		jt.add("Indexes",indices());
		jt.add("SQL-Statement",sql());
		sqlStatement.setText(getSqlCommand());
		sqlStatement.updateUI();
		jt.updateUI();
	}});
	panel2.add("South",sqlCmd);

      
        JLabel l = new JLabel(loadImage("mysql-06.gif"));
        panel2.add("Center",l);

	panel.add("Center",fieldDefs());
	panel.add("East",panel2);
	

	clearFieldEntry();

	return panel;
    }


    private JPanel fieldDefs() {
	JPanel panel = new JPanel();
	panel.setLayout (new GridBagLayout ());
	GridBagConstraints gridBagConstraints1;
	panel.setBorder(BorderFactory.createEtchedBorder());


	JLabel jLabel1 = new JLabel ();
	jLabel1.setText ("Field Name");
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.anchor=GridBagConstraints.EAST;

	panel.add (jLabel1, gridBagConstraints1);


	fieldName = new JTextField ();
	fieldName.setColumns (20);
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.gridwidth = 0;
	gridBagConstraints1.anchor=GridBagConstraints.WEST;

	panel.add (fieldName, gridBagConstraints1);

	JLabel jLabel2 = new JLabel ();
	jLabel2.setText ("Field Typ");
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.anchor=GridBagConstraints.EAST;

	panel.add (jLabel2, gridBagConstraints1);

	String[] items = { "CHAR","VARCHAR","BLOB",
			   "INT","FLOAT","DOUBLE",
			   "ENUM","SET",
			   "DATE","DATETIME","TIMESTAMP"};
	fieldType = new JComboBox (items);
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.gridwidth = 0;
	gridBagConstraints1.anchor=GridBagConstraints.WEST;

	panel.add (fieldType, gridBagConstraints1);

	JLabel jLabel3 = new JLabel ();
	jLabel3.setText ("length/parameters");
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.anchor=GridBagConstraints.EAST;

	panel.add (jLabel3, gridBagConstraints1);

	fieldParams = new JTextArea (2,20);
	fieldParams.setLineWrap(true);

	JScrollPane scrollpane = new JScrollPane(fieldParams,
        	ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
                ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);

	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.gridwidth = 0;
	gridBagConstraints1.anchor=GridBagConstraints.WEST;

	panel.add (scrollpane, gridBagConstraints1);

	JLabel jLabel4 = new JLabel ();
	jLabel4.setText ("not Null");
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.anchor=GridBagConstraints.EAST;

	panel.add (jLabel4, gridBagConstraints1);

	fieldNull = new JCheckBox ();
	gridBagConstraints1 = new GridBagConstraints ();
	gridBagConstraints1.anchor=GridBagConstraints.WEST;

	panel.add (fieldNull, gridBagConstraints1);
	return panel;

    }


    private JPanel create() {

	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());

	cr = new CrTable();
	table = new JTable(cr);

        JScrollPane scrollpane = new JScrollPane(table);
        //scrollpane.getViewport().add(table);
        table.setPreferredScrollableViewportSize(new Dimension(400, 70));

	
	table.getTableHeader().setReorderingAllowed(false);
	table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(fieldType));
	fitTableSize();



	panel.add(scrollpane);
	return panel;

    }
 
    private void fitTableSize() {
	for (int i = 0; i< 4; i++ ) {
	        table.getColumnModel().getColumn(i).setHeaderValue(cr.getColumnName(i));
	    	table.getColumnModel().getColumn(i).sizeWidthToFit();
	}

    }



    private void addRow() {
      if (fieldName.getText().length() > 1) {
	Vector v = new Vector();

	String v1= fieldName.getText();
	v.addElement(v1);

	fName.addElement(fieldName.getText());

	v.addElement((String)fieldType.getSelectedItem());
	fType.addElement((String)fieldType.getSelectedItem());

	Boolean v3 = new Boolean(fieldNull.isSelected());
	v.addElement(v3);
	fNull.addElement(v3);


	String v4 = fieldParams.getText();
	v.addElement(v4);
	fParam.addElement(v4);

	cr.addRow(v);

	//table.setModel(cr);
	/**
	table.getTableHeader().setReorderingAllowed(false);
	table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
	table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(fieldType));
	**/
	fitTableSize();

	clearFieldEntry();
      }	else { 
	  message("It makes sense to use a longer name..");
      }
    }

    private void clearFieldEntry() {
	fieldName.setText(null);
	fieldParams.setText(null);
	fieldNull.setSelected(false);
	fieldType.setSelectedIndex(0);

    }
   private void message(String msg) {
        //JOptionPane.showMessageDialog(this, msg);
        JOptionPane.showMessageDialog(null, msg,"Message",JOptionPane.WARNING_MESSAGE);
    }


    public String getSqlCommand() {

	String cmd;

	if ( tableName.getText().length() > 0) {
	cmd = "CREATE TABLE " + tableName.getText() + " (";
	for (int i = 0; i < table.getRowCount(); i++) {

	    String s0 = (String)cr.getValueAt(i,0);
	    if ( s0.length() > 0 ) {
		if ( i >0) cmd = cmd + ",";
		cmd = cmd + " " + (String)table.getValueAt(i,0) + " " +
		      (String)cr.getValueAt(i,1);
	    
	        String s = (String)table.getValueAt(i,3);
	        if ( s.length() > 0 )  cmd = cmd + "(" + s + ")";
	    
	        Boolean b = (Boolean)table.getValueAt(i,2);
 	        if ( b.booleanValue() ) cmd = cmd + " NOT NULL";
	    }
	}

	// let's now add the primary Key....
	try {
	    if ( primaryKey.getItemCount() > 0 ) {
		cmd = cmd + ", PRIMARY KEY  (" + primaryKey.getSelectedItem().toString() + ")";
	    }
	} catch (Exception a_exception) { ; }


	// at this place we create index


	cmd = cmd + " )";


	} else { 
          message("a table needs a name!");
	  cmd = null;
	}
	return cmd;

    }

    public static void main(String args[]) {

	JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
	CreateTable panel = new CreateTable();
        frame.getContentPane().add("Center", panel);
	frame.pack();
        frame.setVisible(true);



    }

}

	
	
