package mysqladmin;

/** AutoForm:
 *  Version 1.0 21. February 1999
 *  is a part of Admin
 *
 *  this has been created to query mySQL-Databases
 *  it only returns a JPanel, so it can easily be
 *  used in different kind of windows
 */


/** Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JPanel; 
import javax.swing.JFrame;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;

public class AutoForm extends JPanel {

    private JList tableList;
    private String[] columnName;
    private String[] columnType;
    private int[] columnLength;
    private JTextField[] fieldEdit;
    private JTextArea[]  fieldArea;
    private boolean[] fieldIsArea;
    private String host;
    private JPanel mainpanel,formpanel,findPanel;
    private sqlTable sqlt;
    public Dimension vSize;
    private JScrollPane scrollFpane;


    /**
       * Get the value of host.
       * @return Value of host.
       */
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    
    public JButton cancel;

    /** to find out, when the user wants to close
     *  this application, set a listener onto (JButton)AutoForm.cancel 
     **/

    private String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    

    private String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}


    private String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    
    private String dbTable;
    
    /**
       * Get the value of dbTable.
       * @return Value of dbTable.
       */
    public String getDbTable() {
	dbTable = tableList.getSelectedValue().toString();
	return dbTable;
    }
    
    /**
       * Set the value of dbTable.
       * @param v  Value to assign to dbTable.
       */
    public void setDbTable(String  v) {this.dbTable = v;}
       

    public AutoForm  (String host,String user, String password, String database) {
	setHost(host);
	setUser(user);
	setPassword(password);
	setDatabase(database);

	vSize = new Dimension(400,150);


	this.setLayout(new BorderLayout());
	this.add("West",selectTable());
	this.add("South",buttonPanel());
	this.add("Center",mainPanel());
    }

    private JPanel mainPanel() {

	mainpanel = new JPanel();
	mainpanel.setLayout(new BorderLayout());
	formpanel = formPanel();
	mainpanel.add("Center",formpanel);
  
	return mainpanel;
    }


    /** this is the List that contains the available tables in
     *  the Database
     */

    private JPanel selectTable() {
       String[] table;	
       tableList = new JList();
       t_connect con = new t_connect(getHost(), getUser(), getPassword(),getDatabase());
       if (con.getError() != null) {
           message(con.getError());
       } else {
	   try {
	       DatabaseMetaData md = con.con.getMetaData();
	       ResultSet r = md.getTables(getDatabase(),null,null,null);
	       int i = 0;
	       while (r.next()) { i++;}

	       ResultSet rs = md.getTables(getDatabase(),null,null,null);
	       table = new String[i];
	       i = 0;
	       while (rs.next()) {
		   table[i] = rs.getString(3);
		   i++;
	       }
	       tableList.setListData(table);	       
	   } catch (Exception exception) {
	     message(exception.getMessage().toString());
	   }
       }

       // set the Listener onto the table-List
       MouseListener mouseListener = new MouseAdapter() {
       public void mouseClicked(MouseEvent e) {
         if (e.getClickCount() == 2) {
	     doUpdate();
	 }
       }};
       tableList.addMouseListener(mouseListener);
        
       JScrollPane listPane = new JScrollPane();
       listPane.getViewport().add(tableList);
       tableList.setSelectedIndex(0);

       JPanel panel = new JPanel();
       panel.add(listPane);
       return panel;
    }


    private void doUpdate() {
	mainpanel.remove(formpanel);
	try {
	    mainpanel.remove(findPanel);
	} catch (Exception e) { ; }
	formpanel = formPanel();
	mainpanel.add("Center",formpanel);
	mainpanel.updateUI();
    }

    private JPanel buttonPanel() {

	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());
	panel.setBorder(BorderFactory.createEtchedBorder());

	JButton find = new JButton("Find");
	find.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		listTable();
	}});
 


	JButton insert = new JButton("Insert");
	insert.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		execQuery(createInsertQuery());
	}});
 
	JButton modify = new JButton("Modify");
	modify.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		execQuery(createModifyQuery());
	}});
 
	JButton delete = new JButton("Delete");
	delete.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String string1 = "Yes";
		String string2 = "No";
		Object[] options = {string1, string2};
		int n = JOptionPane.showOptionDialog(null,
                              "Do you really want to delete?",
                              "Delete  ?",
                              JOptionPane.YES_NO_OPTION,
                              JOptionPane.QUESTION_MESSAGE,
                              null,     //don't use a custom Icon
                              options,  //the titles of buttons
                              string2); //the title of the default button
		if (n == JOptionPane.YES_OPTION) {
		    execQuery(createDeleteQuery());
		    doUpdate();
		}
		}});
	
	cancel = new JButton("Cancel");

	panel.add(find);
	panel.add(insert);
	panel.add(modify);
	panel.add(delete);
	panel.add(cancel);
	
	return panel;

    }



    /** this fills the columns with the actual selected table
     **/
    private void setColumns() {
       String[] columns;	
       int i = 0;

       t_connect con = new t_connect(getHost(), getUser(), getPassword(),getDatabase());
       if (con.getError() != null) {
           message(con.getError());
	  
       } else {
	   try {
	       
	       // this is to count the columns to create the array...
	       DatabaseMetaData md = con.con.getMetaData();
	       ResultSet cc = md.getColumns(null,null,getDbTable(),"%");
	       while (cc.next()) { i++;}


	       ResultSet cols = md.getColumns(null,null,getDbTable(),"%");
	       columnName     = new String[i];
	       columnType     = new String[i];
	       columnLength   = new int[i];
	       fieldEdit      = new JTextField[i];
	       fieldArea      = new JTextArea[i];
	       fieldIsArea    = new boolean[i];

	       i = 0;
	       while (cols.next()) {
		   columnName[i]   = cols.getString(4);
		   columnType[i]   = cols.getString(5);
		   columnLength[i] = cols.getInt(7);
		   i++;
	       }  
 	   } catch (Exception exception) {
	     message(exception.getMessage().toString());
	   }
       }   
    }

    private JPanel formPanel() {

	setColumns();
	fieldEditor();
	Insets insets = new Insets(5,5,5,5);
	JPanel panel = new JPanel();
	panel.setLayout(new GridBagLayout());

	GridBagConstraints gridBagConstraints1;
	for (int i = 0; i < columnName.length; i++) {
	    gridBagConstraints1 = new GridBagConstraints ();
	    gridBagConstraints1.anchor=GridBagConstraints.NORTHEAST;
	    gridBagConstraints1.insets = insets;
	    panel.add((JLabel) new JLabel(columnName[i]),gridBagConstraints1);	    
	    gridBagConstraints1 = new GridBagConstraints ();
	    gridBagConstraints1.gridwidth = 0;
	    gridBagConstraints1.anchor=GridBagConstraints.WEST;
	    gridBagConstraints1.insets = insets;

	    if (fieldIsArea[i] ) {
		panel.add(renderer(i),gridBagConstraints1);
		//panel.add(fieldArea[i],gridBagConstraints1 );
	    } else {
		fieldEdit[i].setAlignmentY(Component.LEFT_ALIGNMENT);
		panel.add(fieldEdit[i],gridBagConstraints1);
	    }
	}

	scrollFpane = new JScrollPane(panel);
	//scrollpane.getViewport().setExtentSize(getVSize());
	//scrollpane.getViewport().add(panel);
	scrollFpane.setPreferredSize(getVSize());

	JPanel panel2 = new JPanel();
	panel2.setLayout(new FlowLayout());
	//panel2.setSize(getVSize());
	panel2.add(scrollFpane);

	return panel2;
    }

    public void setVSize(int x, int y) { vSize.setSize(x,y); }
    public Dimension getVSize() { return vSize; }
    public void setFormSize() { scrollFpane.setPreferredSize(getVSize());}

    private JPanel renderer(int i) {
	    fieldArea[i].setWrapStyleWord(true);
	    fieldArea[i].setLineWrap(true);
	    JScrollPane scrollpane = new JScrollPane();
	    scrollpane.getViewport().add(fieldArea[i]);
	    JPanel panel = new JPanel();
	    panel.setLayout(new FlowLayout());
	    panel.add(scrollpane);
	    panel.setAlignmentY(Component.LEFT_ALIGNMENT);
	    return panel;
    }

    private void fieldEditor() {


	for (int i=0; i < columnName.length; i++ ) {
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.CHAR ) {
	       setField(i);
		   fieldIsArea[i]  = false;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.VARCHAR ) {
	       setField(i);
	       fieldIsArea[i]  = false;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.LONGVARCHAR ) {
	       setArea(i);
	       fieldIsArea[i]  = true;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.BINARY ) {
	       setArea(i);
	       fieldIsArea[i]  = true;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.LONGVARBINARY ) {
	       setArea(i);
	       fieldIsArea[i]  = true;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.VARBINARY ) {
	       setArea(i);
	       fieldIsArea[i]  = true;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.DATE ) {
	       setField(i);
	       fieldIsArea[i]  = false;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.TIME )  {
	       setField(i);
	       fieldIsArea[i]  = false;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.TIMESTAMP ) {
	       setField(i);
	       fieldIsArea[i]  = false;
	   }
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.OTHER ) {
	       setField(i);
	       fieldIsArea[i]  = false;
	   }       
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.INTEGER ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }       
	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.BIGINT ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.DECIMAL ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }      
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.DOUBLE ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }      
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.FLOAT ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }      
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.NUMERIC ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }    
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.REAL ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }       
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.SMALLINT ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }    
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.TINYINT ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }   
       	   if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.BIT ) {
	       setNumber(i);
	       fieldIsArea[i]  = false;
	   }     
    }

    }


    private void setField(int i) {
	fieldEdit[i] = new JTextField();
	int k = columnLength[i];
	if ( k >40 ) k = 40;
	fieldEdit[i].setColumns(k); 
    }
    private void setArea(int i) {
	fieldArea[i] = new JTextArea();
	fieldArea[i].setColumns(20);
	fieldArea[i].setRows(5);
    }
    private void setNumber(int i)  { 
	fieldEdit[i] = new JTextField();
	fieldEdit[i].setColumns(10); 
    }

    private void message(String msg) {
        JOptionPane.showMessageDialog(null, msg,"Message",JOptionPane.WARNING_MESSAGE);
    }


    private void execQuery(String query) {
	t_connect con = new t_connect(getHost(),getUser(),getPassword(),getDatabase());
	try {
	     int records = con.stmt.executeUpdate(query);
	     con.close();
	} catch (Exception excpt) {
	    message(excpt.getMessage().toString());
	}
    }


    public String createInsertQuery() {
	String query;
	query = "insert into " + getDbTable() + " (";
	for (int i =0; i < columnName.length; i++ ) {
	    if (i > 0) query = query + ", ";
	    query = query + columnName[i];
	}
	query = query + ") values (";

	for (int j =0; j < columnName.length;j++) {
	    if (j > 0 ) query = query + ", ";
	    query = query + fieldType(j);
	    if (fieldIsArea[j]) {
		query = query + fieldArea[j].getText();
	    } else {
		query = query + fieldEdit[j].getText();
	    }
	    query = query + fieldType(j);
	}
	query = query + ")";
	return query;

    }


    public String createModifyQuery() {
	String query;
	query = "update " + getDbTable() + " set ";
	for (int i =0; i < columnName.length; i++) {
	    if (i > 0) query = query + ",";
	    query = query + columnName[i] + "=" + fieldType(i);
	    if (fieldIsArea[i]) {
		query = query + fieldArea[i].getText();
	    } else {
		query = query + fieldEdit[i].getText();
	    }
	    query = query + fieldType(i);	    
	}
	int pk = getPrimaryKey();
	query = query + " where " + columnName[pk] + "=" + fieldType(pk);
	    if (fieldIsArea[pk]) {
		query = query + fieldArea[pk].getText();
	    } else {
		query = query + fieldEdit[pk].getText();
	    }
	    query = query + fieldType(pk);
	
	return query;
    }

    public String createDeleteQuery() {
	String query;
	int pk = getPrimaryKey();
	query = "delete from " + getDbTable() + " where " + columnName[pk] + " = " + fieldType(pk);
        if (fieldIsArea[pk]) {
	  query = query + fieldArea[pk].getText();
	} else {
	  query = query + fieldEdit[pk].getText();
	}
	query = query + fieldType(pk);
	return query;	

    }


    public int getPrimaryKey() {
       int ind=0;
       t_connect con = new t_connect(getHost(), getUser(), getPassword(),getDatabase());
       if (con.getError() != null) {
           message(con.getError());
       } else {
	   try {
	       DatabaseMetaData db = con.con.getMetaData();	
	       ResultSet keys = db.getPrimaryKeys("",getDatabase(),getDbTable());
	       ind = getTableIndex(keys.getString(4));
       }  catch (Exception exception) {
	     message("Finding Primary Key \n"+ exception.getMessage().toString());
       }
       }
       return ind;
    }

    private int getTableIndex(String name) {
	int ind=0;
	for (int i=0;i < columnName.length; i++) {
	    if (columnName[i].compareTo(name) == 0) ind = i;
	}
	return ind;
    }

    private String fieldType(int i) {

       String ft=" ";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.CHAR ) ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.VARCHAR ) ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.LONGVARCHAR )    ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.BINARY )  ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.LONGVARBINARY )   ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.VARBINARY ) ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.DATE ) ft="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.TIME ) ft ="'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.TIMESTAMP ) ft = "'";
       if ( Integer.parseInt(columnType[i]) ==  java.sql.Types.OTHER ) ft = "'";
       return ft;

    }

    private void listTable() {
	findPanel = new JPanel();
	findPanel.setLayout(new FlowLayout());

	sqlt = new sqlTable(getHost(),getUser(),getPassword(),getDatabase(),"select * from " + getDbTable());
	sqlt.tableView.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
	    public void valueChanged(ListSelectionEvent e) {
		String text=" ";
		for (int i = 0; i < columnName.length; i++) {
		    text = sqlt.tableView.getValueAt(sqlt.tableView.getSelectedRow(),i).toString();
		    if ( fieldIsArea[i] ) {
			fieldArea[i].setText(text);
		    } else {
			fieldEdit[i].setText(text);
		    }
		}
		sqlt.dispose();
		mainpanel.remove(findPanel);
		mainpanel.updateUI();
	    }});


	 JScrollPane scrollpane = new JScrollPane(sqlt.tableView);
         Dimension d = new Dimension(400,80);
         sqlt.tableView.setPreferredScrollableViewportSize(d);
	 
	 findPanel.add(scrollpane);
	 mainpanel.add("South",findPanel);
	 mainpanel.updateUI();
    }

    private void setPanelReserved(boolean b) { 	this.setEnabled(b); }



}

    
